/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public abstract class FunctionCall
extends ComputedExpression {
    private int nameCode;
    protected Expression[] argument;

    public final void setFunctionNameCode(int n) {
        this.nameCode = n;
    }

    public final int getFunctionNameCode() {
        return this.nameCode;
    }

    public final int getNumberOfArguments() {
        return this.argument.length;
    }

    public void setArguments(Expression[] expressionArray) {
        this.argument = expressionArray;
        int n = 0;
        while (n < expressionArray.length) {
            this.adoptChildExpression(expressionArray[n]);
            ++n;
        }
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        return this.simplifyArguments(staticContext);
    }

    protected final Expression simplifyArguments(StaticContext staticContext) throws XPathException {
        int n = 0;
        while (n < this.argument.length) {
            Expression expression = this.argument[n].simplify(staticContext);
            if (expression != this.argument[n]) {
                this.adoptChildExpression(expression);
                this.argument[n] = expression;
            }
            ++n;
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        boolean bl = true;
        int n = 0;
        while (n < this.argument.length) {
            Expression expression = this.argument[n].analyze(staticContext, itemType);
            if (expression != this.argument[n]) {
                this.adoptChildExpression(expression);
                this.argument[n] = expression;
            }
            if (!(this.argument[n] instanceof Value)) {
                bl = false;
            }
            ++n;
        }
        this.checkArguments(staticContext);
        if (bl) {
            return this.preEvaluate(staticContext);
        }
        return this;
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        return ExpressionTool.eagerEvaluate(this, null);
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13) {
            int n = 0;
            while (n < this.argument.length) {
                this.argument[n] = this.argument[n].promote(promotionOffer);
                ++n;
            }
        }
        return this;
    }

    protected abstract void checkArguments(StaticContext var1) throws XPathException;

    protected int checkArgumentCount(int n, int n2, StaticContext staticContext) throws XPathException {
        int n3 = this.argument.length;
        if (n == n2 && n3 != n) {
            throw new StaticError("Function " + this.getDisplayName(staticContext.getNamePool()) + " must have " + n + FunctionCall.pluralArguments(n), ExpressionTool.getLocator(this));
        }
        if (n3 < n) {
            throw new StaticError("Function " + this.getDisplayName(staticContext.getNamePool()) + " must have at least " + n + FunctionCall.pluralArguments(n), ExpressionTool.getLocator(this));
        }
        if (n3 > n2) {
            throw new StaticError("Function " + this.getDisplayName(staticContext.getNamePool()) + " must have no more than " + n2 + FunctionCall.pluralArguments(n2), ExpressionTool.getLocator(this));
        }
        return n3;
    }

    private static String pluralArguments(int n) {
        if (n == 1) {
            return " argument";
        }
        return " arguments";
    }

    public Iterator iterateSubExpressions() {
        return Arrays.asList(this.argument).iterator();
    }

    public final String getDisplayName(NamePool namePool) {
        return namePool.getDisplayName(this.getFunctionNameCode());
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "function " + this.getDisplayName(namePool));
        int n2 = 0;
        while (n2 < this.argument.length) {
            this.argument[n2].display(n + 1, namePool, printStream);
            ++n2;
        }
    }
}

