/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Comparator;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.NamePart;
import net.sf.saxon.functions.Position;
import net.sf.saxon.functions.StringLength;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public final class ValueComparison
extends BinaryExpression {
    private AtomicComparer comparer;

    public ValueComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        Comparator comparator;
        Object object;
        int n;
        int n2;
        this.operand0 = this.operand0.analyze(staticContext, itemType);
        if (this.operand0 instanceof EmptySequence) {
            return this.operand0;
        }
        this.operand1 = this.operand1.analyze(staticContext, itemType);
        if (this.operand1 instanceof EmptySequence) {
            return this.operand1;
        }
        SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, false, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, false, roleLocator2, staticContext);
        AtomicType atomicType = this.operand0.getItemType().getAtomizedItemType();
        AtomicType atomicType2 = this.operand1.getItemType().getAtomizedItemType();
        int n3 = atomicType.getPrimitiveType();
        if (n3 == 642) {
            n3 = 513;
        }
        if ((n2 = atomicType2.getPrimitiveType()) == 642) {
            n2 = 513;
        }
        if (!Type.isComparable(n3, n2)) {
            boolean bl = Cardinality.allowsZero(this.operand0.getCardinality());
            n = Cardinality.allowsZero(this.operand1.getCardinality());
            if (bl || n != 0) {
                try {
                    object = null;
                    if (bl) {
                        object = "the first operand is";
                    }
                    if (n != 0) {
                        object = "the second operand is";
                    }
                    if (bl && n != 0) {
                        object = "one or both operands are";
                    }
                    staticContext.issueWarning("Comparison of " + atomicType.toString(staticContext.getNamePool()) + (bl ? "?" : "") + " to " + atomicType2.toString(staticContext.getNamePool()) + (n != 0 ? "?" : "") + " will fail unless " + (String)object + " empty");
                }
                catch (Exception exception) {}
            } else {
                StaticError staticError = new StaticError("Cannot compare " + atomicType.toString(staticContext.getNamePool()) + " to " + atomicType2.toString(staticContext.getNamePool()));
                staticError.setIsTypeError(true);
                throw staticError;
            }
        }
        if (this.operator != 44 && this.operator != 45) {
            if (!Type.isOrdered(n3)) {
                StaticError staticError = new StaticError("Type " + atomicType.toString(staticContext.getNamePool()) + " is not an ordered type");
                staticError.setIsTypeError(true);
                throw staticError;
            }
            if (!Type.isOrdered(n2)) {
                StaticError staticError = new StaticError("Type " + atomicType2.toString(staticContext.getNamePool()) + " is not an ordered type");
                staticError.setIsTypeError(true);
                throw staticError;
            }
        }
        if ((comparator = staticContext.getCollation(staticContext.getDefaultCollationName())) == null) {
            comparator = CodepointCollator.getInstance();
        }
        this.comparer = new AtomicComparer(comparator);
        if (Aggregate.isCountFunction(this.operand0) && this.operand1 instanceof AtomicValue) {
            if (ValueComparison.isZero(this.operand1)) {
                if (this.operator == 44 || this.operator == 49) {
                    FunctionCall functionCall = SystemFunction.makeSystemFunction("empty", staticContext.getNamePool());
                    object = new Expression[]{((FunctionCall)this.operand0).argument[0]};
                    functionCall.setArguments((Expression[])object);
                    return functionCall;
                }
                if (this.operator == 45 || this.operator == 46) {
                    FunctionCall functionCall = SystemFunction.makeSystemFunction("exists", staticContext.getNamePool());
                    object = new Expression[]{ExpressionTool.unsorted(((FunctionCall)this.operand0).argument[0], false)};
                    functionCall.setArguments((Expression[])object);
                    return functionCall;
                }
                if (this.operator == 48) {
                    return BooleanValue.TRUE;
                }
                return BooleanValue.FALSE;
            }
            if (this.operand1 instanceof IntegerValue && (this.operator == 46 || this.operator == 48)) {
                long l = ((IntegerValue)this.operand1).longValue();
                if (this.operator == 46) {
                    ++l;
                }
                FunctionCall functionCall = SystemFunction.makeSystemFunction("exists", staticContext.getNamePool());
                Expression[] expressionArray = new Expression[1];
                FilterExpression filterExpression = new FilterExpression(((FunctionCall)this.operand0).argument[0], new IntegerValue(l), staticContext);
                expressionArray[0] = filterExpression;
                functionCall.setArguments(expressionArray);
                return functionCall;
            }
        }
        if (Aggregate.isCountFunction(this.operand1) && ValueComparison.isZero(this.operand0)) {
            Expression expression = new ValueComparison(this.operand1, Value.inverse(this.operator), this.operand0).analyze(staticContext, itemType);
            return expression;
        }
        if (this.operand0 instanceof StringLength && ((StringLength)this.operand0).getNumberOfArguments() == 1 && ValueComparison.isZero(this.operand1)) {
            ((StringLength)this.operand0).setShortcut();
        }
        if (this.operand1 instanceof StringLength && ((StringLength)this.operand1).getNumberOfArguments() == 1 && ValueComparison.isZero(this.operand0)) {
            ((StringLength)this.operand1).setShortcut();
        }
        if (this.operand0 instanceof Position && this.operand1 instanceof IntegerValue) {
            n = (int)((IntegerValue)this.operand1).longValue();
            if (n < 0) {
                n = 0;
            }
            switch (this.operator) {
                case 44: {
                    return new PositionRange(n, n);
                }
                case 48: {
                    return new PositionRange(n, Integer.MAX_VALUE);
                }
                case 45: {
                    if (n != 1) break;
                    return new PositionRange(2, Integer.MAX_VALUE);
                }
                case 47: {
                    return new PositionRange(1, n - 1);
                }
                case 46: {
                    return new PositionRange(n + 1, Integer.MAX_VALUE);
                }
                case 49: {
                    return new PositionRange(1, n);
                }
            }
        }
        if (this.operand0 instanceof IntegerValue && this.operand1 instanceof Position) {
            long l = ((IntegerValue)this.operand0).longValue();
            if (l < 0L) {
                l = 0L;
            }
            if (l < Integer.MAX_VALUE) {
                switch (this.operator) {
                    case 44: {
                        return new PositionRange((int)l, (int)l);
                    }
                    case 49: {
                        return new PositionRange((int)l, Integer.MAX_VALUE);
                    }
                    case 45: {
                        if (l != 1L) break;
                        return new PositionRange(2, Integer.MAX_VALUE);
                    }
                    case 46: {
                        return new PositionRange(1, (int)l - 1);
                    }
                    case 47: {
                        return new PositionRange((int)l + 1, Integer.MAX_VALUE);
                    }
                    case 48: {
                        return new PositionRange(1, (int)l);
                    }
                }
            }
        }
        if (this.operand0 instanceof Position && this.operand1 instanceof Last) {
            switch (this.operator) {
                case 44: 
                case 48: {
                    return new IsLastExpression(true);
                }
                case 45: 
                case 47: {
                    return new IsLastExpression(false);
                }
                case 46: {
                    return BooleanValue.FALSE;
                }
                case 49: {
                    return BooleanValue.TRUE;
                }
            }
        }
        if (this.operand0 instanceof Last && this.operand1 instanceof Position) {
            switch (this.operator) {
                case 44: 
                case 49: {
                    return new IsLastExpression(true);
                }
                case 45: 
                case 46: {
                    return new IsLastExpression(false);
                }
                case 47: {
                    return BooleanValue.FALSE;
                }
                case 48: {
                    return BooleanValue.TRUE;
                }
            }
        }
        if (NamePart.isGenerateIdFunction(this.operand0) && NamePart.isGenerateIdFunction(this.operand1)) {
            FunctionCall functionCall = (FunctionCall)this.operand0;
            object = (FunctionCall)this.operand1;
            if (!Cardinality.allowsMany(functionCall.argument[0].getCardinality()) && !Cardinality.allowsMany(object.argument[0].getCardinality()) && this.operator == 44) {
                IdentityComparison identityComparison = new IdentityComparison(functionCall.argument[0], 20, object.argument[0]);
                identityComparison.setGenerateIdEmulation(true);
                return identityComparison.simplify(staticContext).analyze(staticContext, itemType);
            }
        }
        if (this.operand0 instanceof Value && this.operand1 instanceof Value) {
            return (AtomicValue)this.evaluateItem(null);
        }
        return this;
    }

    private static boolean isZero(Expression expression) {
        try {
            if (!(expression instanceof AtomicValue)) {
                return false;
            }
            if (expression instanceof IntegerValue) {
                return ((IntegerValue)expression).longValue() == 0L;
            }
            if (expression instanceof BigIntegerValue) {
                return ((BigIntegerValue)expression).compareTo(BigIntegerValue.ZERO) == 0;
            }
            AtomicValue atomicValue = ((AtomicValue)expression).convert(532, null);
            return ValueComparison.isZero(atomicValue);
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        try {
            AtomicValue atomicValue;
            AtomicValue atomicValue2 = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return false;
            }
            if (atomicValue2 instanceof UntypedAtomicValue) {
                atomicValue2 = atomicValue2.convert(513, xPathContext);
            }
            if ((atomicValue = (AtomicValue)this.operand1.evaluateItem(xPathContext)) == null) {
                return false;
            }
            if (atomicValue instanceof UntypedAtomicValue) {
                atomicValue = atomicValue.convert(513, xPathContext);
            }
            return ValueComparison.compare(atomicValue2, this.operator, atomicValue, this.comparer);
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            throw dynamicError;
        }
    }

    protected static boolean compare(AtomicValue atomicValue, int n, AtomicValue atomicValue2, AtomicComparer atomicComparer) throws DynamicError {
        if (atomicValue instanceof NumericValue && ((NumericValue)atomicValue).isNaN()) {
            return false;
        }
        if (atomicValue2 instanceof NumericValue && ((NumericValue)atomicValue2).isNaN()) {
            return false;
        }
        try {
            switch (n) {
                case 44: {
                    return atomicComparer.comparesEqual(atomicValue, atomicValue2);
                }
                case 45: {
                    return !atomicComparer.comparesEqual(atomicValue, atomicValue2);
                }
                case 46: {
                    return atomicComparer.compare(atomicValue, atomicValue2) > 0;
                }
                case 47: {
                    return atomicComparer.compare(atomicValue, atomicValue2) < 0;
                }
                case 48: {
                    return atomicComparer.compare(atomicValue, atomicValue2) >= 0;
                }
                case 49: {
                    return atomicComparer.compare(atomicValue, atomicValue2) <= 0;
                }
            }
            throw new UnsupportedOperationException("Unknown operator " + n);
        }
        catch (ClassCastException classCastException) {
            DynamicError dynamicError = new DynamicError("Cannot compare " + atomicValue.getItemType() + " to " + atomicValue2.getItemType());
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        try {
            AtomicValue atomicValue;
            AtomicValue atomicValue2 = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            if (atomicValue2 instanceof UntypedAtomicValue) {
                atomicValue2 = atomicValue2.convert(513, xPathContext);
            }
            if ((atomicValue = (AtomicValue)this.operand1.evaluateItem(xPathContext)) == null) {
                return null;
            }
            if (atomicValue instanceof UntypedAtomicValue) {
                atomicValue = atomicValue.convert(513, xPathContext);
            }
            return BooleanValue.get(ValueComparison.compare(atomicValue2, this.operator, atomicValue, this.comparer));
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            throw dynamicError;
        }
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }
}

