package com.isogen.i18nsupport;

import java.util.Comparator;
import java.util.Locale;

import com.ibm.icu.text.RuleBasedCollator;
import com.isogen.i18nsupport.compare.ComparatorException;
import com.isogen.i18nsupport.compare.ComparatorFactory;
import com.isogen.indexhelper.IndexHelperException;

import junit.framework.TestCase;

public class ComparatorTest extends TestCase {

    ComparatorFactory compFact;

    public ComparatorTest(String arg0) {
		super(arg0);
	}
	
	public void setUp() {
		try {
			compFact = I18nService.constructComparatorFactory();
		} catch (Throwable e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
		
	}
	
	public void testThaiComparator() {
		Locale locale = new Locale("th", "");
		Comparator comparator = null;
		try {
			comparator = compFact.getComparatorForLocale(locale);
		} catch (Throwable e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
		//RuleBasedCollator col = (RuleBasedCollator)comparator;
		// String rules = col.getRules();
		// System.err.println(I18nUtil.escapeUnicodeString(rules));
		assertEquals(-1, comparator.compare("\u0e2d", "\u0e2e"));
		assertEquals(-1, comparator.compare("\u0e2f", "\u0e45"));
		assertEquals(-1, comparator.compare("\u0e2e", "\u0e2f"));
	}
	
	public static void main(String[] args) {
	}

}
