/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.io.Serializable;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.xpath.XPathException;

public abstract class Pattern
implements Serializable,
Container {
    private String originalText;
    private Executable executable;
    private String systemId;
    private int lineNumber;

    public static Pattern make(String string, StaticContext staticContext, Executable executable) throws XPathException {
        Pattern pattern = new ExpressionParser().parsePattern(string, staticContext).simplify(staticContext);
        pattern.setSystemId(staticContext.getSystemId());
        pattern.setLineNumber(staticContext.getLineNumber());
        pattern.setOriginalText(string);
        pattern.setExecutable(executable);
        return pattern;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void setOriginalText(String string) {
        this.originalText = string;
    }

    public Pattern simplify(StaticContext staticContext) throws XPathException {
        return this;
    }

    public Pattern typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        return this;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public abstract boolean matches(NodeInfo var1, XPathContext var2) throws XPathException;

    protected boolean internalMatches(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        return this.matches(nodeInfo, xPathContext);
    }

    public int getNodeKind() {
        return 0;
    }

    public int getFingerprint() {
        return -1;
    }

    public abstract NodeTest getNodeTest();

    public double getDefaultPriority() {
        return 0.5;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public String toString() {
        return this.originalText;
    }
}

