/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ForEach;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.xpath.XPathException;

public class XSLForEach
extends StyleElement {
    Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "select") {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.checkSortComesFirst(false);
        this.select = this.typeCheck("select", this.select);
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        SortKeyDefinition[] sortKeyDefinitionArray = this.makeSortKeys();
        Expression expression = this.select;
        if (sortKeyDefinitionArray != null) {
            expression = new SortExpression(this.select, sortKeyDefinitionArray);
            ExpressionTool.makeParentReferences(expression);
        }
        Block block = new Block();
        this.compileChildren(executable, block, true);
        try {
            ForEach forEach = new ForEach(expression, block.simplify(this.getStaticContext()));
            ExpressionTool.makeParentReferences(forEach);
            return forEach;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

