/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.CalendarAstronomer;
import com.ibm.icu.impl.CalendarCache;
import com.ibm.icu.text.ChineseDateFormat;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.util.Locale;

public class ChineseCalendar
extends Calendar {
    private transient CalendarAstronomer astro = new CalendarAstronomer();
    private transient CalendarCache winterSolsticeCache = new CalendarCache();
    private transient CalendarCache newYearCache = new CalendarCache();
    private transient boolean isLeapYear;
    public static int IS_LEAP_MONTH = 22;
    private static final int FIELD_COUNT = IS_LEAP_MONTH + 1;
    private static final int[][] LIMITS = new int[][]{{1, 1, 83333, 83333}, {1, 1, 70, 70}, {0, 0, 11, 11}, {1, 1, 50, 55}, {1, 1, 5, 6}, {1, 1, 29, 30}, {1, 1, 353, 385}, new int[0], {-1, -1, 5, 5}, new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], new int[0], {-5000001, -5000001, 5000001, 5000001}, new int[0], {-5000000, -5000000, 5000000, 5000000}, new int[0], new int[0], {0, 0, 1, 1}};
    static final int[][][] CHINESE_DATE_PRECEDENCE = new int[][][]{new int[][]{{5}, {3, 7}, {4, 7}, {8, 7}, {3, 18}, {4, 18}, {8, 18}, {6}, {37, IS_LEAP_MONTH}}, new int[][]{{3}, {4}, {8}, {40, 7}, {40, 18}}};
    private static final int CHINESE_EPOCH_YEAR = -2636;
    private static final long CHINA_OFFSET = 28800000L;
    private static final int SYNODIC_GAP = 25;

    public ChineseCalendar() {
    }

    public ChineseCalendar(TimeZone zone, Locale locale) {
        super(zone, locale);
    }

    protected int[] handleCreateFields() {
        return new int[FIELD_COUNT];
    }

    protected int handleGetLimit(int field, int limitType) {
        return LIMITS[field][limitType];
    }

    protected int handleGetExtendedYear() {
        int year;
        if (this.newestStamp(0, 1, 0) <= this.getStamp(19)) {
            year = this.internalGet(19, 1);
        } else {
            int cycle = this.internalGet(0, 1) - 1;
            year = cycle * 60 + this.internalGet(1, 1);
        }
        return year;
    }

    protected int handleGetMonthLength(int extendedYear, int month) {
        int thisStart = this.handleComputeMonthStart(extendedYear, month, true) - 2440588 + 1;
        int nextStart = this.newMoonNear(thisStart + 25, true);
        return nextStart - thisStart;
    }

    protected DateFormat handleGetDateFormat(String pattern, Locale locale) {
        return new ChineseDateFormat(pattern, locale);
    }

    protected int[][][] getFieldResolutionTable() {
        return CHINESE_DATE_PRECEDENCE;
    }

    private void offsetMonth(int newMoon, int dom, int delta) {
        newMoon += (int)(29.530588853 * ((double)delta - 0.5));
        newMoon = this.newMoonNear(newMoon, true);
        int jd = newMoon + 2440588 - 1 + dom;
        if (dom > 29) {
            this.set(20, jd - 1);
            this.complete();
            if (this.getActualMaximum(5) >= dom) {
                this.set(20, jd);
            }
        } else {
            this.set(20, jd);
        }
    }

    public void add(int field, int amount) {
        switch (field) {
            case 2: {
                if (amount == 0) break;
                int dom = this.get(5);
                int day = this.get(20) - 2440588;
                int moon = day - dom + 1;
                this.offsetMonth(moon, dom, amount);
                break;
            }
            default: {
                super.add(field, amount);
            }
        }
    }

    public void roll(int field, int amount) {
        switch (field) {
            case 2: {
                int n;
                int newM;
                if (amount == 0) break;
                int dom = this.get(5);
                int day = this.get(20) - 2440588;
                int moon = day - dom + 1;
                int m = this.get(2);
                if (this.isLeapYear) {
                    if (this.get(IS_LEAP_MONTH) == 1) {
                        ++m;
                    } else {
                        int moon1 = moon - (int)(29.530588853 * ((double)m - 0.5));
                        if (this.isLeapMonthBetween(moon1 = this.newMoonNear(moon1, true), moon)) {
                            ++m;
                        }
                    }
                }
                if ((newM = (m + amount) % (n = this.isLeapYear ? 13 : 12)) < 0) {
                    newM += n;
                }
                if (newM == m) break;
                this.offsetMonth(moon, dom, newM - m);
                break;
            }
            default: {
                super.roll(field, amount);
            }
        }
    }

    private static final long daysToMillis(int days) {
        return (long)days * 86400000L - 28800000L;
    }

    private static final int millisToDays(long millis) {
        return (int)ChineseCalendar.floorDivide(millis + 28800000L, 86400000L);
    }

    private int winterSolstice(int gyear) {
        long cacheValue = this.winterSolsticeCache.get(gyear);
        if (cacheValue == CalendarCache.EMPTY) {
            long ms = ChineseCalendar.daysToMillis(this.computeGregorianMonthStart(gyear, 11) + 1 - 2440588);
            this.astro.setTime(ms);
            long solarLong = this.astro.getSunTime(CalendarAstronomer.WINTER_SOLSTICE, true);
            cacheValue = ChineseCalendar.millisToDays(solarLong);
            this.winterSolsticeCache.put(gyear, cacheValue);
        }
        return (int)cacheValue;
    }

    private int newMoonNear(int days, boolean after) {
        this.astro.setTime(ChineseCalendar.daysToMillis(days));
        long newMoon = this.astro.getMoonTime(CalendarAstronomer.NEW_MOON, after);
        return ChineseCalendar.millisToDays(newMoon);
    }

    private int synodicMonthsBetween(int day1, int day2) {
        return (int)Math.round((double)(day2 - day1) / 29.530588853);
    }

    private int majorSolarTerm(int days) {
        this.astro.setTime(ChineseCalendar.daysToMillis(days));
        int term = ((int)Math.floor(6.0 * this.astro.getSunLongitude() / Math.PI) + 2) % 12;
        if (term < 1) {
            term += 12;
        }
        return term;
    }

    private boolean hasNoMajorSolarTerm(int newMoon) {
        int nmn;
        int mstt;
        int mst = this.majorSolarTerm(newMoon);
        return mst == (mstt = this.majorSolarTerm(nmn = this.newMoonNear(newMoon + 25, true)));
    }

    private boolean isLeapMonthBetween(int newMoon1, int newMoon2) {
        if (this.synodicMonthsBetween(newMoon1, newMoon2) >= 50) {
            throw new IllegalArgumentException("isLeapMonthBetween(" + newMoon1 + ", " + newMoon2 + "): Invalid parameters");
        }
        return newMoon2 >= newMoon1 && (this.isLeapMonthBetween(newMoon1, this.newMoonNear(newMoon2 - 25, false)) || this.hasNoMajorSolarTerm(newMoon2));
    }

    protected void handleComputeFields(int julianDay) {
        this.computeChineseFields(julianDay - 2440588, this.getGregorianYear(), this.getGregorianMonth(), true);
    }

    private void computeChineseFields(int days, int gyear, int gmonth, boolean setAllFields) {
        int solsticeBefore;
        int solsticeAfter = this.winterSolstice(gyear);
        if (days < solsticeAfter) {
            solsticeBefore = this.winterSolstice(gyear - 1);
        } else {
            solsticeBefore = solsticeAfter;
            solsticeAfter = this.winterSolstice(gyear + 1);
        }
        int firstMoon = this.newMoonNear(solsticeBefore + 1, true);
        int lastMoon = this.newMoonNear(solsticeAfter + 1, false);
        int thisMoon = this.newMoonNear(days + 1, false);
        this.isLeapYear = this.synodicMonthsBetween(firstMoon, lastMoon) == 12;
        int month = this.synodicMonthsBetween(firstMoon, thisMoon);
        if (this.isLeapYear && this.isLeapMonthBetween(firstMoon, thisMoon)) {
            --month;
        }
        if (month < 1) {
            month += 12;
        }
        boolean isLeapMonth = this.isLeapYear && this.hasNoMajorSolarTerm(thisMoon) && !this.isLeapMonthBetween(firstMoon, this.newMoonNear(thisMoon - 25, false));
        this.internalSet(2, month - 1);
        this.internalSet(IS_LEAP_MONTH, isLeapMonth ? 1 : 0);
        if (setAllFields) {
            int year = gyear - -2636;
            if (month < 11 || gmonth >= 6) {
                ++year;
            }
            int dayOfMonth = days - thisMoon + 1;
            this.internalSet(19, year);
            int[] yearOfCycle = new int[1];
            int cycle = ChineseCalendar.floorDivide(year - 1, 60, yearOfCycle);
            this.internalSet(0, cycle + 1);
            this.internalSet(1, yearOfCycle[0] + 1);
            this.internalSet(5, dayOfMonth);
            int newYear = this.newYear(gyear);
            if (days < newYear) {
                newYear = this.newYear(gyear - 1);
            }
            this.internalSet(6, days - newYear + 1);
        }
    }

    private int newYear(int gyear) {
        long cacheValue = this.newYearCache.get(gyear);
        if (cacheValue == CalendarCache.EMPTY) {
            int solsticeBefore = this.winterSolstice(gyear - 1);
            int solsticeAfter = this.winterSolstice(gyear);
            int newMoon1 = this.newMoonNear(solsticeBefore + 1, true);
            int newMoon2 = this.newMoonNear(newMoon1 + 25, true);
            int newMoon11 = this.newMoonNear(solsticeAfter + 1, false);
            cacheValue = this.synodicMonthsBetween(newMoon1, newMoon11) == 12 && (this.hasNoMajorSolarTerm(newMoon1) || this.hasNoMajorSolarTerm(newMoon2)) ? (long)this.newMoonNear(newMoon2 + 25, true) : (long)newMoon2;
            this.newYearCache.put(gyear, cacheValue);
        }
        return (int)cacheValue;
    }

    protected int handleComputeMonthStart(int eyear, int month, boolean useMonth) {
        if (month < 0 || month > 11) {
            int[] rem = new int[1];
            eyear += ChineseCalendar.floorDivide(month, 12, rem);
            month = rem[0];
        }
        int gyear = eyear + -2636 - 1;
        int newYear = this.newYear(gyear);
        int newMoon = this.newMoonNear(newYear + month * 29, true);
        int julianDay = newMoon + 2440588;
        int saveMonth = this.internalGet(2);
        int saveIsLeapMonth = this.internalGet(IS_LEAP_MONTH);
        int isLeapMonth = useMonth ? saveIsLeapMonth : 0;
        this.computeGregorianFields(julianDay);
        this.computeChineseFields(newMoon, this.getGregorianYear(), this.getGregorianMonth(), false);
        if (month != this.internalGet(2) || isLeapMonth != this.internalGet(IS_LEAP_MONTH)) {
            newMoon = this.newMoonNear(newMoon + 25, true);
            julianDay = newMoon + 2440588;
        }
        this.internalSet(2, saveMonth);
        this.internalSet(IS_LEAP_MONTH, saveIsLeapMonth);
        return julianDay - 1;
    }

    public String getType() {
        return "chinese";
    }
}

