/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.instruct.SkipInstructionException;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.XPathException;

public final class SimpleContentOutputter
extends Outputter {
    private StringBuffer buffer;
    private int ignoreElements = 0;
    private Configuration config;

    public SimpleContentOutputter(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void characters(CharSequence s, int properties) throws XPathException {
        if (s == null) {
            return;
        }
        if (this.ignoreElements == 0) {
            this.buffer.append(s.toString());
        }
        this.previousAtomic = false;
    }

    public void startElement(int nameCode, int typeCode, int properties) throws XPathException {
        this.recoverableError();
        ++this.ignoreElements;
        this.previousAtomic = false;
    }

    public void namespace(int nscode, int properties) throws XPathException {
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int properties) throws XPathException {
        this.recoverableError();
        this.previousAtomic = false;
    }

    public void startContent() {
    }

    public void endElement() throws XPathException {
        --this.ignoreElements;
        this.previousAtomic = false;
    }

    public void comment(CharSequence comment, int properties) throws XPathException {
        this.recoverableError();
        this.previousAtomic = false;
    }

    public void processingInstruction(String target, CharSequence data, int properties) throws XPathException {
        this.recoverableError();
        this.previousAtomic = false;
    }

    public void append(Item item) throws XPathException {
        if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.characters(" ", 0);
            }
            this.characters(item.getStringValue(), 0);
            this.previousAtomic = true;
        } else if (item instanceof DocumentInfo) {
            Item it;
            AxisIterator iter = ((DocumentInfo)item).iterateAxis((byte)3);
            while ((it = iter.next()) != null) {
                this.append(it);
            }
        } else {
            Item it;
            SequenceIterator iter = item.getTypedValue(this.config);
            while ((it = iter.next()) != null) {
                this.characters(it.getStringValue(), 0);
            }
            this.previousAtomic = false;
        }
    }

    public void endDocument() throws XPathException {
        this.previousAtomic = false;
    }

    private void recoverableError() throws XPathException {
        throw new SkipInstructionException("Non-text output nodes are ignored when writing a text node, attribute, comment, or PI");
    }
}

