/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

class ArithmeticExpression
extends BinaryExpression {
    private static final int NUMERIC_ARITHMETIC = 0;
    private static final int DATE_AND_DURATION = 1;
    private static final int DATE_DIFFERENCE = 2;
    private static final int DURATION_ADDITION = 3;
    private static final int DURATION_MULTIPLICATION = 4;
    private static final int DURATION_DIVISION = 5;
    private static final int UNKNOWN = -1;
    private static Signature[] plusTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.DATE_TYPE, Type.DURATION_TYPE, 1, Type.DATE_TYPE), new Signature(Type.DURATION_TYPE, Type.DATE_TYPE, 1, Type.DATE_TYPE), new Signature(Type.TIME_TYPE, Type.DURATION_TYPE, 1, Type.TIME_TYPE), new Signature(Type.DURATION_TYPE, Type.TIME_TYPE, 1, Type.TIME_TYPE), new Signature(Type.DATE_TIME_TYPE, Type.DURATION_TYPE, 1, Type.DATE_TIME_TYPE), new Signature(Type.DURATION_TYPE, Type.DATE_TIME_TYPE, 1, Type.DATE_TIME_TYPE), new Signature(Type.DURATION_TYPE, Type.DURATION_TYPE, 3, Type.DURATION_TYPE)};
    private static Signature[] minusTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.DATE_TYPE, Type.DATE_TYPE, 2, Type.DAY_TIME_DURATION_TYPE), new Signature(Type.DATE_TYPE, Type.DURATION_TYPE, 1, Type.DATE_TYPE), new Signature(Type.TIME_TYPE, Type.TIME_TYPE, 2, Type.DAY_TIME_DURATION_TYPE), new Signature(Type.TIME_TYPE, Type.DURATION_TYPE, 1, Type.TIME_TYPE), new Signature(Type.DATE_TIME_TYPE, Type.DATE_TIME_TYPE, 2, Type.DAY_TIME_DURATION_TYPE), new Signature(Type.DATE_TIME_TYPE, Type.DURATION_TYPE, 1, Type.DATE_TIME_TYPE), new Signature(Type.DURATION_TYPE, Type.DURATION_TYPE, 3, Type.DURATION_TYPE)};
    private static Signature[] multiplyTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.DURATION_TYPE, 4, Type.DURATION_TYPE), new Signature(Type.DURATION_TYPE, Type.NUMBER_TYPE, 4, Type.DURATION_TYPE)};
    private static Signature[] divideTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.DURATION_TYPE, Type.NUMBER_TYPE, 4, Type.DURATION_TYPE), new Signature(Type.DURATION_TYPE, Type.DURATION_TYPE, 5, Type.DURATION_TYPE)};
    private static Signature[] idivTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.INTEGER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.INTEGER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.INTEGER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.INTEGER_TYPE)};
    private static Signature[] modTable = new Signature[]{new Signature(Type.NUMBER_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.NUMBER_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.NUMBER_TYPE, 0, Type.NUMBER_TYPE), new Signature(Type.UNTYPED_ATOMIC_TYPE, Type.UNTYPED_ATOMIC_TYPE, 0, Type.NUMBER_TYPE)};
    private boolean backwardsCompatible = false;

    public ArithmeticExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression;
        block12: {
            this.backwardsCompatible = staticContext.isInBackwardsCompatibleMode();
            SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
            RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0);
            this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, this.backwardsCompatible, roleLocator, staticContext);
            RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1);
            this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, this.backwardsCompatible, roleLocator2, staticContext);
            expression = super.analyze(staticContext, itemType);
            if (!(expression instanceof ArithmeticExpression)) break block12;
            ItemType itemType2 = this.operand0.getItemType().getPrimitiveItemType();
            ItemType itemType3 = this.operand1.getItemType().getPrimitiveItemType();
            int n = this.getAction(itemType2, this.operator, itemType3);
            switch (n) {
                case 0: {
                    expression = new NumericArithmetic(this.operand0, this.operator, this.operand1);
                    break;
                }
                case 3: {
                    expression = new DurationAddition(this.operand0, this.operator, this.operand1);
                    break;
                }
                case 4: {
                    expression = new DurationMultiplication(this.operand0, this.operator, this.operand1);
                    break;
                }
                case 5: {
                    expression = new DurationDivision(this.operand0, this.operator, this.operand1);
                    break;
                }
                case 1: {
                    expression = new DateAndDuration(this.operand0, this.operator, this.operand1);
                    break;
                }
                case 2: {
                    expression = new DateDifference(this.operand0, this.operator, this.operand1);
                    break;
                }
                default: {
                    if (!this.backwardsCompatible && Type.isSubType(itemType2, Type.ANY_ATOMIC_TYPE) && itemType2 != Type.UNTYPED_ATOMIC_TYPE && itemType2 != Type.ANY_ATOMIC_TYPE && Type.isSubType(itemType3, Type.ANY_ATOMIC_TYPE) && itemType3 != Type.UNTYPED_ATOMIC_TYPE && itemType3 != Type.ANY_ATOMIC_TYPE) {
                        StaticError staticError = new StaticError("Unsuitable operands for arithmetic operation (" + itemType2.toString(staticContext.getNamePool()) + ", " + itemType3.toString(staticContext.getNamePool()) + ')');
                        staticError.setIsTypeError(true);
                        throw staticError;
                    }
                    return expression;
                }
            }
            ExpressionTool.copyLocationInfo(this, expression);
            try {
                if (this.operand0 instanceof Value && this.operand1 instanceof Value) {
                    return ExpressionTool.eagerEvaluate(expression, null);
                }
            }
            catch (DynamicError dynamicError) {}
        }
        return expression;
    }

    private int getAction(ItemType itemType, int n, ItemType itemType2) {
        Signature[] signatureArray = this.getOperatorTable(n);
        int n2 = this.getEntry(signatureArray, itemType, itemType2);
        if (n2 < 0) {
            return -1;
        }
        return signatureArray[n2].operation;
    }

    private Signature[] getOperatorTable(int n) {
        switch (n) {
            case 15: {
                return plusTable;
            }
            case 16: 
            case 199: {
                return minusTable;
            }
            case 17: {
                return multiplyTable;
            }
            case 18: {
                return divideTable;
            }
            case 50: {
                return idivTable;
            }
            case 19: {
                return modTable;
            }
        }
        throw new IllegalArgumentException("Unknown arithmetic operator");
    }

    private int getEntry(Signature[] signatureArray, ItemType itemType, ItemType itemType2) {
        if (Type.isNumericPrimitiveType(itemType)) {
            itemType = Type.NUMBER_TYPE;
        }
        if (Type.isNumericPrimitiveType(itemType2)) {
            itemType2 = Type.NUMBER_TYPE;
        }
        int n = 0;
        while (n < signatureArray.length) {
            if (itemType.equals(signatureArray[n].operand0) && itemType2.equals(signatureArray[n].operand1)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ItemType getItemType() {
        ItemType itemType = this.operand0.getItemType();
        ItemType itemType2 = itemType.getPrimitiveItemType();
        ItemType itemType3 = this.operand1.getItemType();
        ItemType itemType4 = itemType3.getPrimitiveItemType();
        Signature[] signatureArray = this.getOperatorTable(this.operator);
        int n = this.getEntry(signatureArray, itemType2, itemType4);
        if (n < 0) {
            return Type.ANY_ATOMIC_TYPE;
        }
        ItemType itemType5 = signatureArray[n].resultType;
        if (itemType5 == Type.NUMBER_TYPE) {
            itemType5 = NumericValue.promote(itemType2, itemType4);
            if (this.operator == 18 && itemType5 == Type.INTEGER_TYPE) {
                itemType5 = Type.DECIMAL_TYPE;
            }
        } else if (itemType5 == Type.DURATION_TYPE) {
            if (Type.isSubType(itemType, Type.DAY_TIME_DURATION_TYPE)) {
                itemType5 = Type.DAY_TIME_DURATION_TYPE;
            } else if (Type.isSubType(itemType3, Type.DAY_TIME_DURATION_TYPE)) {
                itemType5 = Type.DAY_TIME_DURATION_TYPE;
            } else if (Type.isSubType(itemType, Type.YEAR_MONTH_DURATION_TYPE)) {
                itemType5 = Type.YEAR_MONTH_DURATION_TYPE;
            } else if (Type.isSubType(itemType3, Type.YEAR_MONTH_DURATION_TYPE)) {
                itemType5 = Type.YEAR_MONTH_DURATION_TYPE;
            }
        }
        return itemType5;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        ArithmeticExpression arithmeticExpression;
        AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        atomicValue = atomicValue.getPrimitiveValue();
        AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return null;
        }
        atomicValue2 = atomicValue2.getPrimitiveValue();
        int n = this.getAction(atomicValue.getItemType().getPrimitiveItemType(), this.operator, atomicValue2.getItemType().getPrimitiveItemType());
        switch (n) {
            case 0: {
                arithmeticExpression = new NumericArithmetic(atomicValue, this.operator, atomicValue2);
                break;
            }
            case 3: {
                arithmeticExpression = new DurationAddition(atomicValue, this.operator, atomicValue2);
                break;
            }
            case 4: {
                arithmeticExpression = new DurationMultiplication(atomicValue, this.operator, atomicValue2);
                break;
            }
            case 5: {
                arithmeticExpression = new DurationDivision(atomicValue, this.operator, atomicValue2);
                break;
            }
            case 1: {
                arithmeticExpression = new DateAndDuration(atomicValue, this.operator, atomicValue2);
                break;
            }
            case 2: {
                arithmeticExpression = new DateDifference(atomicValue, this.operator, atomicValue2);
                break;
            }
            default: {
                if (this.backwardsCompatible) {
                    NumericValue numericValue;
                    NumericValue numericValue2;
                    try {
                        numericValue2 = (NumericValue)atomicValue.convert(517, xPathContext);
                        numericValue = (NumericValue)atomicValue2.convert(517, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        this.typeError("Unsuitable operands for arithmetic operation (" + atomicValue.getItemType() + ", " + atomicValue2.getItemType() + ')', xPathContext);
                        return null;
                    }
                    arithmeticExpression = new NumericArithmetic(numericValue2, this.operator, numericValue);
                    break;
                }
                this.typeError("Unsuitable operands for arithmetic operation (" + atomicValue.getItemType() + ", " + atomicValue2.getItemType() + ')', xPathContext);
                return null;
            }
        }
        ExpressionTool.copyLocationInfo(this, arithmeticExpression);
        return arithmeticExpression.evaluateItem(xPathContext);
    }

    public static class DateDifference
    extends ArithmeticExpression {
        public DateDifference(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            CalendarValue calendarValue = (CalendarValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            CalendarValue calendarValue2 = (CalendarValue)atomicValue2.getPrimitiveValue();
            return calendarValue.subtract(calendarValue2);
        }
    }

    public static class DateAndDuration
    extends ArithmeticExpression {
        public DateAndDuration(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
            if (Type.isSubType(expression.getItemType(), Type.DURATION_TYPE)) {
                this.operand0 = expression2;
                this.operand1 = expression;
            }
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            CalendarValue calendarValue = (CalendarValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue2.getPrimitiveValue();
            if (this.operator == 16) {
                durationValue = durationValue.multiply(-1.0, xPathContext);
            }
            return calendarValue.add(durationValue);
        }
    }

    public static class DurationDivision
    extends ArithmeticExpression {
        public DurationDivision(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            DurationValue durationValue2 = (DurationValue)atomicValue2.getPrimitiveValue();
            return durationValue.divide(durationValue2, xPathContext);
        }
    }

    public static class DurationMultiplication
    extends ArithmeticExpression {
        public DurationMultiplication(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
            if (Type.isSubType(expression2.getItemType(), Type.DURATION_TYPE)) {
                this.operand0 = expression2;
                this.operand1 = expression;
            }
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            NumericValue numericValue = (NumericValue)atomicValue2.getPrimitiveValue();
            double d = numericValue.getDoubleValue();
            if (this.operator == 18) {
                d = 1.0 / d;
            }
            return durationValue.multiply(d, xPathContext);
        }
    }

    public static class DurationAddition
    extends ArithmeticExpression {
        public DurationAddition(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            DurationValue durationValue2 = (DurationValue)atomicValue2.getPrimitiveValue();
            if (this.operator == 15) {
                return durationValue.add(durationValue2, xPathContext);
            }
            if (this.operator == 16) {
                return durationValue.subtract(durationValue2, xPathContext);
            }
            throw new AssertionError((Object)"Unknown operation on durations");
        }
    }

    public static class NumericArithmetic
    extends ArithmeticExpression {
        public NumericArithmetic(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue;
            AtomicValue atomicValue2 = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            if ((atomicValue2 = atomicValue2.getPrimitiveValue()) instanceof UntypedAtomicValue) {
                try {
                    atomicValue2 = new DoubleValue(Value.stringToNumber(atomicValue2.getStringValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    atomicValue2 = DoubleValue.NaN;
                }
            }
            if ((atomicValue = (AtomicValue)this.operand1.evaluateItem(xPathContext)) == null) {
                return null;
            }
            if ((atomicValue = atomicValue.getPrimitiveValue()) instanceof UntypedAtomicValue) {
                try {
                    atomicValue = new DoubleValue(Value.stringToNumber(atomicValue.getStringValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    atomicValue = DoubleValue.NaN;
                }
            }
            if (this.operator == 199) {
                return ((NumericValue)atomicValue).negate();
            }
            try {
                return ((NumericValue)atomicValue2).arithmetic(this.operator, (NumericValue)atomicValue, xPathContext);
            }
            catch (DynamicError dynamicError) {
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(ExpressionTool.getLocator(this));
                throw dynamicError;
            }
            catch (ArithmeticException arithmeticException) {
                DynamicError dynamicError = new DynamicError("Arithmetic exception: " + arithmeticException.getMessage());
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(ExpressionTool.getLocator(this));
                throw dynamicError;
            }
        }
    }

    private static class Signature {
        ItemType operand0;
        ItemType operand1;
        int operation;
        ItemType resultType;

        Signature(ItemType itemType, ItemType itemType2, int n, ItemType itemType3) {
            this.operand0 = itemType;
            this.operand1 = itemType2;
            this.operation = n;
            this.resultType = itemType3;
        }
    }
}

