/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.xpath.DynamicError;
import org.w3c.dom.Node;

public abstract class XSLGeneralIncorporate
extends StyleElement {
    String href;
    DocumentImpl includedDoc;

    public abstract boolean isImport();

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string = this.getNamePool().getClarkName(n2);
            if (string == "href") {
                this.href = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.href == null) {
            this.reportAbsence("href");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkEmpty();
        this.checkTopLevel(null);
    }

    public XSLStylesheet getIncludedStylesheet(XSLStylesheet xSLStylesheet, int n) throws TransformerConfigurationException {
        if (this.href == null) {
            return null;
        }
        this.checkEmpty();
        this.checkTopLevel(this instanceof XSLInclude ? "XT0170" : "XT0190");
        try {
            XSLStylesheet xSLStylesheet2 = (XSLStylesheet)this.getParentNode();
            PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
            Configuration configuration = preparedStylesheet.getConfiguration();
            Source source = configuration.getURIResolver().resolve(this.href, this.getBaseURI());
            if (source == null) {
                source = new StandardURIResolver(configuration).resolve(this.href, this.getBaseURI());
            }
            if (source instanceof NodeInfo) {
                if (source instanceof Node) {
                    source = new DOMSource((Node)((Object)source));
                } else {
                    throw new DynamicError("URIResolver must not return a " + source.getClass());
                }
            }
            XSLStylesheet xSLStylesheet3 = xSLStylesheet2;
            if (source.getSystemId() != null) {
                while (xSLStylesheet3 != null) {
                    if (source.getSystemId().equals(xSLStylesheet3.getSystemId())) {
                        this.compileError("A stylesheet cannot " + this.getLocalPart() + " itself", this instanceof XSLInclude ? "XT0180" : "XT0210");
                        return null;
                    }
                    xSLStylesheet3 = xSLStylesheet3.getImporter();
                }
            }
            StyleNodeFactory styleNodeFactory = new StyleNodeFactory(this.getNamePool(), configuration.isAllowExternalFunctions());
            this.includedDoc = PreparedStylesheet.loadStylesheetModule(source, configuration, this.getNamePool(), styleNodeFactory);
            ElementImpl elementImpl = (ElementImpl)this.includedDoc.getDocumentElement();
            if (elementImpl instanceof LiteralResultElement) {
                this.includedDoc = ((LiteralResultElement)elementImpl).makeStylesheet(this.getPreparedStylesheet(), styleNodeFactory);
                elementImpl = (ElementImpl)this.includedDoc.getDocumentElement();
            }
            if (!(elementImpl instanceof XSLStylesheet)) {
                this.compileError("Included document " + this.href + " is not a stylesheet", "XT0165");
                return null;
            }
            XSLStylesheet xSLStylesheet4 = (XSLStylesheet)elementImpl;
            if (xSLStylesheet4.validationError != null) {
                if (this.reportingCircumstances == 1) {
                    xSLStylesheet4.compileError(xSLStylesheet4.validationError);
                } else if (xSLStylesheet4.reportingCircumstances == 2 && !xSLStylesheet4.forwardsCompatibleModeIsEnabled()) {
                    xSLStylesheet4.compileError(xSLStylesheet4.validationError);
                }
            }
            xSLStylesheet4.setPrecedence(n);
            xSLStylesheet4.setImporter(xSLStylesheet);
            xSLStylesheet4.spliceIncludes();
            return xSLStylesheet4;
        }
        catch (TransformerException transformerException) {
            this.compileError(transformerException);
            return null;
        }
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        return null;
    }
}

