/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;

public abstract class BuiltInSchemaFactory
implements Serializable {
    private static HashMap lookup = new HashMap();

    private static SimpleType makeSimpleType(String string, String string2, SimpleType simpleType, int n) {
        try {
            AtomicType atomicType = new AtomicType();
            atomicType.setIsBuiltIn(true);
            atomicType.setBaseType(simpleType);
            atomicType.setDerivationMethodName("restriction");
            atomicType.setFingerprint(StandardNames.getFingerprint(string, string2));
            atomicType.setLocalName(string2);
            atomicType.setNamePool(NamePool.getDefaultNamePool());
            lookup.put(new Integer(atomicType.getFingerprint()), atomicType);
            return atomicType;
        }
        catch (SchemaException schemaException) {
            throw new AssertionError((Object)("No exception should be thrown here. " + schemaException.getMessage()));
        }
    }

    private static SimpleType makeListType(String string, String string2, SimpleType simpleType) {
        try {
            ListType listType = new ListType(NamePool.getDefaultNamePool());
            listType.setItemType(simpleType);
            listType.setBaseType(BuiltInSchemaFactory.getSchemaType(593));
            listType.setDerivationMethodName("list");
            listType.setFingerprint(StandardNames.getFingerprint(string, string2));
            listType.setLocalName(string2);
            lookup.put(new Integer(listType.getFingerprint()), listType);
            return listType;
        }
        catch (SchemaException schemaException) {
            throw new AssertionError((Object)("No exception should be thrown here. " + schemaException.getMessage()));
        }
    }

    public static SchemaType getSchemaType(int n) {
        return (SchemaType)lookup.get(new Integer(n));
    }

    static {
        SimpleType simpleType = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "anySimpleType", null, 593);
        try {
            simpleType.setBaseType(AnyType.getInstance());
        }
        catch (SchemaException schemaException) {
            throw new AssertionError((Object)schemaException);
        }
        SimpleType simpleType2 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2004/07/xpath-datatypes", "anyAtomicType", simpleType, 643);
        SimpleType simpleType3 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2004/07/xpath-datatypes", "numeric", simpleType2, 646);
        SimpleType simpleType4 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "string", simpleType2, 513);
        SimpleType simpleType5 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "boolean", simpleType2, 514);
        SimpleType simpleType6 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "duration", simpleType2, 518);
        SimpleType simpleType7 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "dateTime", simpleType2, 519);
        SimpleType simpleType8 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "date", simpleType2, 521);
        SimpleType simpleType9 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "time", simpleType2, 520);
        SimpleType simpleType10 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "gYearMonth", simpleType2, 522);
        SimpleType simpleType11 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "gMonth", simpleType2, 526);
        SimpleType simpleType12 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "gMonthDay", simpleType2, 524);
        SimpleType simpleType13 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "gYear", simpleType2, 523);
        SimpleType simpleType14 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "gDay", simpleType2, 525);
        SimpleType simpleType15 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "hexBinary", simpleType2, 527);
        SimpleType simpleType16 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "base64Binary", simpleType2, 528);
        SimpleType simpleType17 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "anyURI", simpleType2, 529);
        SimpleType simpleType18 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "QName", simpleType2, 530);
        SimpleType simpleType19 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "NOTATION", simpleType2, 531);
        SimpleType simpleType20 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2004/07/xpath-datatypes", "untypedAtomic", simpleType2, 642);
        SimpleType simpleType21 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "decimal", simpleType3, 515);
        SimpleType simpleType22 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "float", simpleType3, 516);
        SimpleType simpleType23 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "double", simpleType3, 517);
        SimpleType simpleType24 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "integer", simpleType21, 532);
        SimpleType simpleType25 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger", simpleType24, 533);
        SimpleType simpleType26 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "negativeInteger", simpleType25, 534);
        SimpleType simpleType27 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "long", simpleType24, 535);
        SimpleType simpleType28 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "int", simpleType27, 536);
        SimpleType simpleType29 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "short", simpleType28, 537);
        SimpleType simpleType30 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "byte", simpleType29, 538);
        SimpleType simpleType31 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger", simpleType24, 539);
        SimpleType simpleType32 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "positiveInteger", simpleType31, 540);
        SimpleType simpleType33 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "unsignedLong", simpleType31, 541);
        SimpleType simpleType34 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "unsignedInt", simpleType33, 542);
        SimpleType simpleType35 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "unsignedShort", simpleType34, 543);
        SimpleType simpleType36 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "unsignedByte", simpleType35, 544);
        SimpleType simpleType37 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2004/07/xpath-datatypes", "yearMonthDuration", simpleType6, 644);
        SimpleType simpleType38 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2004/07/xpath-datatypes", "dayTimeDuration", simpleType6, 645);
        SimpleType simpleType39 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "normalizedString", simpleType4, 553);
        SimpleType simpleType40 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "token", simpleType39, 554);
        SimpleType simpleType41 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "language", simpleType40, 555);
        SimpleType simpleType42 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "Name", simpleType40, 558);
        SimpleType simpleType43 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "NMTOKEN", simpleType40, 556);
        SimpleType simpleType44 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "NCName", simpleType42, 559);
        SimpleType simpleType45 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "ID", simpleType44, 560);
        SimpleType simpleType46 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "IDREF", simpleType44, 561);
        SimpleType simpleType47 = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "ENTITY", simpleType44, 563);
        BuiltInSchemaFactory.makeListType("http://www.w3.org/2001/XMLSchema", "NMTOKENS", simpleType43);
        BuiltInSchemaFactory.makeListType("http://www.w3.org/2001/XMLSchema", "IDREFS", simpleType43);
        BuiltInSchemaFactory.makeListType("http://www.w3.org/2001/XMLSchema", "ENTITIES", simpleType43);
        lookup.put(new Integer(592), AnyType.getInstance());
        lookup.put(new Integer(641), Untyped.getInstance());
    }
}

