/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUService;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.icu.util.ULocale;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ICULocaleService
extends ICUService {
    private Locale fallbackLocale;
    private String fallbackLocaleName;

    public ICULocaleService() {
    }

    public ICULocaleService(String name) {
        super(name);
    }

    public Object get(Locale locale) {
        return this.get(locale, -1, null);
    }

    public Object get(Locale locale, int kind) {
        return this.get(locale, kind, null);
    }

    public Object get(Locale locale, Locale[] actualReturn) {
        return this.get(locale, -1, actualReturn);
    }

    public Object get(ULocale locale, ULocale[] actualReturn) {
        return this.get(locale, -1, actualReturn);
    }

    public Object get(ULocale locale, int kind, ULocale[] actualReturn) {
        String name = locale.getName();
        if (name.length() > 0) {
            name = ULocale.canonicalize(name);
        }
        ICUService.Key key = this.createKey(name, kind);
        if (actualReturn == null) {
            return this.getKey(key);
        }
        String[] temp = new String[1];
        Object result = this.getKey(key, temp);
        if (result != null) {
            int n = temp[0].indexOf("/");
            if (n >= 0) {
                temp[0] = temp[0].substring(n + 1);
            }
            actualReturn[0] = new ULocale(temp[0]);
        }
        return result;
    }

    public Object get(Locale locale, int kind, Locale[] actualReturn) {
        ICUService.Key key = this.createKey(locale.toString(), kind);
        if (actualReturn == null) {
            return this.getKey(key);
        }
        String[] temp = new String[1];
        Object result = this.getKey(key, temp);
        if (result != null) {
            int n = temp[0].indexOf("/");
            if (n >= 0) {
                temp[0] = temp[0].substring(n + 1);
            }
            actualReturn[0] = LocaleUtility.getLocaleFromName(temp[0]);
        }
        return result;
    }

    public ICUService.Factory registerObject(Object obj, Locale locale) {
        return this.registerObject(obj, locale, -1, 0);
    }

    public ICUService.Factory registerObject(Object obj, Locale locale, int kind) {
        return this.registerObject(obj, locale, kind, 0);
    }

    public ICUService.Factory registerObject(Object obj, Locale locale, int kind, int coverage) {
        SimpleLocaleKeyFactory factory = new SimpleLocaleKeyFactory(obj, locale, kind, coverage);
        return this.registerFactory(factory);
    }

    public Locale[] getAvailableLocales() {
        Set visIDs = this.getVisibleIDs();
        Iterator iter = visIDs.iterator();
        Locale[] locales = new Locale[visIDs.size()];
        int n = 0;
        while (iter.hasNext()) {
            Locale loc = LocaleUtility.getLocaleFromName((String)iter.next());
            locales[n++] = loc;
        }
        return locales;
    }

    public ULocale[] getAvailableULocales() {
        Set visIDs = this.getVisibleIDs();
        Iterator iter = visIDs.iterator();
        ULocale[] locales = new ULocale[visIDs.size()];
        int n = 0;
        while (iter.hasNext()) {
            locales[n++] = new ULocale((String)iter.next());
        }
        return locales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validateFallbackLocale() {
        Locale loc = Locale.getDefault();
        if (loc != this.fallbackLocale) {
            ICULocaleService iCULocaleService = this;
            synchronized (iCULocaleService) {
                if (loc != this.fallbackLocale) {
                    this.fallbackLocale = loc;
                    this.fallbackLocaleName = LocaleUtility.canonicalLocaleString(loc.toString());
                    this.clearServiceCache();
                }
            }
        }
        return this.fallbackLocaleName;
    }

    public ICUService.Key createKey(String id) {
        return LocaleKey.createWithCanonicalFallback(id, this.validateFallbackLocale());
    }

    public ICUService.Key createKey(String id, int kind) {
        return LocaleKey.createWithCanonicalFallback(id, this.validateFallbackLocale(), kind);
    }

    public static class ICUResourceBundleFactory
    extends LocaleKeyFactory {
        protected final String bundleName;

        public ICUResourceBundleFactory() {
            this("com/ibm/icu/impl/data/icudt30b");
        }

        public ICUResourceBundleFactory(String bundleName) {
            super(0);
            this.bundleName = bundleName;
        }

        protected Set getSupportedIDs() {
            return ICUResourceBundle.getAvailableLocaleNameSet(this.bundleName);
        }

        protected Object handleCreate(Locale loc, int kind, ICUService service) {
            return ICUResourceBundle.getBundleInstance(this.bundleName, loc);
        }

        public String toString() {
            return super.toString() + ", bundle: " + this.bundleName;
        }
    }

    public static class SimpleLocaleKeyFactory
    extends LocaleKeyFactory {
        private final Object obj;
        private final String id;
        private final int kind;

        public SimpleLocaleKeyFactory(Object obj, Locale locale, int kind, int coverage) {
            this(obj, locale, kind, coverage, null);
        }

        public SimpleLocaleKeyFactory(Object obj, Locale locale, int kind, int coverage, String name) {
            super(coverage, name);
            this.obj = obj;
            this.id = LocaleUtility.canonicalLocaleString(locale.toString());
            this.kind = kind;
        }

        public Object create(ICUService.Key key, ICUService service) {
            String keyID;
            LocaleKey lkey = (LocaleKey)key;
            if ((this.kind == -1 || this.kind == lkey.kind()) && this.id.equals(keyID = lkey.currentID())) {
                return this.obj;
            }
            return null;
        }

        protected boolean isSupportedID(String id) {
            return this.id.equals(id);
        }

        public void updateVisibleIDs(Map result) {
            if ((this.coverage & 1) == 0) {
                result.put(this.id, this);
            } else {
                result.remove(this.id);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append(", id: ");
            buf.append(this.id);
            buf.append(", kind: ");
            buf.append(this.kind);
            return buf.toString();
        }
    }

    public static abstract class LocaleKeyFactory
    implements ICUService.Factory {
        protected final String name;
        protected final int coverage;
        public static final int VISIBLE = 0;
        public static final int INVISIBLE = 1;

        protected LocaleKeyFactory(int coverage) {
            this.coverage = coverage;
            this.name = null;
        }

        protected LocaleKeyFactory(int coverage, String name) {
            this.coverage = coverage;
            this.name = name;
        }

        public Object create(ICUService.Key key, ICUService service) {
            if (this.handlesKey(key)) {
                LocaleKey lkey = (LocaleKey)key;
                int kind = lkey.kind();
                if (this.supportsULocale()) {
                    ULocale uloc = lkey.currentULocale();
                    return this.handleCreate(uloc, kind, service);
                }
                Locale loc = lkey.currentLocale();
                return this.handleCreate(loc, kind, service);
            }
            return null;
        }

        protected boolean handlesKey(ICUService.Key key) {
            if (key == null) {
                return false;
            }
            String id = key.currentID();
            Set supported = this.getSupportedIDs();
            return supported.contains(id);
        }

        public void updateVisibleIDs(Map result) {
            Set cache = this.getSupportedIDs();
            boolean visible = (this.coverage & 1) == 0;
            HashMap<String, LocaleKeyFactory> toRemap = new HashMap<String, LocaleKeyFactory>();
            Iterator iter = cache.iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                if (!visible) {
                    result.remove(id);
                    continue;
                }
                toRemap.put(id, this);
            }
            result.putAll(toRemap);
        }

        public String getDisplayName(String id, Locale locale) {
            if (locale == null) {
                return id;
            }
            Locale loc = LocaleUtility.getLocaleFromName(id);
            return loc.getDisplayName(locale);
        }

        protected boolean supportsULocale() {
            return false;
        }

        protected Object handleCreate(Locale loc, int kind, ICUService service) {
            return null;
        }

        protected Object handleCreate(ULocale loc, int kind, ICUService service) {
            return null;
        }

        protected boolean isSupportedID(String id) {
            return this.getSupportedIDs().contains(id);
        }

        protected Set getSupportedIDs() {
            return Collections.EMPTY_SET;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            if (this.name != null) {
                buf.append(", name: ");
                buf.append(this.name);
            }
            buf.append(", coverage: ");
            String[] coverage_names = new String[]{"visible", "invisible", "visible_covers", "invisible_covers", "????", "visible_covers_remove"};
            buf.append(coverage_names[this.coverage]);
            return buf.toString();
        }
    }

    public static class LocaleKey
    extends ICUService.Key {
        private int kind;
        private int varstart;
        private String primaryID;
        private String fallbackID;
        private String currentID;
        public static final int KIND_ANY = -1;

        public static LocaleKey createWithCanonicalFallback(String primaryID, String canonicalFallbackID) {
            return LocaleKey.createWithCanonicalFallback(primaryID, canonicalFallbackID, -1);
        }

        public static LocaleKey createWithCanonicalFallback(String primaryID, String canonicalFallbackID, int kind) {
            if (primaryID == null) {
                return null;
            }
            String canonicalPrimaryID = ULocale.getName(primaryID);
            return new LocaleKey(primaryID, canonicalPrimaryID, canonicalFallbackID, kind);
        }

        protected LocaleKey(String primaryID, String canonicalPrimaryID, String canonicalFallbackID, int kind) {
            super(primaryID);
            this.kind = kind;
            if (canonicalPrimaryID == null) {
                this.primaryID = "";
            } else {
                this.primaryID = canonicalPrimaryID;
                this.varstart = this.primaryID.indexOf(64);
            }
            this.fallbackID = this.primaryID == "" ? null : (canonicalFallbackID == null || this.primaryID.equals(canonicalFallbackID) ? "" : canonicalFallbackID);
            this.currentID = this.varstart == -1 ? this.primaryID : this.primaryID.substring(0, this.varstart);
        }

        public String prefix() {
            return this.kind == -1 ? null : Integer.toString(this.kind());
        }

        public int kind() {
            return this.kind;
        }

        public String canonicalID() {
            return this.primaryID;
        }

        public String currentID() {
            return this.currentID;
        }

        public String currentDescriptor() {
            String result = this.currentID();
            if (result != null) {
                result = "/" + result;
                if (this.varstart != -1) {
                    result = result + this.primaryID.substring(this.varstart);
                }
                if (this.kind != -1) {
                    result = this.prefix() + result;
                }
            }
            return result;
        }

        public Locale canonicalLocale() {
            return LocaleUtility.getLocaleFromName(this.primaryID);
        }

        public Locale currentLocale() {
            return LocaleUtility.getLocaleFromName(this.currentID);
        }

        public ULocale currentULocale() {
            if (this.varstart == -1) {
                return new ULocale(this.currentID);
            }
            return new ULocale(this.currentID + this.primaryID.substring(this.varstart));
        }

        public boolean fallback() {
            int x = this.currentID.lastIndexOf(95);
            if (x != -1) {
                this.currentID = this.currentID.substring(0, x);
                return true;
            }
            if (this.fallbackID != null) {
                this.currentID = this.fallbackID;
                this.fallbackID = this.fallbackID.length() == 0 ? null : "";
                return true;
            }
            this.currentID = null;
            return false;
        }

        public boolean isFallbackOf(String id) {
            return LocaleUtility.isFallbackOf(this.canonicalID(), id);
        }
    }
}

