/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class ExpressionTool {
    private ExpressionTool() {
    }

    public static Expression make(String string, StaticContext staticContext, int n, int n2, int n3) throws XPathException {
        ExpressionParser expressionParser = new ExpressionParser();
        if (n2 == -1) {
            n2 = 0;
        }
        Expression expression = expressionParser.parse(string, n, n2, n3, staticContext);
        expression = expression.simplify(staticContext);
        ExpressionTool.makeParentReferences(expression);
        return expression;
    }

    public static void copyLocationInfo(Expression expression, Expression expression2) {
        if (expression instanceof ComputedExpression && expression2 instanceof ComputedExpression) {
            ((ComputedExpression)expression2).setLocationId(((ComputedExpression)expression).getLocationId());
        }
    }

    public static void makeParentReferences(Expression expression) {
        if (expression == null) {
            return;
        }
        Iterator iterator = expression.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            if (!(expression2 instanceof ComputedExpression)) continue;
            ((ComputedExpression)expression2).setParentExpression((ComputedExpression)expression);
            ExpressionTool.makeParentReferences(expression2);
        }
    }

    public static SourceLocator getLocator(Expression expression) {
        if (expression instanceof ComputedExpression) {
            return (ComputedExpression)expression;
        }
        return null;
    }

    public static Expression unsorted(Expression expression, boolean bl) throws XPathException {
        if (expression instanceof Value) {
            return expression;
        }
        PromotionOffer promotionOffer = new PromotionOffer();
        promotionOffer.action = 13;
        promotionOffer.mustEliminateDuplicates = bl;
        return expression.promote(promotionOffer);
    }

    public static Value lazyEvaluate(Expression expression, XPathContext xPathContext) throws XPathException {
        if (expression instanceof Value) {
            return (Value)expression;
        }
        if (expression instanceof VariableReference) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        if (xPathContext == null) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        if (!Cardinality.allowsMany(expression.getCardinality())) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        if ((expression.getDependencies() & 0x2D) != 0) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        return Closure.make(expression, xPathContext);
    }

    public static Value eagerEvaluate(Expression expression, XPathContext xPathContext) throws XPathException {
        if (expression instanceof Value && !(expression instanceof Closure)) {
            return (Value)expression;
        }
        switch (expression.getImplementationMethod()) {
            case 1: {
                SequenceIterator sequenceIterator = expression.iterate(xPathContext);
                if (sequenceIterator instanceof EmptyIterator) {
                    return EmptySequence.getInstance();
                }
                if (sequenceIterator instanceof SingletonIterator) {
                    Item item = ((SingletonIterator)sequenceIterator).getValue();
                    return Value.asValue(item);
                }
                SequenceExtent sequenceExtent = new SequenceExtent(sequenceIterator);
                int n = sequenceExtent.getLength();
                if (n == 0) {
                    return EmptySequence.getInstance();
                }
                if (n == 1) {
                    return Value.asValue(sequenceExtent.itemAt(0));
                }
                return sequenceExtent;
            }
            case 0: {
                Item item = expression.evaluateItem(xPathContext);
                return Value.asValue(item);
            }
            case 2: {
                Controller controller = xPathContext.getController();
                XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
                xPathContextMinor.setOrigin((InstructionInfoProvider)((Object)expression));
                SequenceOutputter sequenceOutputter = new SequenceOutputter();
                sequenceOutputter.setConfiguration(controller.getConfiguration());
                sequenceOutputter.setDocumentLocator(((Instruction)expression).getExecutable().getLocationMap());
                xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
                sequenceOutputter.open();
                expression.process(xPathContextMinor);
                sequenceOutputter.close();
                return sequenceOutputter.getSequence();
            }
        }
        throw new AssertionError((Object)"Expression has unknown evaluation method");
    }

    public static boolean markTailFunctionCalls(Expression expression) {
        if (expression instanceof ComputedExpression) {
            return ((ComputedExpression)expression).markTailFunctionCalls();
        }
        return false;
    }

    public static String indent(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + "  ";
            ++n2;
        }
        return string;
    }

    public static int allocateSlots(Expression expression, int n, SlotManager slotManager) {
        if (expression instanceof Assignation) {
            ((Assignation)expression).setSlotNumber(n++);
            if (slotManager != null) {
                slotManager.allocateSlotNumber(((Assignation)expression).getVariableFingerprint());
            }
        }
        Iterator iterator = expression.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression2 = (Expression)iterator.next();
            n = ExpressionTool.allocateSlots(expression2, n, slotManager);
        }
        return n;
    }

    public static boolean effectiveBooleanValue(SequenceIterator sequenceIterator) throws XPathException {
        Item item = sequenceIterator.next();
        if (item == null) {
            return false;
        }
        if (item instanceof NodeInfo) {
            return true;
        }
        if (item instanceof BooleanValue) {
            return ((BooleanValue)item).getBooleanValue() || sequenceIterator.next() != null;
        }
        if (item instanceof StringValue) {
            return !item.getStringValue().equals("") || sequenceIterator.next() != null;
        }
        if (item instanceof NumericValue) {
            return sequenceIterator.next() != null || !item.equals(DoubleValue.ZERO) && item.equals(item);
        }
        return true;
    }
}

