/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class Element
extends ElementCreator {
    private Expression elementName;
    private Expression namespace = null;
    private NamespaceResolver nsContext;
    private boolean allowNameAsQName;

    public Element(Expression expression, Expression expression2, NamespaceResolver namespaceResolver, AttributeSet[] attributeSetArray, SchemaType schemaType, int n) {
        this.elementName = expression;
        this.namespace = expression2;
        this.nsContext = namespaceResolver;
        this.useAttributeSets = attributeSetArray;
        this.schemaType = schemaType;
        this.validation = n;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.elementName = this.elementName.simplify(staticContext);
        if (this.namespace != null) {
            this.namespace = this.namespace.simplify(staticContext);
        }
        this.allowNameAsQName = staticContext.getConfiguration().getHostLanguage() == 11;
        return super.simplify(staticContext);
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.elementName = this.elementName.analyze(staticContext, itemType);
        RoleLocator roleLocator = new RoleLocator(4, "element/name", 0);
        this.elementName = this.allowNameAsQName ? TypeChecker.staticTypeCheck(this.elementName, SequenceType.SINGLE_ITEM, false, roleLocator, staticContext) : TypeChecker.staticTypeCheck(this.elementName, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        if (this.namespace != null) {
            this.namespace = this.namespace.analyze(staticContext, itemType);
            roleLocator = new RoleLocator(4, "element/namespace", 0);
            this.namespace = TypeChecker.staticTypeCheck(this.namespace, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        }
        super.analyze(staticContext, itemType);
        return this;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(8);
        if (this.children != null) {
            arrayList.addAll(Arrays.asList(this.children));
        }
        arrayList.add(this.elementName);
        if (this.namespace != null) {
            arrayList.add(this.namespace);
        }
        return arrayList.iterator();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.elementName = this.elementName.promote(promotionOffer);
        if (this.namespace != null) {
            this.namespace = this.namespace.promote(promotionOffer);
        }
        super.promoteInst(promotionOffer);
    }

    protected int getNameCode(XPathContext xPathContext) throws XPathException, XPathException {
        String string;
        String string2;
        String string3;
        Object object;
        Controller controller = xPathContext.getController();
        NamePool namePool = controller.getNamePool();
        Item item = this.elementName.evaluateItem(xPathContext);
        if (item instanceof StringValue) {
            object = item.getStringValue();
            try {
                String[] stringArray = Name.getQNameParts((CharSequence)object);
                string3 = stringArray[0];
                string2 = stringArray[1];
            }
            catch (QNameException qNameException) {
                DynamicError dynamicError = new DynamicError("Invalid element name. " + qNameException.getMessage(), this);
                dynamicError.setErrorCode("XT0820");
                dynamicError.setXPathContext(xPathContext);
                xPathContext.getController().recoverableError(dynamicError);
                return -1;
            }
        } else if (item instanceof QNameValue && this.allowNameAsQName) {
            string2 = ((QNameValue)item).getLocalName();
            string = ((QNameValue)item).getNamespaceURI();
            this.namespace = new StringValue(string);
            string3 = namePool.suggestPrefixForURI(string);
            if (string3 == null) {
                string3 = "nsq0";
            }
        } else {
            DynamicError dynamicError = new DynamicError("Computed element name has incorrect type");
            dynamicError.setErrorCode("XT0820");
            dynamicError.setXPathContext(xPathContext);
            xPathContext.getController().recoverableError(dynamicError);
            return -1;
        }
        if (this.namespace == null) {
            string = this.nsContext.getURIForPrefix(string3, true);
            if (string == null) {
                object = new DynamicError("Undeclared prefix in element name: " + string3, this);
                ((XPathException)object).setErrorCode("XT0830");
                ((DynamicError)object).setXPathContext(xPathContext);
                xPathContext.getController().recoverableError((XPathException)object);
                return -1;
            }
        } else {
            string = this.namespace.evaluateAsString(xPathContext);
            if (string.equals("")) {
                string3 = "";
            }
            if (string3.equals("xmlns")) {
                string3 = "x-xmlns";
            }
        }
        return namePool.allocate(string3, string, string2);
    }

    protected void outputNamespaceNodes(XPathContext xPathContext, Receiver receiver) throws XPathException {
    }

    public int getInstructionNameCode() {
        return 143;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "element ");
        printStream.println(ExpressionTool.indent(n + 1) + "name");
        this.elementName.display(n + 2, namePool, printStream);
        if (this.children.length == 0) {
            printStream.println(ExpressionTool.indent(n + 1) + "empty content");
        } else {
            InstructionWithChildren.displayChildren(this.children, n + 1, namePool, printStream);
        }
    }
}

