/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.event.Builder;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class TinyBuilder
extends Builder {
    private int currentDepth = 0;
    private int nodeNr = 0;
    private boolean ended = false;
    private int[] sizeParameters;
    private int[] prevAtDepth = new int[100];

    public void setSizeParameters(int[] nArray) {
        this.sizeParameters = nArray;
    }

    public void createDocument() {
        this.currentDocument = this.sizeParameters == null ? new TinyDocumentImpl() : new TinyDocumentImpl(this.sizeParameters[0], this.sizeParameters[1], this.sizeParameters[2], this.sizeParameters[3]);
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        tinyDocumentImpl.setSystemId(this.getSystemId());
        tinyDocumentImpl.setConfiguration(this.config);
    }

    public void open() throws XPathException {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.currentDocument == null) {
            this.createDocument();
        } else {
            if (!(this.currentDocument instanceof TinyDocumentImpl)) {
                throw new DynamicError("Root node supplied is of wrong type");
            }
            if (this.currentDocument.hasChildNodes()) {
                throw new DynamicError("Supplied document is not empty");
            }
            this.currentDocument.setConfiguration(this.config);
        }
        this.currentDepth = 0;
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (this.lineNumbering) {
            tinyDocumentImpl.setLineNumbering();
        }
        tinyDocumentImpl.addNode((short)9, 0, 0, 0, -1);
        this.prevAtDepth[0] = 0;
        this.prevAtDepth[1] = -1;
        tinyDocumentImpl.next[0] = -1;
        ++this.currentDepth;
        super.open();
    }

    public void close() throws XPathException {
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.prevAtDepth[this.currentDepth] = -1;
        ((TinyDocumentImpl)this.currentDocument).condense();
        super.close();
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        int n5;
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        this.nodeNr = tinyDocumentImpl.addNode((short)1, this.currentDepth, -1, -1, n);
        if (n2 != -1) {
            tinyDocumentImpl.setElementAnnotation(this.nodeNr, n2);
        }
        if ((n5 = this.prevAtDepth[this.currentDepth]) > 0) {
            tinyDocumentImpl.next[n5] = this.nodeNr;
        }
        tinyDocumentImpl.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        ++this.currentDepth;
        if (this.currentDepth == this.prevAtDepth.length) {
            int[] nArray = new int[this.currentDepth * 2];
            System.arraycopy(this.prevAtDepth, 0, nArray, 0, this.currentDepth);
            this.prevAtDepth = nArray;
        }
        this.prevAtDepth[this.currentDepth] = -1;
        if (this.locator != null) {
            tinyDocumentImpl.setSystemId(this.nodeNr, this.locator.getSystemId(n3));
            if (this.lineNumbering) {
                tinyDocumentImpl.setLineNumber(this.nodeNr, this.locator.getLineNumber(n3));
            }
        }
    }

    public void namespace(int n, int n2) throws XPathException {
        ((TinyDocumentImpl)this.currentDocument).addNamespace(this.nodeNr, n);
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if ((n4 & 1) != 0) {
            DynamicError dynamicError = new DynamicError("Cannot disable output escaping when writing a tree");
            dynamicError.setErrorCode("XT1610");
            throw dynamicError;
        }
        ((TinyDocumentImpl)this.currentDocument).addAttribute(this.nodeNr, n, n2, charSequence, n4);
    }

    public void startContent() {
        ++this.nodeNr;
    }

    public void endElement() throws XPathException {
        this.prevAtDepth[this.currentDepth] = -1;
        --this.currentDepth;
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (charSequence.length() > 0) {
            if ((n2 & 1) != 0) {
                DynamicError dynamicError = new DynamicError("Cannot disable output escaping when writing a tree");
                dynamicError.setErrorCode("XT1610");
                throw dynamicError;
            }
            int n3 = tinyDocumentImpl.charBufferLength;
            tinyDocumentImpl.appendChars(charSequence);
            int n4 = tinyDocumentImpl.numberOfNodes - 1;
            if (tinyDocumentImpl.nodeKind[n4] == 3 && tinyDocumentImpl.depth[n4] == this.currentDepth) {
                int n5 = n4;
                tinyDocumentImpl.beta[n5] = tinyDocumentImpl.beta[n5] + charSequence.length();
            } else {
                this.nodeNr = tinyDocumentImpl.addNode((short)3, this.currentDepth, n3, charSequence.length(), -1);
                int n6 = this.prevAtDepth[this.currentDepth];
                if (n6 > 0) {
                    tinyDocumentImpl.next[n6] = this.nodeNr;
                }
                tinyDocumentImpl.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
                this.prevAtDepth[this.currentDepth] = this.nodeNr;
            }
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (tinyDocumentImpl.commentBuffer == null) {
            tinyDocumentImpl.commentBuffer = new StringBuffer();
        }
        int n3 = tinyDocumentImpl.commentBuffer.length();
        tinyDocumentImpl.commentBuffer.append(charSequence.toString());
        int n4 = this.namePool.allocate("", "", string);
        this.nodeNr = tinyDocumentImpl.addNode((short)7, this.currentDepth, n3, charSequence.length(), n4);
        int n5 = this.prevAtDepth[this.currentDepth];
        if (n5 > 0) {
            tinyDocumentImpl.next[n5] = this.nodeNr;
        }
        tinyDocumentImpl.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)this.currentDocument;
        if (tinyDocumentImpl.commentBuffer == null) {
            tinyDocumentImpl.commentBuffer = new StringBuffer();
        }
        int n3 = tinyDocumentImpl.commentBuffer.length();
        tinyDocumentImpl.commentBuffer.append(charSequence.toString());
        this.nodeNr = tinyDocumentImpl.addNode((short)8, this.currentDepth, n3, charSequence.length(), -1);
        int n4 = this.prevAtDepth[this.currentDepth];
        if (n4 > 0) {
            tinyDocumentImpl.next[n4] = this.nodeNr;
        }
        tinyDocumentImpl.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
    }

    public void setUnparsedEntity(String string, String string2, String string3) {
        ((TinyDocumentImpl)this.currentDocument).setUnparsedEntity(string, string2, string3);
    }
}

