/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.DocumentSender;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ResultWrapper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class QueryResult {
    private static String RESULT_NS = "http://saxon.sf.net/xquery-results";

    private QueryResult() {
    }

    public static DocumentInfo wrap(SequenceIterator sequenceIterator, Configuration configuration) throws XPathException {
        Item item;
        NamePool namePool = configuration.getNamePool();
        TinyBuilder tinyBuilder = new TinyBuilder();
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(tinyBuilder);
        NamespaceReducer namespaceReducer2 = namespaceReducer;
        namespaceReducer2.setConfiguration(configuration);
        tinyBuilder.setConfiguration(configuration);
        namespaceReducer2.open();
        int n = namePool.allocate("result", RESULT_NS, "sequence");
        int n2 = namePool.allocate("result", RESULT_NS, "document");
        int n3 = namePool.allocate("result", RESULT_NS, "element");
        int n4 = namePool.allocate("result", RESULT_NS, "attribute");
        int n5 = namePool.allocate("result", RESULT_NS, "text");
        int n6 = namePool.allocate("result", RESULT_NS, "comment");
        int n7 = namePool.allocate("result", RESULT_NS, "processing-instruction");
        int n8 = namePool.allocate("result", RESULT_NS, "namespace");
        int n9 = namePool.allocate("result", RESULT_NS, "atomic-value");
        int n10 = namePool.allocate("", RESULT_NS, "type");
        namespaceReducer2.startElement(n, -1, 0, 0);
        namespaceReducer2.namespace(namePool.allocateNamespaceCode("result", RESULT_NS), 0);
        namespaceReducer2.startContent();
        while ((item = sequenceIterator.next()) != null) {
            if (item instanceof NodeInfo) {
                switch (((NodeInfo)item).getNodeKind()) {
                    case 9: {
                        namespaceReducer2.startElement(n2, -1, 0, 0);
                        namespaceReducer2.startContent();
                        ((DocumentInfo)item).copy(namespaceReducer2, 2, true, 0);
                        namespaceReducer2.endElement();
                        break;
                    }
                    case 1: {
                        namespaceReducer2.startElement(n3, -1, 0, 0);
                        namespaceReducer2.startContent();
                        ((NodeInfo)item).copy(namespaceReducer2, 2, true, 0);
                        namespaceReducer2.endElement();
                        break;
                    }
                    case 2: {
                        namespaceReducer2.startElement(n4, -1, 0, 0);
                        ((NodeInfo)item).copy(namespaceReducer2, 2, true, 0);
                        namespaceReducer2.startContent();
                        namespaceReducer2.endElement();
                        break;
                    }
                    case 3: {
                        namespaceReducer2.startElement(n5, -1, 0, 0);
                        namespaceReducer2.startContent();
                        ((NodeInfo)item).copy(namespaceReducer2, 2, true, 0);
                        namespaceReducer2.endElement();
                        break;
                    }
                    case 8: {
                        namespaceReducer2.startElement(n6, -1, 0, 0);
                        namespaceReducer2.startContent();
                        ((NodeInfo)item).copy(namespaceReducer2, 2, true, 0);
                        namespaceReducer2.endElement();
                        break;
                    }
                    case 7: {
                        namespaceReducer2.startElement(n7, -1, 0, 0);
                        namespaceReducer2.startContent();
                        ((NodeInfo)item).copy(namespaceReducer2, 2, true, 0);
                        namespaceReducer2.endElement();
                        break;
                    }
                    case 13: {
                        namespaceReducer2.startElement(n8, -1, 0, 0);
                        ((NodeInfo)item).copy(namespaceReducer2, 2, true, 0);
                        namespaceReducer2.startContent();
                        namespaceReducer2.endElement();
                    }
                }
                continue;
            }
            namespaceReducer2.startElement(n9, -1, 0, 0);
            namespaceReducer2.attribute(n10, -1, Type.displayTypeName(item), 0, 0);
            namespaceReducer2.startContent();
            namespaceReducer2.characters(item.getStringValue(), 0, 0);
            namespaceReducer2.endElement();
        }
        namespaceReducer2.endElement();
        namespaceReducer2.close();
        return tinyBuilder.getCurrentDocument();
    }

    public static void serialize(NodeInfo nodeInfo, Result result, Properties properties, Configuration configuration) throws XPathException {
        int n = nodeInfo.getNodeKind();
        if (n != 9 && n != 1) {
            throw new DynamicError("Node to be serialized must be a Document or Element node");
        }
        DocumentSender documentSender = new DocumentSender(nodeInfo);
        Receiver receiver = ResultWrapper.getReceiver(result, configuration, properties, null);
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        namespaceReducer.setUnderlyingReceiver(receiver);
        namespaceReducer.setConfiguration(configuration);
        documentSender.send(namespaceReducer);
    }

    public static void serializeSequence(SequenceIterator sequenceIterator, Configuration configuration, OutputStream outputStream, Properties properties) throws XPathException {
        Item item;
        PrintWriter printWriter;
        String string = properties.getProperty("encoding");
        if (string == null) {
            string = "UTF-8";
        }
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DynamicError(unsupportedEncodingException);
        }
        block8: while ((item = sequenceIterator.next()) != null) {
            if (item instanceof NodeInfo) {
                switch (((NodeInfo)item).getNodeKind()) {
                    case 1: 
                    case 9: {
                        QueryResult.serialize((NodeInfo)item, new StreamResult(printWriter), properties, configuration);
                        printWriter.println("");
                        continue block8;
                    }
                    case 2: {
                        printWriter.println(((NodeInfo)item).getLocalPart() + "=\"" + item.getStringValue() + '\"');
                        continue block8;
                    }
                    case 8: {
                        printWriter.println("<!--" + item.getStringValue() + "-->");
                        continue block8;
                    }
                    case 7: {
                        printWriter.println("<?" + ((NodeInfo)item).getLocalPart() + ' ' + item.getStringValue() + "?>");
                        continue block8;
                    }
                }
                printWriter.println(item.getStringValue());
                continue;
            }
            if (item instanceof QNameValue) {
                printWriter.println(((QNameValue)item).getClarkName());
                continue;
            }
            printWriter.println(item.getStringValue());
        }
        printWriter.flush();
    }
}

