/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public class ConstructorFunctionLibrary
implements FunctionLibrary {
    private Configuration config;

    public ConstructorFunctionLibrary(Configuration configuration) {
        this.config = configuration;
    }

    public boolean isAvailable(int n, String string, String string2, int n2) {
        if (n2 != 1 && n2 != -1) {
            return false;
        }
        if (string.equals("http://www.w3.org/2001/XMLSchema") || string.equals("http://www.w3.org/2001/XMLSchema-datatypes") || string.equals("http://www.w3.org/2004/07/xpath-datatypes")) {
            AtomicType atomicType = (AtomicType)Type.getBuiltInItemType(string, string2);
            return atomicType != null;
        }
        SchemaType schemaType = this.config.getSchemaType(n);
        return schemaType != null && schemaType instanceof AtomicType;
    }

    public Expression bind(int n, String string, String string2, Expression[] expressionArray) throws XPathException {
        SchemaType schemaType;
        if (string.equals("http://www.w3.org/2001/XMLSchema") || string.equals("http://www.w3.org/2001/XMLSchema-datatypes") || string.equals("http://www.w3.org/2004/07/xpath-datatypes")) {
            if (expressionArray.length != 1) {
                throw new StaticError("A constructor function must have exactly one argument");
            }
            AtomicType atomicType = (AtomicType)Type.getBuiltInItemType(string, string2);
            if (atomicType == null) {
                return new ErrorExpression(new DynamicError("Unknown constructor function: " + string2));
            }
            return new CastExpression(expressionArray[0], atomicType, false);
        }
        if (expressionArray.length == 1 && (schemaType = this.config.getSchemaType(n & 0xFFFFF)) != null && schemaType instanceof AtomicType) {
            return new CastExpression(expressionArray[0], (AtomicType)schemaType, false);
        }
        return null;
    }
}

