/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.PrintStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.Loader;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.functions.ExtensionFunctionFactory;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public class JavaExtensionLibrary
implements FunctionLibrary {
    private Configuration config;
    private HashMap explicitMappings = new HashMap(10);
    private transient PrintStream diag = System.err;
    private static final Class[] NO_PARAMS = new Class[0];
    static /* synthetic */ Class class$net$sf$saxon$functions$Extensions;
    static /* synthetic */ Class class$net$sf$saxon$exslt$Common;
    static /* synthetic */ Class class$net$sf$saxon$exslt$Sets;
    static /* synthetic */ Class class$net$sf$saxon$exslt$Math;
    static /* synthetic */ Class class$net$sf$saxon$exslt$Date;
    static /* synthetic */ Class class$net$sf$saxon$exslt$Random;
    static /* synthetic */ Class class$net$sf$saxon$expr$XPathContext;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$om$SequenceIterator;
    static /* synthetic */ Class class$net$sf$saxon$value$SequenceValue;
    static /* synthetic */ Class class$net$sf$saxon$functions$Collection;
    static /* synthetic */ Class class$org$w3c$dom$NodeList;
    static /* synthetic */ Class class$net$sf$saxon$om$NodeInfo;
    static /* synthetic */ Class class$net$sf$saxon$om$DocumentInfo;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$net$sf$saxon$value$StringValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$net$sf$saxon$value$DoubleValue;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$net$sf$saxon$value$FloatValue;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$net$sf$saxon$value$DecimalValue;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$net$sf$saxon$value$IntegerValue;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$net$sf$saxon$value$BooleanValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$net$sf$saxon$value$DateValue;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$net$sf$saxon$value$DateTimeValue;
    static /* synthetic */ Class class$net$sf$saxon$value$TimeValue;
    static /* synthetic */ Class class$net$sf$saxon$value$DurationValue;
    static /* synthetic */ Class class$net$sf$saxon$value$AnyURIValue;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$net$sf$saxon$value$QNameValue;
    static /* synthetic */ Class class$net$sf$saxon$value$Base64BinaryValue;
    static /* synthetic */ Class class$net$sf$saxon$value$HexBinaryValue;

    public JavaExtensionLibrary(Configuration configuration) {
        this.config = configuration;
        this.setDefaultURIMappings();
    }

    protected void setDefaultURIMappings() {
        this.declareJavaClass("http://saxon.sf.net/", class$net$sf$saxon$functions$Extensions == null ? (class$net$sf$saxon$functions$Extensions = JavaExtensionLibrary.class$("net.sf.saxon.functions.Extensions")) : class$net$sf$saxon$functions$Extensions);
        this.declareJavaClass("http://exslt.org/common", class$net$sf$saxon$exslt$Common == null ? (class$net$sf$saxon$exslt$Common = JavaExtensionLibrary.class$("net.sf.saxon.exslt.Common")) : class$net$sf$saxon$exslt$Common);
        this.declareJavaClass("http://exslt.org/sets", class$net$sf$saxon$exslt$Sets == null ? (class$net$sf$saxon$exslt$Sets = JavaExtensionLibrary.class$("net.sf.saxon.exslt.Sets")) : class$net$sf$saxon$exslt$Sets);
        this.declareJavaClass("http://exslt.org/math", class$net$sf$saxon$exslt$Math == null ? (class$net$sf$saxon$exslt$Math = JavaExtensionLibrary.class$("net.sf.saxon.exslt.Math")) : class$net$sf$saxon$exslt$Math);
        this.declareJavaClass("http://exslt.org/dates-and-times", class$net$sf$saxon$exslt$Date == null ? (class$net$sf$saxon$exslt$Date = JavaExtensionLibrary.class$("net.sf.saxon.exslt.Date")) : class$net$sf$saxon$exslt$Date);
        this.declareJavaClass("http://exslt.org/random", class$net$sf$saxon$exslt$Random == null ? (class$net$sf$saxon$exslt$Random = JavaExtensionLibrary.class$("net.sf.saxon.exslt.Random")) : class$net$sf$saxon$exslt$Random);
    }

    public void declareJavaClass(String string, Class clazz) {
        this.explicitMappings.put(string, clazz);
    }

    public boolean isAvailable(int n, String string, String string2, int n2) {
        int n3;
        Object object;
        Class clazz;
        if (!this.config.isAllowExternalFunctions()) {
            return false;
        }
        try {
            clazz = this.getExternalJavaClass(string);
            if (clazz == null) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        Class clazz2 = clazz;
        if ("new".equals(string2)) {
            int n4 = clazz2.getModifiers();
            if (Modifier.isAbstract(n4)) {
                return false;
            }
            if (Modifier.isInterface(n4)) {
                return false;
            }
            if (Modifier.isPrivate(n4)) {
                return false;
            }
            if (Modifier.isProtected(n4)) {
                return false;
            }
            if (n2 == -1) {
                return true;
            }
            Constructor<?>[] constructorArray = clazz2.getConstructors();
            int n5 = 0;
            while (n5 < constructorArray.length) {
                Constructor<?> constructor = constructorArray[n5];
                if (constructor.getParameterTypes().length == n2) {
                    return true;
                }
                ++n5;
            }
            return false;
        }
        String string3 = JavaExtensionLibrary.toCamelCase(string2, false, this.diag);
        Method[] methodArray = clazz2.getMethods();
        int n6 = 0;
        while (n6 < methodArray.length) {
            object = methodArray[n6];
            if (((Method)object).getName().equals(string3) && Modifier.isPublic(((Method)object).getModifiers())) {
                if (n2 == -1) {
                    return true;
                }
                Class<?>[] classArray = ((Method)object).getParameterTypes();
                boolean bl = Modifier.isStatic(((Method)object).getModifiers());
                int n7 = n3 = bl ? n2 : n2 - 1;
                if (n3 >= 0) {
                    if (classArray.length == n3 && (n3 == 0 || classArray[0] != (class$net$sf$saxon$expr$XPathContext == null ? JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext))) {
                        return true;
                    }
                    if (classArray.length == n3 + 1 && classArray[0] == (class$net$sf$saxon$expr$XPathContext == null ? JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext)) {
                        return true;
                    }
                }
            }
            ++n6;
        }
        object = clazz2.getFields();
        int n8 = 0;
        while (n8 < ((Object)object).length) {
            Object object2 = object[n8];
            if (((Field)object2).getName().equals(string3) && Modifier.isPublic(((Field)object2).getModifiers())) {
                if (n2 == -1) {
                    return true;
                }
                boolean bl = Modifier.isStatic(((Field)object2).getModifiers());
                int n9 = n3 = bl ? n2 : n2 - 1;
                if (n3 == 0) {
                    return true;
                }
            }
            ++n8;
        }
        return false;
    }

    public Expression bind(int n, String string, String string2, Expression[] expressionArray) throws XPathException {
        Object object;
        Class clazz;
        boolean bl = this.config.isTraceExternalFunctions();
        if (!this.config.isAllowExternalFunctions()) {
            if (bl) {
                this.diag.println("Calls to extension functions have been disabled");
            }
            return null;
        }
        StaticError staticError = null;
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        Class<?> clazz2 = null;
        try {
            clazz = this.getExternalJavaClass(string);
            if (clazz == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw new StaticError("Cannot load external Java class", exception);
        }
        if (bl) {
            this.diag.println("Looking for method " + string2 + " in Java class " + clazz);
            this.diag.println("Number of actual arguments = " + expressionArray.length);
        }
        int n2 = expressionArray.length;
        Class clazz3 = clazz;
        if ("new".equals(string2)) {
            int n3;
            if (bl) {
                this.diag.println("Looking for a constructor");
            }
            if (Modifier.isAbstract(n3 = clazz3.getModifiers())) {
                staticError = new StaticError("Class " + clazz3 + " is abstract");
            } else if (Modifier.isInterface(n3)) {
                staticError = new StaticError(clazz3 + " is an interface");
            } else if (Modifier.isPrivate(n3)) {
                staticError = new StaticError("Class " + clazz3 + " is private");
            } else if (Modifier.isProtected(n3)) {
                staticError = new StaticError("Class " + clazz3 + " is protected");
            }
            if (staticError != null) {
                if (bl) {
                    this.diag.println("Cannot construct an instance: " + staticError.getMessage());
                }
                return null;
            }
            object = clazz3.getConstructors();
            int n4 = 0;
            while (n4 < ((Executable[])object).length) {
                Executable executable = object[n4];
                if (bl) {
                    this.diag.println("Found a constructor with " + ((Constructor)executable).getParameterTypes().length + " arguments");
                }
                if (((Constructor)executable).getParameterTypes().length == n2) {
                    arrayList.add(executable);
                }
                ++n4;
            }
            if (arrayList.size() == 0) {
                staticError = new StaticError("No constructor with " + n2 + (n2 == 1 ? " parameter" : " parameters") + " found in class " + clazz3.getName());
                if (bl) {
                    this.diag.println(staticError.getMessage());
                }
                return null;
            }
        } else {
            int n5;
            Object object2;
            String string3 = JavaExtensionLibrary.toCamelCase(string2, bl, this.diag);
            object = clazz3.getMethods();
            boolean bl2 = true;
            int n6 = 0;
            while (n6 < ((Method[])object).length) {
                object2 = object[n6];
                if (bl) {
                    if (((Method)object2).getName().equals(string3)) {
                        this.diag.println("Trying method " + ((Method)object2).getName() + ": name matches");
                        if (!Modifier.isPublic(((Method)object2).getModifiers())) {
                            this.diag.println(" -- but the method is not public");
                        }
                    } else {
                        this.diag.println("Trying method " + ((Method)object2).getName() + ": name does not match");
                    }
                }
                if (((Method)object2).getName().equals(string3) && Modifier.isPublic(((Method)object2).getModifiers())) {
                    if (bl2) {
                        if (clazz2 == null) {
                            clazz2 = ((Method)object2).getReturnType();
                        } else {
                            bl2 = ((Method)object2).getReturnType() == clazz2;
                        }
                    }
                    Class<?>[] classArray = ((Method)object2).getParameterTypes();
                    boolean bl3 = Modifier.isStatic(((Method)object2).getModifiers());
                    if (bl) {
                        this.diag.println("Method is " + (bl3 ? "" : "not ") + "static");
                    }
                    int n7 = n5 = bl3 ? n2 : n2 - 1;
                    if (n5 >= 0) {
                        if (bl) {
                            this.diag.println("Method has " + classArray.length + " argument" + (classArray.length == 1 ? "" : "s") + "; expecting " + n5);
                        }
                        if (classArray.length == n5 && (n5 == 0 || classArray[0] != (class$net$sf$saxon$expr$XPathContext == null ? JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext))) {
                            if (bl) {
                                this.diag.println("Found a candidate method:");
                                this.diag.println("    " + object2);
                            }
                            arrayList.add(object2);
                        }
                        if (classArray.length == n5 + 1 && classArray[0] == (class$net$sf$saxon$expr$XPathContext == null ? JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext") : class$net$sf$saxon$expr$XPathContext)) {
                            if (bl) {
                                this.diag.println("Method is a candidate because first argument is XPathContext");
                            }
                            arrayList.add(object2);
                        }
                    }
                }
                ++n6;
            }
            object2 = clazz3.getFields();
            int n8 = 0;
            while (n8 < ((Object)object2).length) {
                Object object3 = object2[n8];
                if (bl) {
                    if (((Field)object3).getName().equals(string3)) {
                        this.diag.println("Trying field " + ((Field)object3).getName() + ": name matches");
                        if (!Modifier.isPublic(((Field)object3).getModifiers())) {
                            this.diag.println(" -- but the field is not public");
                        }
                    } else {
                        this.diag.println("Trying field " + ((Field)object3).getName() + ": name does not match");
                    }
                }
                if (((Field)object3).getName().equals(string3) && Modifier.isPublic(((Field)object3).getModifiers())) {
                    if (bl2) {
                        if (clazz2 == null) {
                            clazz2 = ((Field)object3).getType();
                        } else {
                            bl2 = ((Field)object3).getType() == clazz2;
                        }
                    }
                    boolean bl4 = Modifier.isStatic(((Field)object3).getModifiers());
                    if (bl) {
                        this.diag.println("Field is " + (bl4 ? "" : "not ") + "static");
                    }
                    int n9 = n5 = bl4 ? n2 : n2 - 1;
                    if (n5 == 0) {
                        if (bl) {
                            this.diag.println("Found a candidate field:");
                            this.diag.println("    " + object3);
                        }
                        arrayList.add(object3);
                    }
                }
                ++n8;
            }
            if (arrayList.size() == 0) {
                staticError = new StaticError("No method or field matching " + string3 + " with " + n2 + (n2 == 1 ? " parameter" : " parameters") + " found in class " + clazz3.getName());
                if (bl) {
                    this.diag.println(staticError.getMessage());
                }
                return null;
            }
        }
        if (arrayList.size() == 0) {
            if (bl) {
                this.diag.println("There is no suitable method matching the arguments of function " + string2);
            }
            return null;
        }
        AccessibleObject accessibleObject = this.getBestFit(arrayList, expressionArray);
        if (accessibleObject == null) {
            return null;
        }
        object = this.config.getExtensionFunctionFactory();
        return ((ExtensionFunctionFactory)object).makeExtensionFunctionCall(n, clazz3, accessibleObject, expressionArray);
    }

    private AccessibleObject getBestFit(List list, Expression[] expressionArray) {
        int[] nArray;
        int n;
        boolean bl = this.config.isTraceExternalFunctions();
        int n2 = list.size();
        if (n2 == 1) {
            return (AccessibleObject)list.get(0);
        }
        if (bl) {
            this.diag.println("Finding best fit method with arguments:");
            int n3 = 0;
            while (n3 < expressionArray.length) {
                expressionArray[n3].display(10, this.config.getNamePool(), this.diag);
                ++n3;
            }
        }
        boolean[] blArray = new boolean[n2];
        int n4 = 0;
        while (n4 < n2) {
            blArray[n4] = false;
            ++n4;
        }
        if (bl) {
            n = 0;
            while (n < n2) {
                nArray = this.getConversionPreferences(expressionArray, (AccessibleObject)list.get(n));
                this.diag.println("Trying option " + n + ": " + list.get(n).toString());
                if (nArray == null) {
                    this.diag.println("Arguments cannot be converted to required types");
                } else {
                    String string = "[";
                    int n5 = 0;
                    while (n5 < nArray.length) {
                        if (n5 != 0) {
                            string = string + ", ";
                        }
                        string = string + nArray[n5];
                        ++n5;
                    }
                    string = string + "]";
                    this.diag.println("Conversion preferences are " + string);
                }
                ++n;
            }
        }
        n = 0;
        while (n < n2) {
            nArray = this.getConversionPreferences(expressionArray, (AccessibleObject)list.get(n));
            if (nArray == null) {
                blArray[n] = true;
            }
            if (!blArray[n]) {
                int n6 = n + 1;
                while (n6 < n2) {
                    if (!blArray[n6]) {
                        int[] nArray2 = this.getConversionPreferences(expressionArray, (AccessibleObject)list.get(n6));
                        if (nArray2 == null) {
                            blArray[n6] = true;
                        } else {
                            int n7 = 0;
                            while (n7 < nArray2.length) {
                                if (nArray[n7] > nArray2[n7] && !blArray[n]) {
                                    blArray[n] = true;
                                    if (bl) {
                                        this.diag.println("Eliminating option " + n);
                                    }
                                }
                                if (nArray[n7] < nArray2[n7] && !blArray[n6]) {
                                    blArray[n6] = true;
                                    if (bl) {
                                        this.diag.println("Eliminating option " + n6);
                                    }
                                }
                                ++n7;
                            }
                        }
                    }
                    ++n6;
                }
            }
            ++n;
        }
        int n8 = 0;
        AccessibleObject accessibleObject = null;
        int n9 = 0;
        while (n9 < n2) {
            if (!blArray[n9]) {
                accessibleObject = (AccessibleObject)list.get(n9);
                ++n8;
            }
            ++n9;
        }
        if (bl) {
            this.diag.println("Number of candidate methods remaining: " + n8);
        }
        if (n8 == 0) {
            if (bl) {
                this.diag.println("There are " + n2 + " candidate Java methods matching the function name, but none is a unique best match");
            }
            return null;
        }
        if (n8 > 1) {
            if (bl) {
                this.diag.println("There are several Java methods that match the function name equally well");
            }
            return null;
        }
        return accessibleObject;
    }

    private static String toCamelCase(String string, boolean bl, PrintStream printStream) {
        if (string.indexOf(45) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            boolean bl2 = false;
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '-') {
                    bl2 = true;
                } else {
                    if (bl2) {
                        stringBuffer.append(Character.toUpperCase(c));
                    } else {
                        stringBuffer.append(c);
                    }
                    bl2 = false;
                }
                ++n;
            }
            string = stringBuffer.toString();
            if (bl) {
                printStream.println("Seeking a method with adjusted name " + string);
            }
        }
        return string;
    }

    private int[] getConversionPreferences(Expression[] expressionArray, AccessibleObject accessibleObject) {
        int n;
        Class<?>[] classArray;
        int n2;
        if (accessibleObject instanceof Constructor) {
            n2 = 0;
            classArray = ((Constructor)accessibleObject).getParameterTypes();
        } else if (accessibleObject instanceof Method) {
            n = Modifier.isStatic(((Method)accessibleObject).getModifiers());
            n2 = n != 0 ? 0 : 1;
            classArray = ((Method)accessibleObject).getParameterTypes();
        } else if (accessibleObject instanceof Field) {
            n = Modifier.isStatic(((Field)accessibleObject).getModifiers());
            n2 = n != 0 ? 0 : 1;
            classArray = NO_PARAMS;
        } else {
            throw new AssertionError((Object)("property " + accessibleObject + " was neither constructor, method, nor field"));
        }
        n = expressionArray.length - n2;
        int[] nArray = new int[n];
        int n3 = 0;
        if (classArray.length > 0 && classArray[0] == (class$net$sf$saxon$expr$XPathContext == null ? (class$net$sf$saxon$expr$XPathContext = JavaExtensionLibrary.class$("net.sf.saxon.expr.XPathContext")) : class$net$sf$saxon$expr$XPathContext)) {
            n3 = 1;
        }
        int n4 = 0;
        while (n4 < n) {
            nArray[n4] = this.getConversionPreference(expressionArray[n4 + n2], classArray[n4 + n3]);
            if (nArray[n4] == -1) {
                return null;
            }
            ++n4;
        }
        return nArray;
    }

    private int getConversionPreference(Expression expression, Class clazz) {
        ItemType itemType = expression.getItemType();
        int n = expression.getCardinality();
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = JavaExtensionLibrary.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 100;
        }
        if (Cardinality.allowsMany(n)) {
            if (clazz.isAssignableFrom(class$net$sf$saxon$om$SequenceIterator == null ? (class$net$sf$saxon$om$SequenceIterator = JavaExtensionLibrary.class$("net.sf.saxon.om.SequenceIterator")) : class$net$sf$saxon$om$SequenceIterator)) {
                return 20;
            }
            if (clazz.isAssignableFrom(class$net$sf$saxon$value$SequenceValue == null ? (class$net$sf$saxon$value$SequenceValue = JavaExtensionLibrary.class$("net.sf.saxon.value.SequenceValue")) : class$net$sf$saxon$value$SequenceValue)) {
                return 21;
            }
            if ((class$net$sf$saxon$functions$Collection == null ? (class$net$sf$saxon$functions$Collection = JavaExtensionLibrary.class$("net.sf.saxon.functions.Collection")) : class$net$sf$saxon$functions$Collection).isAssignableFrom(clazz)) {
                return 22;
            }
            if (clazz.isAssignableFrom(class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = JavaExtensionLibrary.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList)) {
                return 23;
            }
            if (clazz.isArray()) {
                return 24;
            }
            return -1;
        }
        if (Type.isNodeType(itemType)) {
            if (clazz.isAssignableFrom(class$net$sf$saxon$om$NodeInfo == null ? (class$net$sf$saxon$om$NodeInfo = JavaExtensionLibrary.class$("net.sf.saxon.om.NodeInfo")) : class$net$sf$saxon$om$NodeInfo)) {
                return 20;
            }
            if (clazz.isAssignableFrom(class$net$sf$saxon$om$DocumentInfo == null ? (class$net$sf$saxon$om$DocumentInfo = JavaExtensionLibrary.class$("net.sf.saxon.om.DocumentInfo")) : class$net$sf$saxon$om$DocumentInfo)) {
                return 21;
            }
            if (clazz.isAssignableFrom(class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = JavaExtensionLibrary.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node)) {
                return 22;
            }
            if (clazz.isAssignableFrom(class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = JavaExtensionLibrary.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList)) {
                return 23;
            }
            return -1;
        }
        int n2 = itemType.getPrimitiveType();
        return this.atomicConversionPreference(n2, clazz);
    }

    protected int atomicConversionPreference(int n, Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = JavaExtensionLibrary.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 100;
        }
        switch (n) {
            case 513: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$StringValue == null ? (class$net$sf$saxon$value$StringValue = JavaExtensionLibrary.class$("net.sf.saxon.value.StringValue")) : class$net$sf$saxon$value$StringValue)) {
                    return 50;
                }
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = JavaExtensionLibrary.class$("java.lang.String")) : class$java$lang$String)) {
                    return 51;
                }
                if (clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = JavaExtensionLibrary.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
                    return 51;
                }
                return -1;
            }
            case 517: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$DoubleValue == null ? (class$net$sf$saxon$value$DoubleValue = JavaExtensionLibrary.class$("net.sf.saxon.value.DoubleValue")) : class$net$sf$saxon$value$DoubleValue)) {
                    return 50;
                }
                if (clazz == Double.TYPE) {
                    return 50;
                }
                if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = JavaExtensionLibrary.class$("java.lang.Double")) : class$java$lang$Double)) {
                    return 51;
                }
                return -1;
            }
            case 516: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$FloatValue == null ? (class$net$sf$saxon$value$FloatValue = JavaExtensionLibrary.class$("net.sf.saxon.value.FloatValue")) : class$net$sf$saxon$value$FloatValue)) {
                    return 50;
                }
                if (clazz == Float.TYPE) {
                    return 50;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = JavaExtensionLibrary.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return 51;
                }
                if (clazz == Double.TYPE) {
                    return 52;
                }
                if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = JavaExtensionLibrary.class$("java.lang.Double")) : class$java$lang$Double)) {
                    return 53;
                }
                return -1;
            }
            case 515: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$DecimalValue == null ? (class$net$sf$saxon$value$DecimalValue = JavaExtensionLibrary.class$("net.sf.saxon.value.DecimalValue")) : class$net$sf$saxon$value$DecimalValue)) {
                    return 50;
                }
                if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JavaExtensionLibrary.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                    return 50;
                }
                if (clazz == Double.TYPE) {
                    return 51;
                }
                if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = JavaExtensionLibrary.class$("java.lang.Double")) : class$java$lang$Double)) {
                    return 52;
                }
                if (clazz == Float.TYPE) {
                    return 53;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = JavaExtensionLibrary.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return 54;
                }
                return -1;
            }
            case 532: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$IntegerValue == null ? (class$net$sf$saxon$value$IntegerValue = JavaExtensionLibrary.class$("net.sf.saxon.value.IntegerValue")) : class$net$sf$saxon$value$IntegerValue)) {
                    return 50;
                }
                if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = JavaExtensionLibrary.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
                    return 51;
                }
                if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JavaExtensionLibrary.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                    return 52;
                }
                if (clazz == Long.TYPE) {
                    return 53;
                }
                if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = JavaExtensionLibrary.class$("java.lang.Long")) : class$java$lang$Long)) {
                    return 54;
                }
                if (clazz == Integer.TYPE) {
                    return 55;
                }
                if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = JavaExtensionLibrary.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    return 56;
                }
                if (clazz == Short.TYPE) {
                    return 57;
                }
                if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = JavaExtensionLibrary.class$("java.lang.Short")) : class$java$lang$Short)) {
                    return 58;
                }
                if (clazz == Byte.TYPE) {
                    return 59;
                }
                if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = JavaExtensionLibrary.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                    return 60;
                }
                if (clazz == Double.TYPE) {
                    return 61;
                }
                if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = JavaExtensionLibrary.class$("java.lang.Double")) : class$java$lang$Double)) {
                    return 62;
                }
                if (clazz == Float.TYPE) {
                    return 63;
                }
                if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = JavaExtensionLibrary.class$("java.lang.Float")) : class$java$lang$Float)) {
                    return 64;
                }
                return -1;
            }
            case 514: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$BooleanValue == null ? (class$net$sf$saxon$value$BooleanValue = JavaExtensionLibrary.class$("net.sf.saxon.value.BooleanValue")) : class$net$sf$saxon$value$BooleanValue)) {
                    return 50;
                }
                if (clazz == Boolean.TYPE) {
                    return 51;
                }
                if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaExtensionLibrary.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return 52;
                }
                return -1;
            }
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateValue == null ? (class$net$sf$saxon$value$DateValue = JavaExtensionLibrary.class$("net.sf.saxon.value.DateValue")) : class$net$sf$saxon$value$DateValue)) {
                    return 50;
                }
                if (clazz.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = JavaExtensionLibrary.class$("java.util.Date")) : class$java$util$Date)) {
                    return 51;
                }
                return -1;
            }
            case 519: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateTimeValue == null ? (class$net$sf$saxon$value$DateTimeValue = JavaExtensionLibrary.class$("net.sf.saxon.value.DateTimeValue")) : class$net$sf$saxon$value$DateTimeValue)) {
                    return 50;
                }
                if (clazz.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = JavaExtensionLibrary.class$("java.util.Date")) : class$java$util$Date)) {
                    return 51;
                }
                return -1;
            }
            case 520: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$TimeValue == null ? (class$net$sf$saxon$value$TimeValue = JavaExtensionLibrary.class$("net.sf.saxon.value.TimeValue")) : class$net$sf$saxon$value$TimeValue)) {
                    return 50;
                }
                return -1;
            }
            case 518: 
            case 644: 
            case 645: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = JavaExtensionLibrary.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
                    return 50;
                }
                return -1;
            }
            case 529: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$AnyURIValue == null ? (class$net$sf$saxon$value$AnyURIValue = JavaExtensionLibrary.class$("net.sf.saxon.value.AnyURIValue")) : class$net$sf$saxon$value$AnyURIValue)) {
                    return 50;
                }
                if (clazz == (class$java$net$URI == null ? (class$java$net$URI = JavaExtensionLibrary.class$("java.net.URI")) : class$java$net$URI)) {
                    return 51;
                }
                if (clazz == (class$java$net$URL == null ? (class$java$net$URL = JavaExtensionLibrary.class$("java.net.URL")) : class$java$net$URL)) {
                    return 52;
                }
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = JavaExtensionLibrary.class$("java.lang.String")) : class$java$lang$String)) {
                    return 53;
                }
                if (clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = JavaExtensionLibrary.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
                    return 53;
                }
                return -1;
            }
            case 530: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$QNameValue == null ? (class$net$sf$saxon$value$QNameValue = JavaExtensionLibrary.class$("net.sf.saxon.value.QNameValue")) : class$net$sf$saxon$value$QNameValue)) {
                    return 50;
                }
                return -1;
            }
            case 528: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$Base64BinaryValue == null ? (class$net$sf$saxon$value$Base64BinaryValue = JavaExtensionLibrary.class$("net.sf.saxon.value.Base64BinaryValue")) : class$net$sf$saxon$value$Base64BinaryValue)) {
                    return 50;
                }
                return -1;
            }
            case 527: {
                if (clazz.isAssignableFrom(class$net$sf$saxon$value$HexBinaryValue == null ? (class$net$sf$saxon$value$HexBinaryValue = JavaExtensionLibrary.class$("net.sf.saxon.value.HexBinaryValue")) : class$net$sf$saxon$value$HexBinaryValue)) {
                    return 50;
                }
                return -1;
            }
            case 642: {
                return 50;
            }
        }
        return -1;
    }

    private Class getExternalJavaClass(String string) {
        Class clazz = (Class)this.explicitMappings.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            if (string.startsWith("java:")) {
                return Loader.getClass(string.substring(5), this.config.isTraceExternalFunctions());
            }
            int n = string.lastIndexOf(47);
            if (n < 0) {
                return Loader.getClass(string, this.config.isTraceExternalFunctions());
            }
            if (n == string.length() - 1) {
                return null;
            }
            return Loader.getClass(string.substring(n + 1), this.config.isTraceExternalFunctions());
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

