/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Set;
import net.sf.saxon.expr.Token;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;

public class CombinedNodeTest
extends NodeTest {
    private NodeTest nodetest1;
    private NodeTest nodetest2;
    private int operator;

    public CombinedNodeTest(NodeTest nodeTest, int n, NodeTest nodeTest2) {
        this.nodetest1 = nodeTest;
        this.operator = n;
        this.nodetest2 = nodeTest2;
    }

    public boolean matches(int n, int n2, int n3) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(n, n2, n3) || this.nodetest2.matches(n, n2, n3);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(n, n2, n3) || this.nodetest2 != null && !this.nodetest2.matches(n, n2, n3));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(n, n2, n3)) && this.nodetest2 != null && !this.nodetest2.matches(n, n2, n3);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public boolean matches(NodeInfo nodeInfo) {
        switch (this.operator) {
            case 1: {
                return this.nodetest1 == null || this.nodetest2 == null || this.nodetest1.matches(nodeInfo) || this.nodetest2.matches(nodeInfo);
            }
            case 23: {
                return !(this.nodetest1 != null && !this.nodetest1.matches(nodeInfo) || this.nodetest2 != null && !this.nodetest2.matches(nodeInfo));
            }
            case 24: {
                return (this.nodetest1 == null || this.nodetest1.matches(nodeInfo)) && this.nodetest2 != null && !this.nodetest2.matches(nodeInfo);
            }
        }
        throw new IllegalArgumentException("Unknown operator in Combined Node Test");
    }

    public String toString() {
        String string;
        if (this.nodetest1 instanceof NameTest) {
            int n = this.nodetest1.getPrimitiveType();
            string = "";
            if (this.nodetest2 instanceof ContentTypeTest) {
                string = ", " + ((ContentTypeTest)this.nodetest2).getSchemaType().getDisplayName();
            }
            if (n == 1) {
                return "schema-element(*" + string + ")";
            }
            if (n == 2) {
                return "schema-attribute(*" + string + ")";
            }
        }
        String string2 = this.nodetest1 == null ? "true()" : this.nodetest1.toString();
        string = this.nodetest2 == null ? "true()" : this.nodetest2.toString();
        return "(" + string2 + " " + Token.tokens[this.operator] + " " + string + ")";
    }

    public boolean allowsTextNodes() {
        return this.nodetest1.allowsTextNodes() && this.nodetest2.allowsTextNodes();
    }

    public int getNodeKindMask() {
        return this.nodetest1.getNodeKindMask() & this.nodetest2.getNodeKindMask();
    }

    public Set getRequiredNodeNames() {
        if (this.nodetest2.getRequiredNodeNames() == null) {
            return this.nodetest1.getRequiredNodeNames();
        }
        if (this.nodetest1.getRequiredNodeNames() == null) {
            return this.nodetest2.getRequiredNodeNames();
        }
        throw new UnsupportedOperationException("Combined nodetest has multiple name constraints");
    }

    public SchemaType getContentType() {
        if (this.nodetest2.getContentType() instanceof AnyType) {
            return this.nodetest1.getContentType();
        }
        if (this.nodetest1.getContentType() instanceof AnyType) {
            return this.nodetest2.getContentType();
        }
        throw new UnsupportedOperationException("Combined nodetest has multiple content type constraints");
    }

    public int hashCode() {
        return this.nodetest1.hashCode() ^ this.nodetest2.hashCode();
    }

    public double getDefaultPriority() {
        return 0.25;
    }
}

