/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public abstract class SequenceValue
extends Value {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$SequenceValue;
    static /* synthetic */ Class class$net$sf$saxon$om$SequenceIterator;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$net$sf$saxon$om$Item;
    static /* synthetic */ Class class$net$sf$saxon$om$NodeInfo;
    static /* synthetic */ Class class$net$sf$saxon$om$DocumentInfo;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$org$w3c$dom$NodeList;

    public SequenceExtent materialize() throws XPathException {
        return new SequenceExtent(this.iterate(null));
    }

    public final int getImplementationMethod() {
        return 1;
    }

    public final void process(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.iterate(xPathContext);
        while ((item = sequenceIterator.next()) != null) {
            xPathContext.getReceiver().append(item, 0);
        }
    }

    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    public int getCardinality() {
        try {
            SequenceIterator sequenceIterator = this.iterate(null);
            Item item = sequenceIterator.next();
            if (item == null) {
                return 256;
            }
            if (sequenceIterator.next() != null) {
                return 1536;
            }
            return 512;
        }
        catch (XPathException xPathException) {
            return 1792;
        }
    }

    public Item itemAt(int n) throws XPathException {
        Item item;
        if (n < 0) {
            return null;
        }
        int n2 = 0;
        SequenceIterator sequenceIterator = this.iterate(null);
        do {
            if ((item = sequenceIterator.next()) != null) continue;
            return null;
        } while (n2++ != n);
        return item;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.iterate(xPathContext).next();
    }

    public String getStringValue() throws XPathException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        SequenceIterator sequenceIterator = this.iterate(null);
        Item item = sequenceIterator.next();
        if (item != null) {
            while (true) {
                stringBuffer.append(item.getStringValue());
                item = sequenceIterator.next();
                if (item == null) break;
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return "";
        }
        return atomicValue.getStringValue();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.iterate(xPathContext);
        Item item = sequenceIterator.next();
        if (item == null) {
            return false;
        }
        if (item instanceof NodeInfo) {
            return true;
        }
        if (item instanceof BooleanValue) {
            return ((BooleanValue)item).getBooleanValue() || sequenceIterator.next() != null;
        }
        if (item instanceof StringValue) {
            return !"".equals(item.getStringValue()) || sequenceIterator.next() != null;
        }
        if (item instanceof NumericValue) {
            return sequenceIterator.next() != null || !item.equals(DoubleValue.ZERO) && item.equals(item);
        }
        return true;
    }

    public Object convertToJava(Class clazz, Configuration configuration, XPathContext xPathContext) throws XPathException {
        Item item;
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SequenceValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.iterate(null);
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$SequenceValue == null ? (class$net$sf$saxon$value$SequenceValue = SequenceValue.class$("net.sf.saxon.value.SequenceValue")) : class$net$sf$saxon$value$SequenceValue)) {
            return this;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$om$SequenceIterator == null ? (class$net$sf$saxon$om$SequenceIterator = SequenceValue.class$("net.sf.saxon.om.SequenceIterator")) : class$net$sf$saxon$om$SequenceIterator)) {
            return this.iterate(null);
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = SequenceValue.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            Collection<Item> collection;
            if (clazz.isAssignableFrom(class$java$util$ArrayList == null ? (class$java$util$ArrayList = SequenceValue.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
                collection = new ArrayList(100);
            } else {
                try {
                    collection = (Collection)clazz.newInstance();
                }
                catch (Exception exception) {
                    DynamicError dynamicError = new DynamicError("Cannot instantiate collection class " + clazz);
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
            }
            SequenceIterator sequenceIterator = this.iterate(null);
            while (true) {
                Item item2;
                if ((item2 = sequenceIterator.next()) == null) {
                    return collection;
                }
                collection.add(item2);
            }
        }
        if (clazz.isArray()) {
            Object object;
            int n;
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isAssignableFrom(class$net$sf$saxon$om$Item == null ? (class$net$sf$saxon$om$Item = SequenceValue.class$("net.sf.saxon.om.Item")) : class$net$sf$saxon$om$Item) || clazz2.isAssignableFrom(class$net$sf$saxon$om$NodeInfo == null ? (class$net$sf$saxon$om$NodeInfo = SequenceValue.class$("net.sf.saxon.om.NodeInfo")) : class$net$sf$saxon$om$NodeInfo) || clazz2.isAssignableFrom(class$net$sf$saxon$om$DocumentInfo == null ? (class$net$sf$saxon$om$DocumentInfo = SequenceValue.class$("net.sf.saxon.om.DocumentInfo")) : class$net$sf$saxon$om$DocumentInfo) || clazz2.isAssignableFrom(class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = SequenceValue.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node)) {
                SequenceExtent sequenceExtent = this.materialize();
                int n2 = sequenceExtent.getLength();
                Object object2 = Array.newInstance(clazz2, n2);
                int n3 = 0;
                while (n3 < n2) {
                    try {
                        Array.set(object2, n3, sequenceExtent.itemAt(n3));
                    }
                    catch (Exception exception) {
                        DynamicError dynamicError = new DynamicError("Cannot convert item in sequence to the component type of the Java array", exception);
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                    ++n3;
                }
                return object2;
            }
            SequenceIterator sequenceIterator = new Atomizer(this).iterate(xPathContext);
            if (sequenceIterator instanceof LastPositionFinder) {
                n = ((LastPositionFinder)sequenceIterator).getLastPosition();
            } else {
                object = new SequenceExtent(sequenceIterator);
                n = ((SequenceExtent)object).getLength();
                sequenceIterator = ((SequenceExtent)object).iterate(xPathContext);
            }
            object = Array.newInstance(clazz2, n);
            int n4 = 0;
            while (n4 < n) {
                Object object3;
                try {
                    AtomicValue atomicValue = (AtomicValue)sequenceIterator.next();
                    object3 = atomicValue.convertToJava(clazz2, configuration, xPathContext);
                    Array.set(object, n4, object3);
                }
                catch (Exception exception) {
                    object3 = new DynamicError("Cannot convert item in atomized sequence to the component type of the Java array", exception);
                    ((DynamicError)object3).setXPathContext(xPathContext);
                    throw object3;
                }
                ++n4;
            }
            return object;
        }
        if (clazz.isAssignableFrom(class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = SequenceValue.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList)) {
            return DOMNodeList.checkAndMake(this.materialize());
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$om$Item == null ? (class$net$sf$saxon$om$Item = SequenceValue.class$("net.sf.saxon.om.Item")) : class$net$sf$saxon$om$Item) || clazz.isAssignableFrom(class$net$sf$saxon$om$NodeInfo == null ? (class$net$sf$saxon$om$NodeInfo = SequenceValue.class$("net.sf.saxon.om.NodeInfo")) : class$net$sf$saxon$om$NodeInfo) || clazz.isAssignableFrom(class$net$sf$saxon$om$DocumentInfo == null ? (class$net$sf$saxon$om$DocumentInfo = SequenceValue.class$("net.sf.saxon.om.DocumentInfo")) : class$net$sf$saxon$om$DocumentInfo) || clazz.isAssignableFrom(class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = SequenceValue.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node)) {
            Object object;
            SequenceIterator sequenceIterator = this.iterate(null);
            Item item3 = null;
            while ((object = sequenceIterator.next()) != null) {
                if (item3 != null) {
                    DynamicError dynamicError = new DynamicError("Sequence contains more than one value; Java method expects only one");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                item3 = object;
            }
            if (item3 == null) {
                return null;
            }
            if (clazz.isAssignableFrom(item3.getClass())) {
                return item3;
            }
            object = item3;
            while (object instanceof VirtualNode) {
                Object object4 = ((VirtualNode)object).getUnderlyingNode();
                if (clazz.isAssignableFrom(object4.getClass())) {
                    return object4;
                }
                object = object4;
            }
            throw new DynamicError("Cannot convert supplied XPath value to the required type for the extension function");
        }
        SequenceIterator sequenceIterator = new Atomizer(this).iterate(xPathContext);
        Item item4 = null;
        while ((item = sequenceIterator.next()) != null) {
            if (item4 != null) {
                DynamicError dynamicError = new DynamicError("Sequence contains more than one value; Java method expects only one");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            item4 = item;
        }
        if (item4 == null) {
            return null;
        }
        if (clazz.isAssignableFrom(item4.getClass())) {
            return item4;
        }
        return ((AtomicValue)item4).convertToJava(clazz, configuration, xPathContext);
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        try {
            Item item;
            printStream.println(ExpressionTool.indent(n) + "sequence of " + this.getItemType().toString() + " (");
            SequenceIterator sequenceIterator = this.iterate(null);
            while ((item = sequenceIterator.next()) != null) {
                ((ComputedExpression)((Object)item)).display(n + 1, namePool, printStream);
            }
            printStream.println(ExpressionTool.indent(n) + ")");
        }
        catch (Exception exception) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

