/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class DateTimeValue
extends CalendarValue
implements Comparable {
    private Date UTCDate = null;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$net$sf$saxon$value$DateTimeValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Object;

    public DateTimeValue(XPathContext xPathContext) {
        Controller controller = xPathContext.getController();
        this.calendar = controller == null ? new GregorianCalendar() : controller.getCurrentDateTime();
        this.zoneSpecified = true;
    }

    public DateTimeValue(GregorianCalendar gregorianCalendar, boolean bl) {
        this.calendar = gregorianCalendar;
        this.zoneSpecified = bl;
    }

    public DateTimeValue(DateValue dateValue, TimeValue timeValue) throws XPathException {
        SecondsDurationValue secondsDurationValue = (SecondsDurationValue)dateValue.getComponent(7);
        SecondsDurationValue secondsDurationValue2 = (SecondsDurationValue)timeValue.getComponent(7);
        boolean bl = this.zoneSpecified = secondsDurationValue != null || secondsDurationValue2 != null;
        if (secondsDurationValue != null && secondsDurationValue2 != null && !secondsDurationValue.equals(secondsDurationValue2)) {
            DynamicError dynamicError = new DynamicError("Supplied date and time are in different timezones");
            throw dynamicError;
        }
        SecondsDurationValue secondsDurationValue3 = secondsDurationValue == null ? secondsDurationValue2 : secondsDurationValue;
        int n = secondsDurationValue3 == null ? 0 : (int)secondsDurationValue3.getLengthInMilliseconds();
        TimeZone timeZone = secondsDurationValue3 == null ? TimeZone.getTimeZone("GMT") : new SimpleTimeZone(n, "LLL");
        this.calendar = new GregorianCalendar(timeZone);
        this.calendar.setLenient(false);
        int n2 = (int)((IntegerValue)dateValue.getComponent(1)).longValue();
        int n3 = (int)((IntegerValue)dateValue.getComponent(2)).longValue();
        int n4 = (int)((IntegerValue)dateValue.getComponent(3)).longValue();
        int n5 = (int)((IntegerValue)timeValue.getComponent(4)).longValue();
        int n6 = (int)((IntegerValue)timeValue.getComponent(5)).longValue();
        BigDecimal bigDecimal = ((DecimalValue)timeValue.getComponent(6)).getValue();
        int n7 = bigDecimal.intValue();
        int n8 = bigDecimal.multiply(BigDecimal.valueOf(1000L)).intValue() % 1000;
        this.calendar.set(Math.abs(n2), n3 - 1, n4, n5, n6, n7);
        if (n2 < 0) {
            this.calendar.set(0, 0);
        }
        this.calendar.set(14, n8);
        this.calendar.set(15, n);
        this.calendar.set(16, 0);
    }

    public DateTimeValue(CharSequence charSequence) throws XPathException {
        this.zoneSpecified = false;
        StringTokenizer stringTokenizer = new StringTokenizer(Value.trimWhitespace(charSequence).toString(), "-:.+TZ", true);
        try {
            Object object;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("too short");
            }
            String string = (String)stringTokenizer.nextElement();
            int n = 1;
            if ("+".equals(string)) {
                string = (String)stringTokenizer.nextElement();
            } else if ("-".equals(string)) {
                n = -1;
                string = (String)stringTokenizer.nextElement();
            }
            int n2 = Integer.parseInt(string) * n;
            if (string.length() < 4) {
                this.badDate("Year is less than four digits");
            }
            if (n2 == 0) {
                this.badDate("Year zero is not allowed");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short");
            }
            if (!"-".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after year");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n3 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badDate("Month must be two digits");
            }
            if (n3 < 1 || n3 > 12) {
                this.badDate("Month is out of range");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short");
            }
            if (!"-".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after month");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n4 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badDate("Day must be two digits");
            }
            if (n4 < 1 || n4 > 31) {
                this.badDate("Day is out of range");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short");
            }
            if (!"T".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after day");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n5 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badDate("Hour must be two digits");
            }
            if (n5 > 23) {
                this.badDate("Hour is out of range");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short");
            }
            if (!":".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after hour");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n6 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badDate("Minute must be two digits");
            }
            if (n6 > 59) {
                this.badDate("Minute is out of range");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short");
            }
            if (!":".equals(stringTokenizer.nextElement())) {
                this.badDate("Wrong delimiter after minute");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("Too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n7 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badDate("Second must be two digits");
            }
            if (n5 > 61) {
                this.badDate("Second is out of range");
            }
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (stringTokenizer.hasMoreElements()) {
                if (n10 == 9) {
                    this.badDate("Characters after the end");
                }
                if (".".equals(object = (String)stringTokenizer.nextElement())) {
                    if (n10 != 0) {
                        this.badDate("Decimal separator occurs twice");
                    }
                    string = (String)stringTokenizer.nextElement();
                    double d = Double.parseDouble("." + string);
                    n8 = (int)Math.round(d * 1000.0);
                    n10 = 1;
                    continue;
                }
                if ("Z".equals(object)) {
                    if (n10 > 1) {
                        this.badDate("Z cannot occur here");
                    }
                    this.zoneSpecified = true;
                    n9 = 0;
                    n10 = 9;
                    continue;
                }
                if ("+".equals(object) || "-".equals(object)) {
                    if (n10 > 1) {
                        this.badDate((String)object + " cannot occur here");
                    }
                    n10 = 2;
                    this.zoneSpecified = true;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("Missing timezone");
                    }
                    if ((string = (String)stringTokenizer.nextElement()).length() != 2) {
                        this.badDate("Timezone hour must be two digits");
                    }
                    if ((n9 = Integer.parseInt(string) * 60) > 840) {
                        this.badDate("Timezone hour is out of range");
                    }
                    if (!"-".equals(object)) continue;
                    n9 = -n9;
                    continue;
                }
                if (":".equals(object)) {
                    if (n10 != 2) {
                        this.badDate("Misplaced ':'");
                    }
                    n10 = 9;
                    string = (String)stringTokenizer.nextElement();
                    int n11 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badDate("Timezone minute must be two digits");
                    }
                    if (n11 > 59) {
                        this.badDate("Timezone minute is out of range");
                    }
                    if (n9 < 0) {
                        n11 = -n11;
                    }
                    n9 += n11;
                    continue;
                }
                this.badDate("Timezone format is incorrect");
            }
            if (n10 == 2 || n10 == 3) {
                this.badDate("Timezone incomplete");
            }
            object = new SimpleTimeZone(n9 * 60000, "LLL");
            this.calendar = new GregorianCalendar((TimeZone)object);
            this.calendar.setLenient(false);
            this.calendar.set(Math.abs(n2), n3 - 1, n4, n5, n6, n7);
            if (n2 < 0) {
                this.calendar.set(0, 0);
            }
            this.calendar.set(14, n8);
            this.calendar.set(15, n9 * 60000);
            this.calendar.set(16, 0);
            try {
                this.calendar.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.badDate("Non-existent date");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badDate("Non-numeric component");
        }
    }

    private void badDate(String string) throws XPathException {
        DynamicError dynamicError = new DynamicError("Invalid dateTime value. " + string);
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public Date getUTCDate() {
        if (this.UTCDate == null) {
            this.UTCDate = this.calendar.getTime();
        }
        return this.UTCDate;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public AtomicValue convert(int n, XPathContext xPathContext) throws XPathException {
        switch (n) {
            case 88: 
            case 519: 
            case 643: {
                return this;
            }
            case 521: {
                String string = this.getStringValue();
                int n2 = string.indexOf(84);
                if (this.zoneSpecified) {
                    int n3 = string.indexOf(90, n2);
                    if (n3 < 0) {
                        n3 = string.indexOf(43, n2);
                    }
                    if (n3 < 0) {
                        n3 = string.indexOf(45, n2);
                    }
                    if (n3 < 0) {
                        throw new IllegalArgumentException("Internal date formatting error " + string);
                    }
                    return new DateValue(string.substring(0, n2) + string.substring(n3));
                }
                return new DateValue(string.substring(0, n2));
            }
            case 520: {
                String string = this.getStringValue();
                int n4 = string.indexOf(84);
                return new TimeValue(string.substring(n4 + 1));
            }
            case 523: {
                return this.convert(521, xPathContext).convert(523, xPathContext);
            }
            case 522: {
                return this.convert(521, xPathContext).convert(522, xPathContext);
            }
            case 526: {
                return this.convert(521, xPathContext).convert(526, xPathContext);
            }
            case 524: {
                return this.convert(521, xPathContext).convert(524, xPathContext);
            }
            case 525: {
                return this.convert(521, xPathContext).convert(525, xPathContext);
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        DynamicError dynamicError = new DynamicError("Cannot convert dateTime to " + StandardNames.getDisplayName(n));
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public String getStringValue() {
        StringBuffer stringBuffer = new StringBuffer(30);
        int n = this.calendar.get(0);
        int n2 = this.calendar.get(1);
        if (n == 0) {
            stringBuffer.append('-');
        }
        if (n2 < 0) {
            stringBuffer.append('-');
            n2 = -n2;
        }
        DateTimeValue.appendString(stringBuffer, n2, n2 > 9999 ? (this.calendar.get(1) + "").length() : 4);
        stringBuffer.append('-');
        DateTimeValue.appendString(stringBuffer, this.calendar.get(2) + 1, 2);
        stringBuffer.append('-');
        DateTimeValue.appendString(stringBuffer, this.calendar.get(5), 2);
        stringBuffer.append('T');
        DateTimeValue.appendString(stringBuffer, this.calendar.get(11), 2);
        stringBuffer.append(':');
        DateTimeValue.appendString(stringBuffer, this.calendar.get(12), 2);
        stringBuffer.append(':');
        DateTimeValue.appendSeconds(this.calendar, stringBuffer);
        if (this.zoneSpecified) {
            DateTimeValue.appendTimezone(this.calendar, stringBuffer);
        }
        return stringBuffer.toString();
    }

    static void appendString(StringBuffer stringBuffer, int n, int n2) {
        String string = "000" + n;
        stringBuffer.append(string.substring(string.length() - n2));
    }

    static void appendSeconds(Calendar calendar, StringBuffer stringBuffer) {
        DateTimeValue.appendString(stringBuffer, calendar.get(13), 2);
        int n = calendar.get(14);
        if (n != 0) {
            stringBuffer.append('.');
            String string = calendar.get(14) + "";
            while (string.length() < 3) {
                string = "0" + string;
            }
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            stringBuffer.append(string);
        }
    }

    public static void appendTimezone(Calendar calendar, StringBuffer stringBuffer) {
        int n = (calendar.get(15) + calendar.get(16)) / 60000;
        DateTimeValue.appendTimezone(n, stringBuffer);
    }

    static void appendTimezone(int n, StringBuffer stringBuffer) {
        if (n == 0) {
            stringBuffer.append('Z');
        } else {
            stringBuffer.append(n < 0 ? "-" : "+");
            int n2 = n;
            if (n2 < 0) {
                n2 = -n2;
            }
            int n3 = n2 / 60;
            DateTimeValue.appendString(stringBuffer, n3, 2);
            stringBuffer.append(':');
            int n4 = n2 % 60;
            DateTimeValue.appendString(stringBuffer, n4, 2);
        }
    }

    public ItemType getItemType() {
        return Type.DATE_TIME_TYPE;
    }

    public CalendarValue removeTimezone() {
        return new DateTimeValue(this.calendar, false);
    }

    public CalendarValue setTimezone(SecondsDurationValue secondsDurationValue) throws XPathException {
        if (this.zoneSpecified) {
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone((int)(secondsDurationValue.getLengthInSeconds() * 1000.0), "xxz");
            GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
            gregorianCalendar.setTime(this.getUTCDate());
            return new DateTimeValue(gregorianCalendar, true);
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.getStringValue());
        DateTimeValue.appendTimezone((int)(secondsDurationValue.getLengthInSeconds() / 60.0), stringBuffer);
        return new DateTimeValue(stringBuffer);
    }

    public CalendarValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            double d = durationValue.getLengthInSeconds();
            GregorianCalendar gregorianCalendar = (GregorianCalendar)this.calendar.clone();
            gregorianCalendar.add(13, (int)d);
            gregorianCalendar.add(14, (int)(d % 1.0 * 1000.0));
            return new DateTimeValue(gregorianCalendar, this.zoneSpecified);
        }
        if (durationValue instanceof MonthDurationValue) {
            int n = ((MonthDurationValue)durationValue).getLengthInMonths();
            GregorianCalendar gregorianCalendar = (GregorianCalendar)this.calendar.clone();
            gregorianCalendar.add(2, n);
            return new DateTimeValue(gregorianCalendar, this.zoneSpecified);
        }
        DynamicError dynamicError = new DynamicError("DateTime arithmetic is not supported on xs:duration, only on its subtypes");
        dynamicError.setIsTypeError(true);
        throw dynamicError;
    }

    public SecondsDurationValue subtract(CalendarValue calendarValue) throws XPathException {
        if (!(calendarValue instanceof DateTimeValue)) {
            DynamicError dynamicError = new DynamicError("First operand of '-' is a dateTime, but the second is not");
            dynamicError.setIsTypeError(true);
            throw dynamicError;
        }
        return super.subtract(calendarValue);
    }

    public Object convertToJava(Class clazz, Configuration configuration, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = DateTimeValue.class$("java.util.Date")) : class$java$util$Date)) {
            return this.getUTCDate();
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateTimeValue == null ? (class$net$sf$saxon$value$DateTimeValue = DateTimeValue.class$("net.sf.saxon.value.DateTimeValue")) : class$net$sf$saxon$value$DateTimeValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DateTimeValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DateTimeValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DateTimeValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, configuration, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of dateTime to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 1: {
                return new IntegerValue(this.calendar.get(1));
            }
            case 2: {
                return new IntegerValue(this.calendar.get(2) + 1);
            }
            case 3: {
                return new IntegerValue(this.calendar.get(5));
            }
            case 4: {
                return new IntegerValue(this.calendar.get(11));
            }
            case 5: {
                return new IntegerValue(this.calendar.get(12));
            }
            case 6: {
                StringBuffer stringBuffer = new StringBuffer(10);
                DateTimeValue.appendSeconds(this.calendar, stringBuffer);
                return new DecimalValue(stringBuffer);
            }
            case 7: {
                if (this.zoneSpecified) {
                    int n2 = this.calendar.get(15) + this.calendar.get(16);
                    return SecondsDurationValue.fromMilliseconds(n2);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for dateTime: " + n);
    }

    public int compareTo(Object object) {
        if (!(object instanceof DateTimeValue)) {
            throw new ClassCastException("DateTime values are not comparable to " + object.getClass());
        }
        DateTimeValue dateTimeValue = this;
        DateTimeValue dateTimeValue2 = (DateTimeValue)object;
        if (dateTimeValue.zoneSpecified == dateTimeValue2.zoneSpecified) {
            return this.getUTCDate().compareTo(((DateTimeValue)object).getUTCDate());
        }
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            int n = (gregorianCalendar.get(15) + gregorianCalendar.get(16)) / 1000;
            SecondsDurationValue secondsDurationValue = SecondsDurationValue.fromSeconds(n);
            if (!dateTimeValue.zoneSpecified) {
                dateTimeValue = (DateTimeValue)dateTimeValue.setTimezone(secondsDurationValue);
            }
            if (!dateTimeValue2.zoneSpecified) {
                dateTimeValue2 = (DateTimeValue)dateTimeValue2.setTimezone(secondsDurationValue);
            }
            return dateTimeValue.getUTCDate().compareTo(dateTimeValue2.getUTCDate());
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)"Java timezone is out of range");
        }
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        if (this.zoneSpecified) {
            return this.getUTCDate().hashCode();
        }
        try {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            int n = (gregorianCalendar.get(15) + gregorianCalendar.get(16)) / 60000;
            SecondsDurationValue secondsDurationValue = SecondsDurationValue.fromSeconds(n);
            DateTimeValue dateTimeValue = (DateTimeValue)this.setTimezone(secondsDurationValue);
            return dateTimeValue.getUTCDate().hashCode();
        }
        catch (XPathException xPathException) {
            throw new AssertionError((Object)"Java timezone is out of range");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

