/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class HexBinaryValue
extends AtomicValue {
    private byte[] binaryValue;
    static /* synthetic */ Class class$net$sf$saxon$value$HexBinaryValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Object;

    public HexBinaryValue(CharSequence charSequence) throws XPathException {
        if ((charSequence.length() & 1) != 0) {
            DynamicError dynamicError = new DynamicError("A hexBinary value must contain an even number of characters");
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
        this.binaryValue = new byte[charSequence.length() / 2];
        int n = 0;
        while (n < this.binaryValue.length) {
            this.binaryValue[n] = (byte)((this.fromHex(charSequence.charAt(2 * n)) << 4) + this.fromHex(charSequence.charAt(2 * n + 1)));
            ++n;
        }
    }

    public HexBinaryValue(byte[] byArray) {
        this.binaryValue = byArray;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    private int fromHex(char c) throws XPathException {
        int n = "0123456789ABCDEFabcdef".indexOf(c);
        if (n > 15) {
            n -= 6;
        }
        if (n < 0) {
            DynamicError dynamicError = new DynamicError("Invalid hexadecimal digit");
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
        return n;
    }

    public AtomicValue convert(int n, XPathContext xPathContext) throws XPathException {
        switch (n) {
            case 88: 
            case 527: 
            case 643: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValue());
            }
            case 528: {
                return new Base64BinaryValue(this.binaryValue);
            }
        }
        DynamicError dynamicError = new DynamicError("Cannot convert hexBinarry to " + StandardNames.getDisplayName(n));
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public String getStringValue() {
        String string = "0123456789ABCDEF";
        StringBuffer stringBuffer = new StringBuffer(this.binaryValue.length * 2);
        int n = 0;
        while (n < this.binaryValue.length) {
            stringBuffer.append(string.charAt(this.binaryValue[n] >> 4 & 0xF));
            stringBuffer.append(string.charAt(this.binaryValue[n] & 0xF));
            ++n;
        }
        return stringBuffer.toString();
    }

    public ItemType getItemType() {
        return Type.HEX_BINARY_TYPE;
    }

    public int getLengthInOctets() {
        return this.binaryValue.length;
    }

    public Object convertToJava(Class clazz, Configuration configuration, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$HexBinaryValue == null ? (class$net$sf$saxon$value$HexBinaryValue = HexBinaryValue.class$("net.sf.saxon.value.HexBinaryValue")) : class$net$sf$saxon$value$HexBinaryValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = HexBinaryValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = HexBinaryValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = HexBinaryValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, configuration, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of hexBinary to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public boolean equals(Object object) {
        HexBinaryValue hexBinaryValue;
        if (object instanceof HexBinaryValue) {
            hexBinaryValue = (HexBinaryValue)object;
        } else if (object instanceof AtomicValue) {
            try {
                hexBinaryValue = (HexBinaryValue)((AtomicValue)object).convert(527, null);
            }
            catch (XPathException xPathException) {
                return false;
            }
        } else {
            return false;
        }
        if (this.binaryValue.length != hexBinaryValue.binaryValue.length) {
            return false;
        }
        int n = 0;
        while (n < this.binaryValue.length) {
            if (this.binaryValue[n] != hexBinaryValue.binaryValue[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return Base64BinaryValue.byteArrayHashCode(this.binaryValue);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

