/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NFRuleSet;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RBNFPostProcessor;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Locale;

public class RuleBasedNumberFormat
extends NumberFormat {
    private static final String copyrightNotice = "Copyright \u00a91997-2004 IBM Corp.  All rights reserved.";
    public static final int SPELLOUT = 1;
    public static final int ORDINAL = 2;
    public static final int DURATION = 3;
    private NFRuleSet[] ruleSets = null;
    private NFRuleSet defaultRuleSet = null;
    private Locale locale = null;
    private Collator collator = null;
    private DecimalFormatSymbols decimalFormatSymbols = null;
    private boolean lenientParse = false;
    private String lenientParseRules;
    private String postProcessRules;
    private RBNFPostProcessor postProcessor;

    public RuleBasedNumberFormat(String description) {
        this.locale = Locale.getDefault();
        this.init(description);
    }

    public RuleBasedNumberFormat(String description, Locale locale) {
        this.locale = locale;
        this.init(description);
    }

    public RuleBasedNumberFormat(Locale locale, int format) {
        this.locale = locale;
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance(new ULocale(locale));
        ULocale uloc = bundle.getULocale();
        this.setLocale(uloc, uloc);
        String description = "";
        switch (format) {
            case 1: {
                description = bundle.getString("SpelloutRules");
                break;
            }
            case 2: {
                description = bundle.getString("OrdinalRules");
                break;
            }
            case 3: {
                description = bundle.getString("DurationRules");
            }
        }
        this.init(description);
    }

    public RuleBasedNumberFormat(int format) {
        this(Locale.getDefault(), format);
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object that) {
        if (!(that instanceof RuleBasedNumberFormat)) {
            return false;
        }
        RuleBasedNumberFormat that2 = (RuleBasedNumberFormat)that;
        if (!this.locale.equals(that2.locale) || this.lenientParse != that2.lenientParse) {
            return false;
        }
        if (this.ruleSets.length != that2.ruleSets.length) {
            return false;
        }
        for (int i = 0; i < this.ruleSets.length; ++i) {
            if (this.ruleSets[i].equals(that2.ruleSets[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.ruleSets.length; ++i) {
            result.append(this.ruleSets[i].toString());
        }
        return result.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        String description = in.readUTF();
        RuleBasedNumberFormat temp = new RuleBasedNumberFormat(description);
        this.ruleSets = temp.ruleSets;
        this.defaultRuleSet = temp.defaultRuleSet;
    }

    public String[] getRuleSetNames() {
        int count = 0;
        for (int i = 0; i < this.ruleSets.length; ++i) {
            if (this.ruleSets[i].getName().startsWith("%%")) continue;
            ++count;
        }
        String[] result = new String[count];
        count = 0;
        for (int i = this.ruleSets.length - 1; i >= 0; --i) {
            if (this.ruleSets[i].getName().startsWith("%%")) continue;
            result[count++] = this.ruleSets[i].getName();
        }
        return result;
    }

    public String format(double number, String ruleSet) throws IllegalArgumentException {
        if (ruleSet.startsWith("%%")) {
            throw new IllegalArgumentException("Can't use internal rule set");
        }
        return this.format(number, this.findRuleSet(ruleSet));
    }

    public String format(long number, String ruleSet) throws IllegalArgumentException {
        if (ruleSet.startsWith("%%")) {
            throw new IllegalArgumentException("Can't use internal rule set");
        }
        return this.format(number, this.findRuleSet(ruleSet));
    }

    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition ignore) {
        toAppendTo.append(this.format(number, this.defaultRuleSet));
        return toAppendTo;
    }

    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition ignore) {
        toAppendTo.append(this.format(number, this.defaultRuleSet));
        return toAppendTo;
    }

    public StringBuffer format(BigInteger number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(new com.ibm.icu.math.BigDecimal(number), toAppendTo, pos);
    }

    public StringBuffer format(BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(new com.ibm.icu.math.BigDecimal(number), toAppendTo, pos);
    }

    public StringBuffer format(com.ibm.icu.math.BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(number.doubleValue(), toAppendTo, pos);
    }

    public Number parse(String text, ParsePosition parsePosition) {
        String workingText = text.substring(parsePosition.getIndex());
        ParsePosition workingPos = new ParsePosition(0);
        Number tempResult = null;
        Number result = new Long(0L);
        ParsePosition highWaterMark = new ParsePosition(workingPos.getIndex());
        for (int i = this.ruleSets.length - 1; i >= 0; --i) {
            if (this.ruleSets[i].getName().startsWith("%%")) continue;
            tempResult = this.ruleSets[i].parse(workingText, workingPos, Double.MAX_VALUE);
            if (workingPos.getIndex() > highWaterMark.getIndex()) {
                result = tempResult;
                highWaterMark.setIndex(workingPos.getIndex());
            }
            if (highWaterMark.getIndex() == workingText.length()) break;
            workingPos.setIndex(0);
        }
        parsePosition.setIndex(parsePosition.getIndex() + highWaterMark.getIndex());
        return result;
    }

    public void setLenientParseMode(boolean enabled) {
        this.lenientParse = enabled;
        if (!enabled) {
            this.collator = null;
        }
    }

    public boolean lenientParseEnabled() {
        return this.lenientParse;
    }

    public void setDefaultRuleSet(String ruleSetName) {
        if (ruleSetName == null) {
            this.initDefaultRuleSet();
        } else {
            if (ruleSetName.startsWith("%%")) {
                throw new IllegalArgumentException("cannot use private rule set: " + ruleSetName);
            }
            this.defaultRuleSet = this.findRuleSet(ruleSetName);
        }
    }

    public String getDefaultRuleSetName() {
        if (this.defaultRuleSet != null && this.defaultRuleSet.isPublic()) {
            return this.defaultRuleSet.getName();
        }
        return "";
    }

    NFRuleSet getDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    Collator getCollator() {
        if (this.collator == null && this.lenientParse) {
            try {
                RuleBasedCollator temp = (RuleBasedCollator)Collator.getInstance(this.locale);
                String rules = temp.getRules() + this.lenientParseRules;
                this.collator = new RuleBasedCollator(rules);
                this.collator.setDecomposition(17);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.collator = null;
            }
        }
        return this.collator;
    }

    DecimalFormatSymbols getDecimalFormatSymbols() {
        if (this.decimalFormatSymbols == null) {
            this.decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
        }
        return this.decimalFormatSymbols;
    }

    private String extractSpecial(StringBuffer description, String specialName) {
        String result = null;
        int lp = description.indexOf(specialName);
        if (lp != -1 && (lp == 0 || description.charAt(lp - 1) == ';')) {
            int lpStart;
            int lpEnd = description.indexOf(";%", lp);
            if (lpEnd == -1) {
                lpEnd = description.length() - 1;
            }
            for (lpStart = lp + specialName.length(); lpStart < lpEnd && UCharacterProperty.isRuleWhiteSpace(description.charAt(lpStart)); ++lpStart) {
            }
            result = description.substring(lpStart, lpEnd);
            description.delete(lp, lpEnd + 1);
        }
        return result;
    }

    private void init(String description) {
        StringBuffer descBuf = this.stripWhitespace(description);
        this.lenientParseRules = this.extractSpecial(descBuf, "%%lenient-parse:");
        this.postProcessRules = this.extractSpecial(descBuf, "%%post-process:");
        int numRuleSets = 0;
        int p = descBuf.indexOf(";%");
        while (p != -1) {
            ++numRuleSets;
            ++p;
            p = descBuf.indexOf(";%", p);
        }
        this.ruleSets = new NFRuleSet[++numRuleSets];
        String[] ruleSetDescriptions = new String[numRuleSets];
        int curRuleSet = 0;
        int start = 0;
        int p2 = descBuf.indexOf(";%");
        while (p2 != -1) {
            ruleSetDescriptions[curRuleSet] = descBuf.substring(start, p2 + 1);
            this.ruleSets[curRuleSet] = new NFRuleSet(ruleSetDescriptions, curRuleSet);
            ++curRuleSet;
            start = p2 + 1;
            p2 = descBuf.indexOf(";%", start);
        }
        ruleSetDescriptions[curRuleSet] = descBuf.substring(start);
        this.ruleSets[curRuleSet] = new NFRuleSet(ruleSetDescriptions, curRuleSet);
        this.initDefaultRuleSet();
        for (int i = 0; i < this.ruleSets.length; ++i) {
            this.ruleSets[i].parseRules(ruleSetDescriptions[i], this);
            ruleSetDescriptions[i] = null;
        }
    }

    private StringBuffer stripWhitespace(String description) {
        StringBuffer result = new StringBuffer();
        int start = 0;
        while (start != -1 && start < description.length()) {
            while (start < description.length() && UCharacterProperty.isRuleWhiteSpace(description.charAt(start))) {
                ++start;
            }
            if (start < description.length() && description.charAt(start) == ';') {
                ++start;
                continue;
            }
            int p = description.indexOf(59, start);
            if (p == -1) {
                result.append(description.substring(start));
                start = -1;
                continue;
            }
            if (p < description.length()) {
                result.append(description.substring(start, p + 1));
                start = p + 1;
                continue;
            }
            start = -1;
        }
        return result;
    }

    private void initDefaultRuleSet() {
        for (int i = this.ruleSets.length - 1; i >= 0; --i) {
            if (this.ruleSets[i].getName().startsWith("%%")) continue;
            this.defaultRuleSet = this.ruleSets[i];
            return;
        }
        this.defaultRuleSet = this.ruleSets[this.ruleSets.length - 1];
    }

    private String format(double number, NFRuleSet ruleSet) {
        StringBuffer result = new StringBuffer();
        ruleSet.format(number, result, 0);
        this.postProcess(result, ruleSet);
        return result.toString();
    }

    private String format(long number, NFRuleSet ruleSet) {
        StringBuffer result = new StringBuffer();
        ruleSet.format(number, result, 0);
        this.postProcess(result, ruleSet);
        return result.toString();
    }

    private void postProcess(StringBuffer result, NFRuleSet ruleSet) {
        if (this.postProcessRules != null) {
            if (this.postProcessor == null) {
                int ix = this.postProcessRules.indexOf(";");
                if (ix == -1) {
                    ix = this.postProcessRules.length();
                }
                String ppClassName = this.postProcessRules.substring(0, ix).trim();
                try {
                    Class<?> cls = Class.forName(ppClassName);
                    this.postProcessor = (RBNFPostProcessor)cls.newInstance();
                    this.postProcessor.init(this, this.postProcessRules);
                }
                catch (Exception e) {
                    System.out.println("could not locate " + ppClassName + ", error " + e.getClass().getName() + ", " + e.getMessage());
                    this.postProcessor = null;
                    this.postProcessRules = null;
                    return;
                }
            }
            this.postProcessor.process(result, ruleSet);
        }
    }

    NFRuleSet findRuleSet(String name) throws IllegalArgumentException {
        for (int i = 0; i < this.ruleSets.length; ++i) {
            if (!this.ruleSets[i].getName().equals(name)) continue;
            return this.ruleSets[i];
        }
        throw new IllegalArgumentException("No rule set named " + name);
    }
}

