/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class Comment
extends SimpleNodeConstructor {
    public int getInstructionNameCode() {
        return 138;
    }

    public ItemType getItemType() {
        return NodeKindTest.COMMENT;
    }

    public int getCardinality() {
        return 512;
    }

    public void typeCheck(StaticContext staticContext, ItemType itemType) {
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        String string = this.expandChildren(xPathContext).toString();
        string = this.checkContent(string, xPathContext);
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        sequenceReceiver.comment(string, this.locationId, 0);
        return null;
    }

    protected String checkContent(String string, XPathContext xPathContext) throws DynamicError {
        int n;
        while ((n = string.indexOf("--")) >= 0) {
            DynamicError dynamicError = new DynamicError("Invalid characters (--) in comment", this);
            dynamicError.setErrorCode("XT0950");
            dynamicError.setXPathContext(xPathContext);
            xPathContext.getController().recoverableError(dynamicError);
            string = string.substring(0, n + 1) + ' ' + string.substring(n + 1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '-') {
            DynamicError dynamicError = new DynamicError("Invalid character (-) at end of comment", this);
            dynamicError.setErrorCode("XT0950");
            dynamicError.setXPathContext(xPathContext);
            xPathContext.getController().recoverableError(dynamicError);
            string = string + ' ';
        }
        return string;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "comment");
        super.display(n + 1, namePool, printStream);
    }
}

