/*
 * Decompiled with CFR 0.152.
 */
package com.isogen.i18nsupport;

import com.isogen.i18nsupport.I18nServiceError;
import com.isogen.i18nsupport.I18nUtilError;
import com.isogen.i18nsupport.MissingLocaleException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.HashMap;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class I18nUtil {
    static String langAttName = "language";
    private static HashMap hexMap;
    private static char[] hexCharsLC;
    private static char[] hexCharsUC;

    static {
        hexCharsLC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        hexCharsUC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (System.getProperty("com.isogen.i18n.langAttName") != null) {
            langAttName = System.getProperty("com.isogen.i18n.langAttName");
        }
        hexMap = new HashMap();
        int index = 0;
        while (index < hexCharsLC.length) {
            hexMap.put(new Character(hexCharsLC[index]), new Integer(index));
            if (hexCharsLC[index] != hexCharsUC[index]) {
                hexMap.put(new Character(hexCharsUC[index]), new Integer(index));
            }
            ++index;
        }
    }

    public static String stripAngleBrackets(String toStrip) {
        return toStrip.substring(1, toStrip.length() - 1);
    }

    public static byte[] hexToBytes(String hexString) {
        byte[] result = new byte[hexString.length() / 2];
        char[] chars = hexString.toCharArray();
        int byteIndex = 0;
        int i = 0;
        while (i < chars.length) {
            int firstHalf = I18nUtil.getIntForHexChar(chars[i]);
            int secondHalf = I18nUtil.getIntForHexChar(chars[i + 1]);
            result[byteIndex++] = (byte)(firstHalf << 4 | secondHalf);
            i += 2;
        }
        return result;
    }

    public static String echoStartTag(Element elem) {
        String resultStr = "<" + elem.getTagName();
        String attstr = "";
        NamedNodeMap atts = elem.getAttributes();
        int j = 0;
        while (j < atts.getLength()) {
            Attr att = (Attr)atts.item(j);
            attstr = String.valueOf(attstr) + " " + att.getNodeName() + "=\"" + att.getNodeValue() + "\"";
            ++j;
        }
        resultStr = String.valueOf(resultStr) + attstr + ">";
        return resultStr;
    }

    public static String echoEndTag(Element elem) {
        return "</" + elem.getTagName() + ">";
    }

    public static Element getAttHolder(Element startNode, String attName) throws I18nServiceError {
        Node attHolderNode = startNode;
        while (attHolderNode.getNodeType() != 9 && !attHolderNode.hasAttribute(attName)) {
            attHolderNode = attHolderNode.getParentNode();
        }
        if (attHolderNode.getNodeType() == 9) {
            return null;
        }
        return attHolderNode;
    }

    public static Element getFirstElementChild(Element elemNode) {
        NodeList nl = elemNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node cand = nl.item(i);
            if (cand.getNodeType() == 1) {
                return (Element)cand;
            }
            ++i;
        }
        return null;
    }

    public static boolean hasElementChildren(Element elemNode) {
        NodeList nl = elemNode.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node cand = nl.item(i);
            if (cand.getNodeType() == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getElementContent(Element elem) {
        String resultStr = "";
        if (elem != null) {
            NodeList childs = elem.getChildNodes();
            int i = 0;
            while (i < childs.getLength()) {
                Node child = childs.item(i);
                if (child.getNodeType() == 1) {
                    resultStr = String.valueOf(resultStr) + I18nUtil.echoStartTag((Element)child);
                    resultStr = String.valueOf(resultStr) + I18nUtil.getElementContent((Element)child);
                    resultStr = String.valueOf(resultStr) + I18nUtil.echoEndTag((Element)child);
                } else if (child.getNodeType() == 3) {
                    resultStr = String.valueOf(resultStr) + ((Text)child).getData();
                }
                ++i;
            }
        }
        return resultStr;
    }

    public static String getElementContentNormalized(Element elem) {
        String contStr = I18nUtil.getElementContent(elem);
        String resultStr = contStr.trim().replace('\n', ' ');
        resultStr = contStr.trim().replace('\r', ' ');
        return resultStr;
    }

    public static String getElementLanguage(Element elemNode, String defaultLangCode) {
        String langCode = defaultLangCode;
        if (elemNode.hasAttribute(langAttName)) {
            langCode = elemNode.getAttribute(langAttName);
        } else if (elemNode.hasAttributeNS("xml", "lang")) {
            langCode = elemNode.getAttributeNS("xml", "lang");
        }
        return langCode;
    }

    public static Element getElement(Element parentElem, String tagName) throws I18nUtilError {
        NodeList nl = parentElem.getElementsByTagName(tagName);
        if (nl.getLength() == 0) {
            throw new I18nUtilError("No " + tagName + " element found");
        }
        if (nl.getLength() > 1) {
            throw new I18nUtilError("Found more than one " + tagName + " elements");
        }
        Element result = (Element)nl.item(0);
        return result;
    }

    public static Locale getLocaleFromLangCode(String langCode) throws MissingLocaleException {
        String lang = null;
        String country = null;
        int p = langCode.indexOf("-");
        if (p > 0) {
            lang = langCode.substring(0, p);
            country = langCode.substring(p + 1);
            country = country.toUpperCase();
            return new Locale(lang, country);
        }
        lang = langCode;
        country = "";
        if (lang.equals("he")) {
            lang = "iw";
        }
        Locale[] locales = Locale.getAvailableLocales();
        int i = 0;
        while (i < locales.length) {
            if (locales[i].getLanguage().equals(lang) && locales[i].getCountry().equals(country)) {
                return locales[i];
            }
            ++i;
        }
        throw new MissingLocaleException("Failed to find a built-in locale for language code '" + langCode + "'");
    }

    public static int getIntForHexChar(char hexChar) {
        return (Integer)hexMap.get(new Character(hexChar));
    }

    public static String escapeUnicodeString(String inString) {
        int l = inString.length();
        byte[] bytes = new byte[l];
        try {
            bytes = inString.getBytes("UTF16");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        String outString = "";
        byte zeroByte = new Byte("0");
        byte lastByte = new Byte("127");
        int i = 2;
        while (i < bytes.length) {
            if (bytes[i] == zeroByte && bytes[i + 1] <= lastByte) {
                try {
                    String newString = new String(bytes, i + 1, 1);
                    outString = String.valueOf(outString) + newString;
                }
                catch (Exception e) {
                    System.err.println("escapeUnicodeString(): " + e.getMessage());
                }
            } else {
                outString = String.valueOf(outString) + "\\u";
                outString = String.valueOf(outString) + I18nUtil.byteToHex(bytes[i]) + I18nUtil.byteToHex(bytes[i + 1]);
            }
            i += 2;
        }
        return outString;
    }

    public static String byteToHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public static String charToHex(char c) {
        byte hi = (byte)(c >>> 8);
        byte lo = (byte)(c & 0xFF);
        return String.valueOf(I18nUtil.byteToHex(hi)) + I18nUtil.byteToHex(lo);
    }

    public static String readUnicodeFile(URL fileUrl, String encoding) throws I18nUtilError {
        InputStream is = null;
        try {
            is = fileUrl.openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new I18nUtilError("IOException: " + e.getMessage() + " for URL '" + fileUrl.toExternalForm() + "'");
        }
        return I18nUtil.readUnicodeStream(is, encoding);
    }

    public static String readUnicodeFile(String filePath, String encoding) throws I18nUtilError {
        return I18nUtil.readUnicodeFile(new File(filePath), encoding);
    }

    public static String readUnicodeFile(File file, String encoding) throws I18nUtilError {
        FileInputStream fis;
        try {
            fis = new FileInputStream(file.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new I18nUtilError("IOException: " + e.getMessage() + " for file '" + file.getAbsolutePath() + "'");
        }
        return I18nUtil.readUnicodeStream(fis, encoding);
    }

    public static String readUnicodeStream(InputStream is, String encoding) throws I18nUtilError {
        StringBuffer buffer = new StringBuffer();
        try {
            int ch;
            InputStreamReader isr = new InputStreamReader(is, encoding);
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                buffer.append((char)ch);
            }
            ((Reader)in).close();
            return buffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new I18nUtilError("IOException: " + e.getMessage());
        }
    }

    public static void writeUnicodeFile(String outString, String filePath, String encoding) throws I18nUtilError {
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, encoding);
            out.write(outString);
            ((Writer)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new I18nUtilError("writeUnicodeFile: " + e.getMessage() + " for file '" + filePath + "'");
        }
    }

    public static void writeCollationRulesForLocale(Locale locale, String outFilePath) throws I18nUtilError {
        String sortRules = null;
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance(locale);
        sortRules = col.getRules();
        I18nUtil.writeUnicodeFile(sortRules, outFilePath, "UTF8");
    }

    public static String getLangAttName() {
        return langAttName;
    }
}

