/*
 * Decompiled with CFR 0.152.
 */
package com.isogen.indexhelper;

import com.isogen.i18nsupport.I18nUtil;
import com.isogen.indexhelper.IndexGroup;
import com.isogen.indexhelper.IndexHelperException;
import com.isogen.indexhelper.IndexRuleSet;
import java.io.File;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IndexHelper {
    public static final int SORT_ENGLISH_BEFORE = 0;
    public static final int SORT_ENGLISH_AFTER = 1;
    public static final int SORT_ENGLISH_MIXED = 2;
    Document configDom;
    File configFile;
    Hashtable indexConfigs = new Hashtable();

    public IndexHelper(String configFilename) throws IndexHelperException {
        this.configFile = new File(configFilename);
        this.loadIndexRuleSetDom(configFilename);
    }

    public IndexHelper() {
        this.configFile = null;
    }

    public void loadIndexRuleSetDoc(String configFilename) throws IndexHelperException {
        this.configFile = new File(configFilename);
        if (!this.configFile.exists()) {
            throw new IndexHelperException("loadIndexRuleSetDoc(): Cannot find index configuration file '" + this.configFile.getAbsolutePath() + "'");
        }
        this.loadIndexRuleSetDom(this.configFile.getAbsolutePath());
    }

    void loadIndexRuleSetDom(String configFilename) throws IndexHelperException {
        DOMParser dp = new DOMParser();
        try {
            dp.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dp.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            dp.parse(configFilename);
        }
        catch (Throwable e) {
            throw new IndexHelperException("Error constructing DOM from docid '" + configFilename + ": " + e.getMessage());
        }
        this.configDom = dp.getDocument();
        Element rootElem = this.configDom.getDocumentElement();
        if (rootElem == null) {
            throw new IndexHelperException("Failed to find root element of index configuration document " + configFilename);
        }
    }

    IndexRuleSet getIndexRuleSet(String langCode) throws IndexHelperException {
        if (this.indexConfigs.containsKey(langCode)) {
            return (IndexRuleSet)this.indexConfigs.get(langCode);
        }
        IndexRuleSet ic = this.loadIndexRuleSet(langCode);
        this.indexConfigs.put(langCode, ic);
        return ic;
    }

    IndexRuleSet loadIndexRuleSet(String langCode) throws IndexHelperException {
        Element rootElem = this.configDom.getDocumentElement();
        if (rootElem == null) {
            throw new IndexHelperException("Failed to find root element of index configuration document ");
        }
        NodeList tempnl = rootElem.getElementsByTagName("index_config");
        if (tempnl.getLength() == 0) {
            throw new IndexHelperException("Failed to find any 'index_config' elements");
        }
        Element indexConfigElement = null;
        int i = 0;
        while (i < tempnl.getLength()) {
            Element candIndexConfigElem = (Element)tempnl.item(i);
            NodeList nl = candIndexConfigElem.getElementsByTagName("national_language");
            if (nl.getLength() == 0) {
                throw new IndexHelperException("Missing required national_language element within index_config element");
            }
            String candLangCode = I18nUtil.getElementContent((Element)nl.item(0));
            if (candLangCode.equals("")) {
                System.err.println("WARNING: IndexRuleSet - Null value for <national_language> element in <index_config>");
            } else if (candLangCode.equals(langCode)) {
                indexConfigElement = candIndexConfigElem;
                break;
            }
            ++i;
        }
        if (indexConfigElement == null & langCode.equals("en")) {
            throw new IndexHelperException(" - Failed to find index configuration for language '" + langCode + "'");
        }
        if (indexConfigElement == null & !langCode.equals("en")) {
            System.err.println(" - Failed to find index configuration for language '" + langCode + "', trying English.");
            return this.getIndexRuleSet("en");
        }
        IndexRuleSet ic = new IndexRuleSet(this, langCode, indexConfigElement, this.configFile);
        return ic;
    }

    public Iterator getIndexGroupKeysIterator(String langCode) throws IndexHelperException {
        IndexRuleSet ic = this.getIndexRuleSet(langCode);
        return ic.getGroupKeysIterator();
    }

    public Comparator getComparator(String langCode) throws IndexHelperException {
        IndexRuleSet ic = this.getIndexRuleSet(langCode);
        Comparator co = ic.getComparator();
        return co;
    }

    public String getGroupKey(String langCode, String indexEntry) throws IndexHelperException {
        if (indexEntry.equals("")) {
            return null;
        }
        IndexRuleSet ic = this.getIndexRuleSet(langCode);
        String key = ic.getGroupKey(indexEntry);
        return key;
    }

    public String getGroupLabel(String langCode, String groupKey) throws IndexHelperException {
        IndexRuleSet ic = this.getIndexRuleSet(langCode);
        if (groupKey.equals("#NUMERIC")) {
            return groupKey;
        }
        IndexGroup ig = ic.getIndexGroup(groupKey);
        return ig.label;
    }

    public String getGroupSortKey(String langCode, String groupKey) throws IndexHelperException {
        IndexRuleSet ic = this.getIndexRuleSet(langCode);
        if (groupKey.equals("#NUMERIC")) {
            return groupKey;
        }
        IndexGroup ig = ic.getIndexGroup(groupKey);
        return ig.groupSortKey;
    }

    public int getEnglishIndexPosition(String langCode) throws IndexHelperException {
        IndexRuleSet ic = this.getIndexRuleSet(langCode);
        return ic.getEnglishIndexPosition();
    }

    public String printIndexRuleSet(String langCode, boolean includeCollationRules) throws IndexHelperException {
        IndexRuleSet ic = this.getIndexRuleSet(langCode);
        return ic.toString(includeCollationRules);
    }

    public String printIndexRuleSet(String langCode) throws IndexHelperException {
        return this.printIndexRuleSet(langCode, false);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeCollationRules) {
        String outStr = "";
        Enumeration configs = this.indexConfigs.elements();
        while (configs.hasMoreElements()) {
            IndexRuleSet ic = (IndexRuleSet)configs.nextElement();
            outStr = String.valueOf(outStr) + ic.toString(includeCollationRules);
        }
        return outStr;
    }
}

