/*
 * Decompiled with CFR 0.152.
 */
package com.isogen.saxoni18n;

import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.style.ExtensionElementFactory;
import com.isogen.i18nsupport.I18nService;
import com.isogen.i18nsupport.I18nServiceError;
import com.isogen.i18nsupport.I18nUtil;
import com.isogen.indexhelper.IndexHelper;
import com.isogen.indexhelper.IndexHelperException;
import com.isogen.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Saxoni18nService
implements ExtensionElementFactory {
    public static I18nService i18nServer;
    static final IndexHelper indexHelper;
    static String static_text_fn;
    static String index_rules_fn;
    static /* synthetic */ Class class$0;

    static {
        File staticTextFile;
        String config_path;
        File configDir;
        File propertiesDir;
        File i18nPropertiesFile;
        i18nServer = null;
        static_text_fn = "#none";
        index_rules_fn = "#none";
        String homePropertyName = "com.innodata.i18n.home";
        String i18n_home = System.getProperty(homePropertyName);
        if (i18n_home == null) {
            System.err.println("Saxoni18nService: ERROR: System property '" + homePropertyName + "' not set. Processing will fail.");
        }
        if ((i18nPropertiesFile = new File(propertiesDir = new File(configDir = new File(config_path = String.valueOf(i18n_home) + File.separator + "config" + File.separator), "properties"), "isogen_i18n.properties")).exists() && i18nPropertiesFile.canRead()) {
            Properties localProps = new Properties();
            try {
                localProps.load(i18nPropertiesFile.toURL().openStream());
                Enumeration<?> propNames = localProps.propertyNames();
                while (propNames.hasMoreElements()) {
                    String propname = (String)propNames.nextElement();
                    System.setProperty(propname, localProps.getProperty(propname));
                }
            }
            catch (Throwable e) {
                System.err.println(" - I18nService(): Warning: Failed to load properties file " + i18nPropertiesFile.getAbsolutePath());
            }
        }
        try {
            i18nServer = new I18nService();
        }
        catch (Throwable e) {
            System.err.println(" - Saxoni18nService: Failed to construct I18nService instance in class-level static processing. Results will not be good.");
            e.printStackTrace();
        }
        indexHelper = new IndexHelper();
        index_rules_fn = System.getProperty("com.innodata.i18n.indexRulesFilename");
        if (index_rules_fn == null) {
            index_rules_fn = String.valueOf(config_path) + "botb_index_rules" + File.separator + "botb_index_rules.xml";
        }
        if (!index_rules_fn.equals("#none")) {
            try {
                index_rules_fn = String.valueOf(config_path) + "botb_index_rules" + File.separator + "botb_index_rules.xml";
                URL index_rules_Url = null;
                try {
                    index_rules_Url = new File(index_rules_fn).toURL();
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                if (index_rules_Url == null) {
                    System.err.println(" - Failed to find index configuration file " + index_rules_fn);
                } else {
                    indexHelper.loadIndexRuleSetDoc(index_rules_fn);
                }
            }
            catch (IndexHelperException e) {
                String msg = " - Failed to load index rules document " + index_rules_fn + ". " + " - Make sure the com.innodata.i18n.home system variable is set correctly.";
                System.err.println(msg);
                e.printStackTrace();
            }
        }
        if ((static_text_fn = System.getProperty("com.innodata.i18n.staticTextDatabaseFilename")) == null && !(staticTextFile = new File(static_text_fn = String.valueOf(config_path) + "static_text" + File.separator + "static_text_database.xml")).exists()) {
            System.err.println(" - Warning: com.innodata.i18n.staticTextDatabaseFilename property is not set\n -          and there is no static text database in the default location\n -          (config/static_text/static_text_database.xml).\n -          Using empty static text database.");
            static_text_fn = "#none";
        }
        if (!static_text_fn.equals("#none")) {
            staticTextFile = new File(static_text_fn);
            try {
                URL staticTextUrl = staticTextFile.toURL();
                i18nServer.loadStaticTextDatabase(staticTextUrl);
            }
            catch (Throwable e) {
                String msg = " - Failed to load static text database document " + static_text_fn + "." + " - Make sure the com.innodata.i18n.home system variable is set correctly.";
                System.err.println(msg);
                e.printStackTrace();
            }
        }
    }

    public Class getExtensionClass(String localname) {
        return null;
    }

    public static String getGeneratedTextBefore(SingletonNodeSet sns, String langCode) throws XPathException {
        Node currentNode;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.w3c.dom.Node");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((currentNode = (Node)sns.convertToJava((Class)clazz)).getNodeType() == 1) {
            try {
                return i18nServer.getGeneratedTextBefore((Element)currentNode, langCode);
            }
            catch (I18nServiceError exc) {
                return "";
            }
        }
        return "";
    }

    public static String getGeneratedTextForKeyBefore(String key, String langCode) throws XPathException {
        try {
            return i18nServer.getGeneratedTextForKeyBefore(key, langCode);
        }
        catch (I18nServiceError exc) {
            return "";
        }
    }

    public static String getGeneratedTextForKeyAfter(String key, String langCode) throws XPathException {
        try {
            return i18nServer.getGeneratedTextForKeyAfter(key, langCode);
        }
        catch (I18nServiceError exc) {
            return "";
        }
    }

    public static String getParaGeneratedTextBefore(SingletonNodeSet sns) throws XPathException {
        Node currentNode;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.w3c.dom.Node");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((currentNode = (Node)sns.convertToJava((Class)clazz)).getNodeType() == 1) {
            try {
                return i18nServer.getParaGeneratedTextBefore((Element)currentNode);
            }
            catch (I18nServiceError exc) {
                return "";
            }
        }
        return "";
    }

    public static String getGeneratedTextAfter(SingletonNodeSet sns) throws XPathException {
        Node currentNode;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.w3c.dom.Node");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((currentNode = (Node)sns.convertToJava((Class)clazz)).getNodeType() == 1) {
            try {
                return i18nServer.getGeneratedTextAfter((Element)currentNode);
            }
            catch (I18nServiceError exc) {
                return "";
            }
        }
        return "";
    }

    public static String getParaGeneratedTextAfter(SingletonNodeSet sns) throws XPathException {
        Node currentNode;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.w3c.dom.Node");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((currentNode = (Node)sns.convertToJava((Class)clazz)).getNodeType() == 1) {
            try {
                return i18nServer.getParaGeneratedTextAfter((Element)currentNode);
            }
            catch (I18nServiceError exc) {
                return "";
            }
        }
        return "";
    }

    public static String getAttributeTranslation(SingletonNodeSet sns, String attname) throws XPathException {
        Node currentNode;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.w3c.dom.Node");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((currentNode = (Node)sns.convertToJava((Class)clazz)).getNodeType() == 1) {
            try {
                return i18nServer.getTranslatedAttValue((Element)currentNode, attname);
            }
            catch (I18nServiceError exc) {
                return "";
            }
        }
        return "";
    }

    public static String getIndexGroupKey(String langCode, String indexEntry) throws XPathException {
        String result;
        block3: {
            try {
                result = indexHelper.getGroupKey(langCode, indexEntry);
                if (result != null) break block3;
                System.err.println(" - Warning: empty index entry passed to getIndexGroupKey() extension function.");
                System.err.println(" -          Using key '#NUMERIC'.");
                return "#NUMERIC";
            }
            catch (IndexHelperException e) {
                e.printStackTrace();
                throw new XPathException("IndexHelperException: " + e.getMessage());
            }
        }
        return result;
    }

    public static String getIndexGroupSortKey(String langCode, String groupKey) throws XPathException {
        try {
            return indexHelper.getGroupSortKey(langCode, groupKey);
        }
        catch (IndexHelperException e) {
            throw new XPathException(e.getMessage());
        }
    }

    public static String getIndexGroupLabel(String langCode, String groupKey) throws XPathException {
        if (groupKey == null) {
            groupKey = "";
        }
        try {
            return indexHelper.getGroupLabel(langCode, groupKey);
        }
        catch (IndexHelperException e) {
            throw new XPathException(e.getMessage());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new XPathException("NullPointerException: " + e.getMessage());
        }
    }

    public static String printStaticTextDatabase() throws XPathException {
        try {
            return i18nServer.printStaticTextDatabase();
        }
        catch (I18nServiceError e) {
            throw new XPathException(e.getMessage());
        }
    }

    public static String printIndexConfiguration(String langCode, boolean includeCollationRules) throws XPathException {
        try {
            return indexHelper.printIndexRuleSet(langCode, includeCollationRules);
        }
        catch (IndexHelperException e) {
            e.printStackTrace();
            throw new XPathException(e.getMessage());
        }
    }

    public static String printIndexConfiguration(String langCode) throws XPathException {
        return Saxoni18nService.printIndexConfiguration(langCode, false);
    }

    public static String getFileDir(String filePath) {
        return FileUtil.getFileDir(filePath);
    }

    public static String getUrlPart(String inUrl, String partName) throws XPathException {
        URL url;
        try {
            url = new URL(inUrl);
        }
        catch (MalformedURLException e) {
            try {
                url = new URL("http://" + inUrl);
            }
            catch (MalformedURLException e2) {
                throw new XPathException("getUrlPart: Malformed URL: " + e2.getMessage());
            }
        }
        if (partName.toLowerCase().equals("protocol")) {
            return url.getProtocol();
        }
        if (partName.toLowerCase().equals("host")) {
            return url.getHost();
        }
        if (partName.toLowerCase().equals("path")) {
            return url.getPath();
        }
        if (partName.toLowerCase().equals("file")) {
            return url.getFile();
        }
        throw new XPathException("getUrlPart: unrecognized part name '" + partName + "'");
    }

    public static boolean urlHasProtocol(String inUrl) throws XPathException {
        try {
            URL url = new URL(inUrl);
            return true;
        }
        catch (MalformedURLException e) {
            try {
                URL url = new URL("http://" + inUrl);
                return false;
            }
            catch (MalformedURLException e2) {
                throw new XPathException("getUrlPart: Malformed URL: " + e2.getMessage());
            }
        }
    }

    public static String escapeUnicodeString(String inStr) throws XPathException {
        return I18nUtil.escapeUnicodeString(inStr);
    }

    public static String constructTargetRelativePath(String origPathStr, String targetBasePathStr) throws XPathException {
        String newPath = "";
        File origPath = new File(origPathStr);
        File targetBasePath = new File(targetBasePathStr);
        StringTokenizer origTokenizer = null;
        StringTokenizer targetTokenizer = null;
        try {
            origTokenizer = new StringTokenizer(origPath.getCanonicalPath().toString(), File.separator);
            targetTokenizer = new StringTokenizer(targetBasePath.getCanonicalPath().toString(), File.separator);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (origTokenizer.hasMoreTokens()) {
            String targToken;
            String origToken = (String)origTokenizer.nextElement();
            if (!origToken.equals(targToken = (String)origTokenizer.nextElement())) break;
        }
        return newPath;
    }

    public static String getFilename(String inPath) throws XPathException {
        return FileUtil.getFileName(inPath);
    }

    public static String getBaseName(String inPath) throws XPathException {
        return FileUtil.getFileBaseName(inPath);
    }

    public static String getTimeStamp() {
        String result = "";
        Date date = new Date();
        result = DateFormat.getDateInstance().format(date);
        result = String.valueOf(result) + " " + DateFormat.getTimeInstance().format(date);
        return result;
    }

    public static String getRelativePath(String filePath, String targetPath) {
        return FileUtil.getRelativePath(filePath, targetPath);
    }

    public static String getAbsolutePath(String basePath, String relativePath) {
        return FileUtil.getAbsolutePath(basePath, relativePath);
    }

    public static void main(String[] args) {
        System.err.println("This class cannot be run from the command line");
    }

    public static Comparator getComparatorForLanguageCode(String langCode) {
        try {
            return i18nServer.getComparatorForLanguageCode(langCode);
        }
        catch (Exception e) {
            System.err.println(" - SaxonI18nService.getComparatorForLanguageCode(): " + e.getClass().getName() + " exception getting comparator for language code '" + langCode + "'. Using default Java Collator.");
            e.printStackTrace();
            Collator col = Collator.getInstance();
            return col;
        }
    }

    public static String getVersionAndRelease() {
        return I18nService.getVersionAndRelease();
    }

    public static String getStaticTextDatabaseFileName() {
        return static_text_fn;
    }

    public static String getIndexRulesFileName() {
        return index_rules_fn;
    }
}

