/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class Copy
extends ElementCreator {
    private boolean copyNamespaces;
    private ItemType contextItemType;

    public Copy(AttributeSet[] attributeSetArray, boolean bl, boolean bl2, SchemaType schemaType, int n) {
        this.useAttributeSets = attributeSetArray;
        this.copyNamespaces = bl;
        this.inheritNamespaces = bl2;
        this.schemaType = schemaType;
        this.validation = n;
    }

    public int getInstructionNameCode() {
        return 139;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.contextItemType = itemType;
        return super.analyze(staticContext, itemType);
    }

    public ItemType getItemType() {
        if (this.contextItemType == null) {
            return AnyItemType.getInstance();
        }
        return this.contextItemType;
    }

    protected int getNameCode(XPathContext xPathContext) throws XPathException {
        return ((NodeInfo)xPathContext.getContextItem()).getNameCode();
    }

    protected void outputNamespaceNodes(XPathContext xPathContext, Receiver receiver) throws XPathException {
        if (this.copyNamespaces) {
            NodeInfo nodeInfo = (NodeInfo)xPathContext.getContextItem();
            nodeInfo.outputNamespaceNodes(receiver, true);
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        SequenceReceiver sequenceReceiver = xPathContextMinor.getReceiver();
        Item item = xPathContext.getContextItem();
        if (!(item instanceof NodeInfo)) {
            sequenceReceiver.append(item, this.locationId);
            return null;
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        switch (nodeInfo.getNodeKind()) {
            case 1: {
                return super.processLeavingTail(xPathContextMinor);
            }
            case 2: {
                try {
                    CopyOf.copyAttribute(nodeInfo, this.schemaType, this.validation, this.locationId, xPathContextMinor);
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    DynamicError dynamicError = new DynamicError(noOpenStartTagException.getMessage());
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setErrorCode(noOpenStartTagException.getErrorCode());
                    xPathContext.getController().recoverableError(dynamicError);
                }
                break;
            }
            case 3: {
                sequenceReceiver.characters(nodeInfo.getStringValue(), this.locationId, 0);
                break;
            }
            case 7: {
                sequenceReceiver.processingInstruction(nodeInfo.getDisplayName(), nodeInfo.getStringValue(), this.locationId, 0);
                break;
            }
            case 8: {
                sequenceReceiver.comment(nodeInfo.getStringValue(), this.locationId, 0);
                break;
            }
            case 13: {
                try {
                    nodeInfo.copy(sequenceReceiver, 0, false, this.locationId);
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    DynamicError dynamicError = new DynamicError(noOpenStartTagException.getMessage());
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setErrorCode(noOpenStartTagException.getErrorCode());
                    xPathContext.getController().recoverableError(dynamicError);
                }
                break;
            }
            case 9: {
                Receiver receiver = controller.getConfiguration().getDocumentValidator(sequenceReceiver, nodeInfo.getBaseURI(), controller.getNamePool(), this.validation);
                if (receiver != sequenceReceiver) {
                    TreeReceiver treeReceiver = new TreeReceiver(receiver);
                    treeReceiver.setConfiguration(controller.getConfiguration());
                    xPathContextMinor.setReceiver(treeReceiver);
                    receiver = treeReceiver;
                }
                receiver.setConfiguration(controller.getConfiguration());
                receiver.startDocument(0);
                this.processChildren(xPathContextMinor);
                receiver.endDocument();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node kind " + nodeInfo.getNodeKind());
            }
        }
        return null;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "copy");
    }
}

