/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class DeferredError
extends Instruction {
    private TransformerException error;

    public DeferredError(TransformerException transformerException) {
        if (transformerException == null) {
            throw new NullPointerException("Deferred Error: no error value supplied");
        }
        this.error = transformerException;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        return this;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
    }

    public Iterator iterateSubExpressions() {
        return Collections.EMPTY_LIST.iterator();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        throw XPathException.wrap(this.error);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        if (this.error instanceof XPathException) {
            throw (XPathException)this.error;
        }
        throw new DynamicError(this.error);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        this.evaluateItem(xPathContext);
        return null;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "error: " + this.error.getMessage());
    }
}

