/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class IntegerValue
extends NumericValue {
    public static final IntegerValue MINUS_ONE = new IntegerValue(-1L);
    public static final IntegerValue ZERO = new IntegerValue(0L);
    public static final IntegerValue PLUS_ONE = new IntegerValue(1L);
    public static final IntegerValue MAX_LONG = new IntegerValue(Long.MAX_VALUE);
    public static final IntegerValue MIN_LONG = new IntegerValue(Long.MIN_VALUE);
    private long value;
    private ItemType type;
    static long[] ranges = new long[]{532L, Long.MIN_VALUE, Long.MAX_VALUE, 533L, Long.MIN_VALUE, 0L, 534L, Long.MIN_VALUE, -1L, 535L, Long.MIN_VALUE, Long.MAX_VALUE, 536L, Integer.MIN_VALUE, Integer.MAX_VALUE, 537L, -32768L, 32767L, 538L, -128L, 127L, 539L, 0L, Long.MAX_VALUE, 540L, 1L, Long.MAX_VALUE, 541L, 0L, Long.MAX_VALUE, 542L, 0L, 0xFFFFFFFFL, 543L, 0L, 65535L, 544L, 0L, 255L};
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$IntegerValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public IntegerValue(long l) {
        this.value = l;
        this.type = Type.INTEGER_TYPE;
    }

    public IntegerValue(long l, ItemType itemType) throws DynamicError {
        this.value = l;
        this.type = itemType;
        IntegerValue.checkRange(this.value, itemType);
    }

    public void setSubType(ItemType itemType) throws DynamicError {
        this.type = itemType;
        IntegerValue.checkRange(this.value, itemType);
    }

    public static NumericValue stringToInteger(CharSequence charSequence) throws DynamicError {
        try {
            CharSequence charSequence2 = Value.trimWhitespace(charSequence);
            if (charSequence2.charAt(0) == '+') {
                charSequence2 = charSequence2.subSequence(1, charSequence2.length());
            }
            if (charSequence2.length() < 16) {
                return new IntegerValue(Long.parseLong(charSequence2.toString()));
            }
            return new BigIntegerValue(new BigInteger(charSequence2.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            DynamicError dynamicError = new DynamicError("Cannot convert string " + Err.wrap(charSequence, 4) + " to an integer");
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            DynamicError dynamicError = new DynamicError("Cannot convert zero-length string to an integer");
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
    }

    private static void checkRange(long l, ItemType itemType) throws DynamicError {
        int n = 0;
        while (n < ranges.length) {
            if (ranges[n] == (long)((AtomicType)itemType).getFingerprint()) {
                if (l < ranges[n + 1] || l > ranges[n + 2]) {
                    DynamicError dynamicError = new DynamicError("Value is out of range for type " + itemType.toString());
                    dynamicError.setErrorCode("FORG0001");
                    throw dynamicError;
                }
                return;
            }
            n += 3;
        }
        DynamicError dynamicError = new DynamicError("No range information for type " + itemType.toString());
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public int hashCode() {
        if (this.value > Integer.MIN_VALUE && this.value < Integer.MAX_VALUE) {
            return (int)this.value;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public long longValue() {
        return this.value;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value != 0L;
    }

    public int compareTo(Object object) {
        if (object instanceof IntegerValue) {
            long l = ((IntegerValue)object).value;
            if (this.value == l) {
                return 0;
            }
            if (this.value < l) {
                return -1;
            }
            return 1;
        }
        if (object instanceof BigIntegerValue) {
            return new BigIntegerValue(this.value).compareTo(object);
        }
        return super.compareTo(object);
    }

    public AtomicValue convert(int n, XPathContext xPathContext) throws XPathException {
        switch (n) {
            case 514: {
                return BooleanValue.get(this.value != 0L);
            }
            case 88: 
            case 532: 
            case 643: 
            case 646: {
                return this;
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: {
                return new IntegerValue(this.value, (AtomicType)BuiltInSchemaFactory.getSchemaType(n));
            }
            case 517: {
                return new DoubleValue(this.value);
            }
            case 516: {
                return new FloatValue(this.value);
            }
            case 515: {
                return new DecimalValue(this.value);
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        DynamicError dynamicError = new DynamicError("Cannot convert integer to " + StandardNames.getDisplayName(n));
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public String getStringValue() {
        return this.value + "";
    }

    public NumericValue negate() {
        return new IntegerValue(-this.value);
    }

    public NumericValue floor() {
        return this;
    }

    public NumericValue ceiling() {
        return this;
    }

    public NumericValue round() {
        return this;
    }

    public NumericValue roundToHalfEven(int n) {
        long l = Math.abs(this.value);
        if (n >= 0) {
            return this;
        }
        if (n < -15) {
            return new BigIntegerValue(this.value).roundToHalfEven(n);
        }
        long l2 = 1L;
        long l3 = 1L;
        while (l3 <= (long)(-n)) {
            l2 *= 10L;
            ++l3;
        }
        long l4 = l % l2;
        long l5 = l - l4;
        long l6 = l4 * 2L;
        if (l6 > l2) {
            l5 += l2;
        } else if (l6 >= l2 && l5 % (2L * l2) != 0L) {
            l5 += l2;
        }
        if (this.value < 0L) {
            l5 = -l5;
        }
        return new IntegerValue(l5);
    }

    public boolean isWholeNumber() {
        return true;
    }

    public NumericValue arithmetic(int n, NumericValue numericValue, XPathContext xPathContext) throws XPathException {
        if (numericValue instanceof IntegerValue) {
            if (this.value >= Integer.MAX_VALUE || this.value <= Integer.MIN_VALUE || ((IntegerValue)numericValue).value >= Integer.MAX_VALUE || ((IntegerValue)numericValue).value <= Integer.MIN_VALUE) {
                return new BigIntegerValue(this.value).arithmetic(n, numericValue, xPathContext);
            }
            switch (n) {
                case 15: {
                    return new IntegerValue(this.value + ((IntegerValue)numericValue).value);
                }
                case 16: {
                    return new IntegerValue(this.value - ((IntegerValue)numericValue).value);
                }
                case 17: {
                    return new IntegerValue(this.value * ((IntegerValue)numericValue).value);
                }
                case 50: {
                    try {
                        return new IntegerValue(this.value / ((IntegerValue)numericValue).value);
                    }
                    catch (ArithmeticException arithmeticException) {
                        DynamicError dynamicError;
                        if ("/ by zero".equals(arithmeticException.getMessage())) {
                            dynamicError = new DynamicError("Integer division by zero");
                            dynamicError.setErrorCode("FOAR0001");
                        } else {
                            dynamicError = new DynamicError("Integer division failure", arithmeticException);
                        }
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                }
                case 18: {
                    long l = ((IntegerValue)numericValue).value;
                    if (l == 0L) {
                        DynamicError dynamicError = new DynamicError("Integer division by zero");
                        dynamicError.setXPathContext(xPathContext);
                        dynamicError.setLocator(ExpressionTool.getLocator(this));
                        dynamicError.setErrorCode("FORG0001");
                        throw dynamicError;
                    }
                    if (this.value % l == 0L) {
                        return new IntegerValue(this.value / l);
                    }
                    return new DecimalValue(this.value).arithmetic(18, new DecimalValue(l), xPathContext);
                }
                case 19: {
                    return new IntegerValue(this.value % ((IntegerValue)numericValue).value);
                }
            }
            throw new UnsupportedOperationException("Unknown operator");
        }
        if (numericValue instanceof BigIntegerValue) {
            return new BigIntegerValue(this.value).arithmetic(n, numericValue, xPathContext);
        }
        NumericValue numericValue2 = (NumericValue)this.convert(numericValue.getItemType().getPrimitiveType(), xPathContext);
        return numericValue2.arithmetic(n, numericValue, xPathContext);
    }

    public ItemType getItemType() {
        return this.type;
    }

    public Object convertToJava(Class clazz, Configuration configuration, XPathContext xPathContext) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = IntegerValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return new Long(this.value);
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$IntegerValue == null ? (class$net$sf$saxon$value$IntegerValue = IntegerValue.class$("net.sf.saxon.value.IntegerValue")) : class$net$sf$saxon$value$IntegerValue)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514, null);
            return booleanValue.getBooleanValue();
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = IntegerValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514, null);
            return booleanValue.getBooleanValue();
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = IntegerValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = IntegerValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = IntegerValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = IntegerValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.value);
        }
        if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = IntegerValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(this.value);
        }
        if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = IntegerValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)this.value);
        }
        if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = IntegerValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)this.value);
        }
        if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = IntegerValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)this.value);
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = IntegerValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character((char)this.value);
        }
        if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = IntegerValue.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return BigInteger.valueOf(this.value);
        }
        if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = IntegerValue.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimal((double)this.value);
        }
        Object object = super.convertToJava(clazz, configuration, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of integer to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

