/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Comparator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class UntypedAtomicValue
extends StringValue {
    public static final UntypedAtomicValue ZERO_LENGTH_UNTYPED = new UntypedAtomicValue("");
    DoubleValue doubleValue = null;

    public UntypedAtomicValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : charSequence;
    }

    public ItemType getItemType() {
        return Type.UNTYPED_ATOMIC_TYPE;
    }

    public AtomicValue convert(int n, XPathContext xPathContext) throws XPathException {
        if (n == 513) {
            return new StringValue(this.value);
        }
        if (n == 517) {
            if (this.doubleValue == null) {
                this.doubleValue = (DoubleValue)super.convert(n, xPathContext);
            }
            return this.doubleValue;
        }
        return super.convert(n, xPathContext);
    }

    public int compareTo(Object object, Comparator comparator) {
        if (object instanceof NumericValue) {
            if (this.doubleValue == null) {
                try {
                    this.doubleValue = (DoubleValue)this.convert(517, null);
                }
                catch (XPathException xPathException) {
                    throw new ClassCastException("Cannot convert untyped value \"" + this.getStringValue() + "\" to a double");
                }
            }
            return this.doubleValue.compareTo(object);
        }
        if (object instanceof StringValue) {
            return comparator.compare(this.getStringValue(), ((StringValue)object).getStringValue());
        }
        if (object instanceof AtomicValue) {
            try {
                AtomicValue atomicValue = this.convert((AtomicType)((Value)object).getItemType(), null);
                if (!(atomicValue instanceof Comparable)) {
                    throw new DynamicError("Type " + ((Value)object).getItemType() + " is not ordered");
                }
                return ((Comparable)((Object)atomicValue)).compareTo(object);
            }
            catch (XPathException xPathException) {
                throw new ClassCastException("Cannot convert untyped atomic value '" + this.getStringValue() + "' to type " + ((Value)object).getItemType());
            }
        }
        return comparator.compare(this.getStringValue(), object.toString());
    }
}

