/*
 * Decompiled with CFR 0.152.
 */
package com.isogen.i18nsupport;

import com.isogen.i18nsupport.I18nServiceError;
import com.isogen.i18nsupport.I18nUtil;
import com.isogen.i18nsupport.NullLanguageMappingError;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StaticTextDatabase {
    public Hashtable textBefore = new Hashtable();
    public Hashtable textAfter = new Hashtable();
    public Hashtable attributeMap = new Hashtable();
    public static String[] availableLanguages = new String[100];
    public Hashtable langCodes = new Hashtable();

    String buildTranstableKey(String prefix, String langCode) {
        return String.valueOf(prefix) + "^" + langCode;
    }

    String getDefaultKey(String prefix) {
        return String.valueOf(prefix) + "^#DEFAULT";
    }

    String getDatabaseKey(String prefix, Element elemNode) throws I18nServiceError {
        String lang = I18nUtil.getElementLanguage(elemNode, "en");
        return this.buildTranstableKey(prefix, lang);
    }

    String getElementText(Element elem) throws NullLanguageMappingError {
        String resultStr = I18nUtil.getElementContent(elem);
        if (resultStr.equals("")) {
            throw new NullLanguageMappingError("Element Type=" + elem.getTagName());
        }
        return resultStr;
    }

    public boolean hasKey(String inKey, String langCode) throws I18nServiceError {
        String key = this.buildTranstableKey(inKey, langCode);
        if (this.textBefore.containsKey(key)) {
            return true;
        }
        key = String.valueOf(key) + "^#DEFAULT";
        return this.textBefore.containsKey(key);
    }

    void processTextBeforeOrAfter(String tagname, Element contextElem, String beforeOrAfter, Hashtable textMap, Hashtable langCodes) throws I18nServiceError {
        NodeList items;
        NodeList tempnl = contextElem.getElementsByTagName(beforeOrAfter);
        if (tempnl.getLength() == 0) {
            throw new I18nServiceError("Failed to find " + beforeOrAfter + " element within " + contextElem.getNodeName());
        }
        Element beforeOrAfterElem = (Element)tempnl.item(0);
        if ((tempnl = beforeOrAfterElem.getElementsByTagName("default_item")).getLength() == 1) {
            String key = String.valueOf(tagname) + "^#DEFAULT";
            String text = "";
            try {
                text = this.getElementText((Element)tempnl.item(0));
            }
            catch (NullLanguageMappingError nullLanguageMappingError) {
                // empty catch block
            }
            textMap.put(key, text);
        }
        if ((items = beforeOrAfterElem.getElementsByTagName("item")).getLength() > 0) {
            int i = 0;
            while (i < items.getLength()) {
                Element itemElem = (Element)items.item(i);
                String lang = itemElem.getAttribute("xml:lang");
                if (lang.equals("")) {
                    String text = "";
                    try {
                        text = this.getElementText(itemElem);
                    }
                    catch (NullLanguageMappingError nullLanguageMappingError) {
                        // empty catch block
                    }
                    throw new I18nServiceError("processTextBeforeOrAfter: no lang= value for node with text '" + text + "'");
                }
                langCodes.put(lang, lang);
                String key = this.buildTranstableKey(tagname, lang);
                Element firstChild = I18nUtil.getFirstElementChild(itemElem);
                String text = "";
                try {
                    text = this.getElementText(itemElem);
                }
                catch (NullLanguageMappingError nullLanguageMappingError) {
                    // empty catch block
                }
                textMap.put(key, text);
                ++i;
            }
        }
    }

    void processCommonContexts(Element commonContextElem, Hashtable langCodes) throws I18nServiceError {
        NodeList contexts = commonContextElem.getElementsByTagName("context");
        int i = 0;
        while (i < contexts.getLength()) {
            Element contextElem = (Element)contexts.item(i);
            Node tempnd = contexts.item(i);
            NodeList tempnl = ((Element)tempnd).getElementsByTagName("lookup_key");
            if (tempnl.getLength() == 0) {
                throw new I18nServiceError("Failed to find lookup_key element within common.context");
            }
            String lookupKey = "";
            try {
                lookupKey = this.getElementText((Element)tempnl.item(0));
            }
            catch (NullLanguageMappingError exc) {
                throw new I18nServiceError("Failed to get a lookup_key value from database");
            }
            this.processTextBeforeOrAfter(lookupKey, contextElem, "text_before", this.textBefore, langCodes);
            this.processTextBeforeOrAfter(lookupKey, contextElem, "text_after", this.textAfter, langCodes);
            ++i;
        }
    }

    void processAttributeMapping(String tagname, Element attMapElem, Hashtable langCodes) throws I18nServiceError {
        NodeList tempnl = attMapElem.getElementsByTagName("attr_name");
        if (tempnl.getLength() == 0) {
            throw new I18nServiceError("Failed to find <attr_name> element within <attr_map>");
        }
        String attname = "";
        try {
            attname = this.getElementText((Element)tempnl.item(0));
        }
        catch (NullLanguageMappingError exc) {
            throw new I18nServiceError("Failed to get an attribute name value from table");
        }
        NodeList attValues = attMapElem.getElementsByTagName("attr_values");
        if (attValues.getLength() == 0) {
            throw new I18nServiceError("Failed to find <attr_values> element within <attr_map>");
        }
        Element attValuesElem = (Element)attValues.item(0);
        String keyPrefix = String.valueOf(tagname) + "@" + attname;
        NodeList attValueMaps = attValuesElem.getElementsByTagName("attr_value_map");
        int i = 0;
        while (i < attValueMaps.getLength()) {
            NodeList items;
            String key;
            Element attValueMapElem = (Element)attValueMaps.item(i);
            tempnl = attValueMapElem.getElementsByTagName("attr_value");
            String attval = "";
            try {
                attval = this.getElementText((Element)tempnl.item(0));
            }
            catch (NullLanguageMappingError exc) {
                throw new I18nServiceError("<attr_value> element had no content.");
            }
            String attKeyPrefix = String.valueOf(keyPrefix) + "!" + attval;
            tempnl = attValueMapElem.getElementsByTagName("default_item");
            if (tempnl.getLength() == 1) {
                key = String.valueOf(attKeyPrefix) + "^#DEFAULT";
                this.attributeMap.put(key, I18nUtil.getElementContent((Element)tempnl.item(0)));
            }
            if ((items = attValueMapElem.getElementsByTagName("item")).getLength() > 0) {
                int j = 0;
                while (j < items.getLength()) {
                    Element itemElem = (Element)items.item(j);
                    String lang = itemElem.getAttribute("lang");
                    langCodes.put(lang, lang);
                    key = this.getDatabaseKey(attKeyPrefix, itemElem);
                    String text = I18nUtil.getElementContent(itemElem);
                    this.attributeMap.put(key, text);
                    ++j;
                }
            }
            ++i;
        }
    }

    void processCommonAttributeMappings(Element commonAttMapsElem, Hashtable langCodes) throws I18nServiceError {
        NodeList attMappings = commonAttMapsElem.getElementsByTagName("attr_map");
        int i = 0;
        while (i < attMappings.getLength()) {
            this.processAttributeMapping("#COMMON", (Element)attMappings.item(i), langCodes);
            ++i;
        }
    }

    public void loadStaticTextDatabase(String dbDocPath) throws I18nServiceError {
        DOMParser dp = new DOMParser();
        try {
            dp.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dp.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            dp.parse(dbDocPath);
            this.readDatabaseDoc(dp);
        }
        catch (Throwable e) {
            throw new I18nServiceError("Error constructing DOM from docid '" + dbDocPath + ": " + e.getMessage());
        }
    }

    public void loadStaticTextDatabase(URL dbDocUrl) throws I18nServiceError {
        DOMParser dp = new DOMParser();
        try {
            dp.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dp.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            InputSource inSrc = new InputSource(dbDocUrl.openStream());
            dp.parse(inSrc);
            this.readDatabaseDoc(dp);
        }
        catch (Throwable e) {
            throw new I18nServiceError("Error constructing DOM from docid '" + dbDocUrl.toExternalForm() + ": " + e.getMessage());
        }
    }

    private void readDatabaseDoc(DOMParser dp) throws Throwable {
        Document dbDoc = dp.getDocument();
        Element rootElem = dbDoc.getDocumentElement();
        if (rootElem == null) {
            throw new I18nServiceError("Failed to find root element of static text database document");
        }
        NodeList tempnl = rootElem.getElementsByTagName("contexts_common");
        if (tempnl.getLength() == 0) {
            throw new I18nServiceError("Failed to find 'contexts_common' element");
        }
        Element commonContextElem = (Element)tempnl.item(0);
        this.processCommonContexts(commonContextElem, this.langCodes);
        tempnl = rootElem.getElementsByTagName("attribute_maps_common");
        if (tempnl.getLength() > 0) {
            this.processCommonAttributeMappings((Element)tempnl.item(0), this.langCodes);
        }
        Collection codes = this.langCodes.values();
        Iterator codeIter = codes.iterator();
        int i = 0;
        while (i < codes.size()) {
            StaticTextDatabase.availableLanguages[i] = (String)codeIter.next();
            ++i;
        }
    }

    public String printStaticTextDatabase() throws I18nServiceError {
        String key;
        String result = "\n\nStatic Text Database\n";
        result = String.valueOf(result) + "Text Before:\n";
        Enumeration keys = this.textBefore.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            result = String.valueOf(result) + "\n" + key + "=" + this.textBefore.get(key);
        }
        result = String.valueOf(result) + "\n\nText After:\n";
        keys = this.textAfter.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            result = String.valueOf(result) + "\n" + key + "=" + this.textAfter.get(key);
        }
        result = String.valueOf(result) + "\n\nAttributes:\n";
        keys = this.attributeMap.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            result = String.valueOf(result) + "\n" + key + "=" + this.attributeMap.get(key);
        }
        return result;
    }
}

