/*
 * Decompiled with CFR 0.152.
 */
package com.isogen.util;

import com.isogen.util.IgnoreFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class FileUtil {
    public static void copyDirectory(File sourceDir, File destDir) throws IOException {
        FileUtil.copyDirectory(sourceDir, destDir, false);
    }

    public static void copyDirectory(File sourceDir, File destDir, boolean ignore) throws IOException {
        FileUtil.copyDirectory(sourceDir, destDir, ignore, null);
    }

    private static void copyDirectory(File sourceDir, File destDir, boolean ignore, IgnoreFilter ignoreFilter) throws IOException {
        if (ignoreFilter == null) {
            ignoreFilter = new IgnoreFilter();
        }
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File[] contents = null;
        contents = ignore ? sourceDir.listFiles(ignoreFilter) : sourceDir.listFiles();
        if (contents == null) {
            return;
        }
        int i = 0;
        while (i < contents.length) {
            if (contents[i].isDirectory()) {
                File destChildDir = new File(destDir, contents[i].getName());
                if (!destChildDir.exists()) {
                    destChildDir.mkdir();
                }
                FileUtil.copyDirectory(contents[i], destChildDir, ignore, ignoreFilter);
            } else {
                FileUtil.copyUpdatedFile(contents[i], destDir);
            }
            ++i;
        }
    }

    public static void copyUpdatedFile(File sourceFile, File destDir) throws IOException {
        File destChildFile = new File(destDir, sourceFile.getName());
        if (!destChildFile.exists() || destChildFile.lastModified() < sourceFile.lastModified()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(sourceFile));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destChildFile));
            byte[] bytes = new byte[1024];
            while (in.available() > 0) {
                int bytesRead = in.read(bytes);
                out.write(bytes, 0, bytesRead);
            }
            out.flush();
            out.close();
            in.close();
        }
    }

    public static void copyFile(File source, File dest) throws IOException {
        FileUtil.copyFile(source, dest, true);
    }

    public static void copyFile(File source, File dest, boolean quiet) throws IOException {
        int c;
        if (!quiet) {
            System.err.println("Copying " + source.getPath() + " to " + dest.getPath() + "...");
        }
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(dest);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static void copyFile(InputStream source, File dest) throws IOException {
        FileUtil.copyFile(source, dest, true);
    }

    public static void copyFile(InputStream source, File dest, boolean quiet) throws IOException {
        int c;
        if (!quiet) {
            System.err.println("Copying input stream  to " + dest.getPath() + "...");
        }
        InputStream in = source;
        FileOutputStream out = new FileOutputStream(dest);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static void deleteDirectory(File dir) {
        File[] contents = dir.listFiles();
        int i = 0;
        while (i < contents.length) {
            if (contents[i].isDirectory()) {
                FileUtil.deleteDirectory(contents[i]);
            } else {
                contents[i].delete();
            }
            ++i;
        }
        dir.delete();
    }

    public static String getFileDir(String filePath) {
        String resultDir = "";
        if (!filePath.substring(1, 2).equals(":") & !filePath.substring(1, 2).equals(".")) {
            resultDir = File.separator;
        }
        StringTokenizer pathSt = new StringTokenizer(filePath, "/\\");
        File f = new File(filePath);
        if (f.isDirectory()) {
            return filePath;
        }
        int n = pathSt.countTokens();
        if (n > 1) {
            resultDir = String.valueOf(resultDir) + pathSt.nextToken();
            int i = 1;
            while (i < n - 1) {
                resultDir = String.valueOf(resultDir) + File.separator + pathSt.nextToken();
                ++i;
            }
        }
        return resultDir;
    }

    public static String getFileName(String filePath) {
        if (filePath.equals("")) {
            return "";
        }
        String resultFn = "";
        File f = new File(filePath);
        if (f.isDirectory()) {
            return resultFn;
        }
        StringTokenizer pathSt = new StringTokenizer(filePath, "/\\");
        int n = pathSt.countTokens();
        if (n > 1) {
            int i = 1;
            while (i < n) {
                pathSt.nextToken();
                ++i;
            }
        }
        String fileName = pathSt.nextToken();
        return fileName;
    }

    public static String getFileExtension(String filePath) {
        String fileName = FileUtil.getFileName(filePath);
        if (fileName.indexOf(".") == -1) {
            return "";
        }
        StringTokenizer extSt = new StringTokenizer(fileName, ".");
        int n = extSt.countTokens();
        if (n > 1) {
            int i = 0;
            while (i < n - 1) {
                extSt.nextToken();
                ++i;
            }
        }
        if (extSt.hasMoreTokens()) {
            return extSt.nextToken();
        }
        return "";
    }

    public static String getFileBaseName(String filePath) {
        String fileName = FileUtil.getFileName(filePath);
        if (fileName.indexOf(".") <= 0) {
            return fileName;
        }
        StringTokenizer baseSt = new StringTokenizer(fileName, ".");
        int n = baseSt.countTokens();
        int i = 0;
        while (i < n - 2) {
            baseSt.nextToken();
            ++i;
        }
        if (baseSt.hasMoreTokens()) {
            return baseSt.nextToken();
        }
        return "";
    }

    public static String getRelativePath(String filePath, String targetPath) {
        int unCommonCount;
        int i;
        String relative_path = "";
        if (targetPath.substring(0, 2).equals("..")) {
            return targetPath;
        }
        if (targetPath.indexOf("/") < 0 && targetPath.indexOf("\\") < 0) {
            return targetPath;
        }
        if (filePath.endsWith("\\") || filePath.endsWith("/")) {
            filePath = String.valueOf(filePath) + "fake.file";
        }
        StringTokenizer fpst = new StringTokenizer(filePath, "/\\");
        StringTokenizer tpst = new StringTokenizer(targetPath, "/\\");
        int nf = fpst.countTokens() - 1;
        int nt = tpst.countTokens() - 1;
        int n = nf;
        if (nf > nt) {
            n = nt;
        }
        String ttoken = "";
        for (i = 0; i <= n; ++i) {
            String ftoken = fpst.nextToken();
            if (ftoken.equals(ttoken = tpst.nextToken())) {
                continue;
            }
            if (i != 0) break;
            return targetPath;
        }
        if ((unCommonCount = nf - i) > 0) {
            int j = 1;
            while (j <= unCommonCount) {
                relative_path = String.valueOf(relative_path) + "../";
                ++j;
            }
        }
        relative_path = String.valueOf(relative_path) + ttoken;
        while (tpst.hasMoreTokens()) {
            relative_path = String.valueOf(relative_path) + "/" + tpst.nextToken();
        }
        return relative_path;
    }

    public static void printFileBytes(String fn, int startByte, int length) throws IOException {
        File f = new File(fn);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        if (startByte > 0) {
            in.skip(startByte - 1);
        }
        StringBuffer buf = new StringBuffer();
        int i = startByte;
        while (i < startByte + length) {
            byte b = (byte)in.read();
            System.out.print(String.valueOf(FileUtil.byteToHex(b)) + " ");
            if (b >= 0 && b < 255) {
                buf.append((char)b);
                buf.append("  ");
            } else {
                buf.append("   ");
            }
            ++i;
        }
        System.out.print("\n");
        System.out.println(buf.toString());
        in.close();
    }

    public static void printFileBytes(String fn) throws IOException {
        FileUtil.printFileBytes(fn, 0, 10);
    }

    public static String byteToHex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public static String charToHex(char c) {
        byte hi = (byte)(c >>> 8);
        byte lo = (byte)(c & 0xFF);
        return String.valueOf(FileUtil.byteToHex(hi)) + FileUtil.byteToHex(lo);
    }

    public static String getAbsolutePath(String basePath, String relativePath) {
        String absPath = "";
        File baseDir = null;
        baseDir = basePath.indexOf(File.separator) > 0 ? new File(basePath) : (basePath.indexOf("/") > 0 ? new File(basePath.replace('/', File.separatorChar)) : new File(basePath));
        if (baseDir.isFile()) {
            baseDir = baseDir.getParentFile();
        }
        if (relativePath.indexOf(File.separator) > 0) {
            absPath = new File(baseDir, relativePath).getAbsolutePath();
        } else {
            String tempPath = "";
            tempPath = basePath.indexOf("/") > 0 ? relativePath.replace('/', File.separatorChar) : relativePath;
            absPath = new File(baseDir, tempPath).getAbsolutePath();
        }
        return absPath;
    }
}

