/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Loader;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonOutputKeys;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.TransformerReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.StrippedDocument;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trace.TraceEventMulticaster;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.tree.TreeBuilder;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class Controller
extends Transformer
implements InstructionInfoProvider {
    private Configuration config;
    private DocumentInfo principalSourceDocument;
    private Bindery bindery;
    private NamePool namePool;
    private DecimalFormatManager decimalFormatManager;
    private Emitter messageEmitter;
    private RuleManager ruleManager;
    private Properties outputProperties;
    private ParameterSet parameters;
    private PreparedStylesheet preparedStylesheet;
    private TraceListener traceListener;
    private boolean tracingPaused;
    private URIResolver standardURIResolver;
    private URIResolver userURIResolver;
    private Result principalResult;
    private String principalResultURI;
    private OutputURIResolver outputURIResolver;
    private ErrorListener errorListener;
    private Executable executable;
    private int recoveryPolicy = 1;
    private int treeModel = 1;
    private boolean disableStripping = false;
    private Template initialTemplate = null;
    private DocumentPool sourceDocumentPool;
    private HashMap userDataTable;
    private GregorianCalendar currentDateTime;
    private int initialMode = -1;
    private NodeInfo lastRememberedNode = null;
    private int lastRememberedNumber = -1;

    public Controller(Configuration configuration) {
        this.config = configuration;
        this.init();
    }

    private void init() {
        Object object;
        this.bindery = new Bindery();
        this.namePool = NamePool.getDefaultNamePool();
        this.standardURIResolver = new StandardURIResolver(this.config);
        this.userURIResolver = this.config.getURIResolver();
        this.outputURIResolver = this.config.getOutputURIResolver();
        this.errorListener = this.config.getErrorListener();
        if (this.errorListener instanceof StandardErrorListener) {
            object = ((StandardErrorListener)this.errorListener).getErrorOutput();
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother();
            ((StandardErrorListener)this.errorListener).setErrorOutput((PrintStream)object);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(this.config.getRecoveryPolicy());
        }
        this.sourceDocumentPool = new DocumentPool();
        this.userDataTable = new HashMap(20);
        object = this.config.getTraceListener();
        if (object != null) {
            this.addTraceListener((TraceListener)object);
        }
        this.setTreeModel(this.config.getTreeModel());
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setInitialMode(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("")) {
            return;
        }
        this.initialMode = this.namePool.allocateClarkName(string);
    }

    public void setOutputProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setOutputProperty(string, properties.getProperty(string));
        }
    }

    public Properties getOutputProperties() {
        if (this.outputProperties == null) {
            if (this.executable == null) {
                return new Properties();
            }
            this.outputProperties = this.executable.getDefaultOutputProperties();
        }
        Properties properties = new Properties();
        Enumeration<?> enumeration = this.outputProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, this.outputProperties.getProperty(string));
        }
        return properties;
    }

    public void setOutputProperty(String string, String string2) {
        if (this.outputProperties == null) {
            this.outputProperties = this.getOutputProperties();
        }
        try {
            SaxonOutputKeys.checkOutputProperty(string, string2);
        }
        catch (DynamicError dynamicError) {
            throw new IllegalArgumentException(dynamicError.getMessage());
        }
        this.outputProperties.put(string, string2);
    }

    public String getOutputProperty(String string) {
        try {
            SaxonOutputKeys.checkOutputProperty(string, null);
        }
        catch (DynamicError dynamicError) {
            throw new IllegalArgumentException(dynamicError.getMessage());
        }
        if (this.outputProperties == null) {
            if (this.executable == null) {
                return null;
            }
            this.outputProperties = this.executable.getDefaultOutputProperties();
        }
        return this.outputProperties.getProperty(string);
    }

    public String getPrincipalResultURI() {
        return this.principalResultURI;
    }

    public Result getPrincipalResult() {
        return this.principalResult;
    }

    public void setInitialTemplate(String string) throws XPathException {
        int n = this.namePool.allocateClarkName(string);
        Template template = this.getExecutable().getNamedTemplate(n);
        if (template == null) {
            DynamicError dynamicError = new DynamicError("There is no named template with expanded name " + string);
            dynamicError.setErrorCode("XT0040");
            throw dynamicError;
        }
        this.initialTemplate = template;
    }

    public Emitter makeMessageEmitter() throws XPathException {
        String string = this.config.getMessageEmitterClass();
        Object object = Loader.getInstance(string);
        if (!(object instanceof Emitter)) {
            throw new DynamicError(string + " is not an Emitter");
        }
        this.setMessageEmitter((Emitter)object);
        return this.messageEmitter;
    }

    public void setMessageEmitter(Emitter emitter) {
        this.messageEmitter = emitter;
        this.messageEmitter.setConfiguration(this.config);
    }

    public Emitter getMessageEmitter() {
        return this.messageEmitter;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void recoverableError(XPathException xPathException) throws DynamicError {
        try {
            if (this.config.getHostLanguage() == 11) {
                throw xPathException;
            }
            this.errorListener.warning(xPathException);
        }
        catch (TransformerException transformerException) {
            throw DynamicError.wrap(transformerException);
        }
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public DocumentPool getDocumentPool() {
        return this.sourceDocumentPool;
    }

    public void clearDocumentPool() {
        this.sourceDocumentPool = new DocumentPool();
    }

    public void setLineNumbering(boolean bl) {
    }

    public void setPrincipalSourceDocument(DocumentInfo documentInfo) {
        this.principalSourceDocument = documentInfo;
    }

    public Bindery getBindery() {
        return this.bindery;
    }

    public DocumentInfo getPrincipalSourceDocument() {
        return this.principalSourceDocument;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.userURIResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.userURIResolver == null ? this.standardURIResolver : this.userURIResolver;
    }

    public URIResolver getStandardURIResolver() {
        return this.standardURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver == null ? StandardOutputResolver.getInstance() : outputURIResolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public KeyManager getKeyManager() {
        return this.executable.getKeyManager();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setTreeModel(int n) {
        this.treeModel = n;
    }

    public Builder makeBuilder() {
        Builder builder = this.treeModel == 1 ? new TinyBuilder() : new TreeBuilder();
        builder.setTiming(this.config.isTiming());
        builder.setLineNumbering(this.config.isLineNumbering());
        builder.setConfiguration(this.config);
        return builder;
    }

    public Stripper makeStripper(Builder builder) {
        if (this.config.isStripsAllWhiteSpace()) {
            if (builder == null) {
                return AllElementStripper.getInstance();
            }
            AllElementStripper allElementStripper = new AllElementStripper();
            allElementStripper.setUnderlyingReceiver(builder);
            return allElementStripper;
        }
        Stripper stripper = this.executable == null ? new Stripper(new Mode()) : this.executable.newStripper();
        stripper.setController(this);
        if (builder != null) {
            stripper.setUnderlyingReceiver(builder);
        }
        return stripper;
    }

    public void registerDocument(DocumentInfo documentInfo, String string) {
        this.sourceDocumentPool.add(documentInfo, string);
        this.namePool.allocateDocumentNumber(documentInfo);
    }

    public void setDecimalFormatManager(DecimalFormatManager decimalFormatManager) {
        this.decimalFormatManager = decimalFormatManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public final boolean isTracing() {
        return this.traceListener != null && !this.tracingPaused;
    }

    public final void pauseTracing(boolean bl) {
        this.tracingPaused = bl;
    }

    public void addTraceListener(TraceListener traceListener) {
        this.traceListener = TraceEventMulticaster.add(this.traceListener, traceListener);
    }

    public void removeTraceListener(TraceListener traceListener) {
        this.traceListener = TraceEventMulticaster.remove(this.traceListener, traceListener);
    }

    public void setPreparedStylesheet(PreparedStylesheet preparedStylesheet) {
        this.preparedStylesheet = preparedStylesheet;
        this.executable = preparedStylesheet.getExecutable();
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    private void initializeController() {
        this.setRuleManager(this.executable.getRuleManager());
        this.setDecimalFormatManager(this.executable.getDecimalFormatManager());
        if (this.traceListener != null) {
            this.traceListener.open();
        }
        this.bindery = new Bindery();
        this.executable.initialiseBindery(this.bindery);
        this.defineGlobalParameters(this.bindery);
    }

    public void defineGlobalParameters(Bindery bindery) {
        bindery.defineGlobalParameters(this.parameters);
    }

    public Object getUserData(Object object, String string) {
        String string2 = object.hashCode() + " " + string;
        return this.userDataTable.get(string2);
    }

    public void setUserData(Object object, String string, Object object2) {
        String string2 = object.hashCode() + " " + string;
        if (object2 == null) {
            this.userDataTable.remove(string2);
        } else {
            this.userDataTable.put(string2, object2);
        }
    }

    public void transform(Source source, Result result) throws TransformerException {
        if (this.preparedStylesheet == null) {
            throw new DynamicError("Stylesheet has not been prepared");
        }
        this.currentDateTime = null;
        this.principalResultURI = result.getSystemId();
        try {
            Object object;
            Object object2;
            NodeInfo nodeInfo = null;
            boolean bl = true;
            boolean bl2 = this.config.isSchemaValidation();
            Source source2 = source;
            if (source instanceof AugmentedSource) {
                object2 = ((AugmentedSource)source).getWrapDocument();
                if (object2 != null) {
                    bl = (Boolean)object2;
                }
                if ((object = ((AugmentedSource)source).getSchemaValidation()) != null) {
                    bl2 = (Boolean)object;
                }
                if (bl2) {
                    bl = false;
                }
                source2 = ((AugmentedSource)source).getContainedSource();
            }
            if (bl && (source2 instanceof NodeInfo || source2 instanceof DOMSource)) {
                nodeInfo = this.prepareInputTree(source);
                this.registerDocument(nodeInfo.getDocumentRoot(), source.getSystemId());
            } else if (source == null) {
                if (this.initialTemplate == null) {
                    throw new DynamicError("Either a source document or an initial template must be specified");
                }
            } else {
                object2 = this.makeBuilder();
                object = new Sender(this.config);
                Object object3 = object2;
                if (this.executable.stripsWhitespace()) {
                    object3 = this.makeStripper((Builder)object2);
                }
                ((Sender)object).send(source, (Receiver)object3);
                DocumentInfo documentInfo = ((Builder)object2).getCurrentDocument();
                this.registerDocument(documentInfo, source.getSystemId());
                nodeInfo = documentInfo;
            }
            this.transformDocument(nodeInfo, result);
        }
        catch (TerminationException terminationException) {
            throw terminationException;
        }
        catch (XPathException xPathException) {
            Throwable throwable = xPathException.getException();
            if (throwable != null && throwable instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                if ((throwable = sAXParseException.getException()) instanceof RuntimeException) {
                    this.errorListener.fatalError(xPathException);
                }
            } else {
                this.errorListener.fatalError(xPathException);
            }
            throw xPathException;
        }
    }

    public NodeInfo prepareInputTree(Source source) {
        Object object;
        NodeInfo nodeInfo;
        Object object2;
        if (source instanceof DOMSource) {
            object2 = ((DOMSource)source).getNode();
            if (object2 instanceof NodeInfo) {
                nodeInfo = (NodeInfo)object2;
            } else {
                object = object2 instanceof Document ? (Document)object2 : object2.getOwnerDocument();
                DocumentWrapper documentWrapper = new DocumentWrapper((Document)object, source.getSystemId(), this.getConfiguration());
                nodeInfo = documentWrapper.wrap((Node)object2);
            }
        } else {
            nodeInfo = (NodeInfo)source;
        }
        if (this.executable.stripsWhitespace() && !this.disableStripping) {
            object2 = nodeInfo.getDocumentRoot();
            object = new StrippedDocument((DocumentInfo)object2, this.makeStripper(null));
            nodeInfo = ((StrippedDocument)object).wrap(nodeInfo);
        }
        return nodeInfo;
    }

    public void transformDocument(NodeInfo nodeInfo, Result result) throws TransformerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.executable == null) {
            throw new DynamicError("Stylesheet has not been compiled");
        }
        boolean bl = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        this.principalResult = result;
        this.principalResultURI = result.getSystemId();
        XPathContextMajor xPathContextMajor = this.newXPathContext();
        xPathContextMajor.setOrigin(this);
        if (nodeInfo != null) {
            if (nodeInfo instanceof DocumentInfo) {
                object4 = (DocumentInfo)nodeInfo;
            } else {
                object4 = nodeInfo.getDocumentRoot();
                if (object4 == null) {
                    throw new DynamicError("Source tree must have a document node as its root");
                }
            }
            this.principalSourceDocument = object4;
            if (object4.getConfiguration() == null) {
                object4.setConfiguration(this.getConfiguration());
            }
            if (object4.getNamePool() != this.preparedStylesheet.getTargetNamePool()) {
                throw new DynamicError("Source document and stylesheet must use the same name pool");
            }
            xPathContextMajor.setCurrentIterator(SingletonIterator.makeIterator((Item)object4));
        }
        this.initializeController();
        if (this.getConfiguration().getTraceListener() != null) {
            this.preEvaluateGlobals(xPathContextMajor);
        }
        object4 = this.executable.getDefaultOutputProperties();
        if (this.outputProperties != null) {
            object3 = this.outputProperties.propertyNames();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                object = this.outputProperties.getProperty((String)object2);
                ((Properties)object4).put(object2, object);
            }
        }
        if ((object3 = ((Properties)object4).getProperty("{http://saxon.sf.net/}next-in-chain")) != null) {
            object2 = ((Properties)object4).getProperty("{http://saxon.sf.net/}next-in-chain-base-uri");
            result = this.prepareNextStylesheet((String)object3, (String)object2, result);
        }
        xPathContextMajor.changeOutputDestination((Properties)object4, result, true, 3, null);
        if (this.initialTemplate == null) {
            xPathContextMajor.setCurrentIterator(SingletonIterator.makeIterator(nodeInfo));
            DocumentInfo documentInfo = this.principalSourceDocument = nodeInfo == null ? null : nodeInfo.getDocumentRoot();
            if (this.principalSourceDocument == null) {
                throw new DynamicError("Source tree must be rooted at a document node");
            }
            object2 = ApplyTemplates.applyTemplates(xPathContextMajor.getCurrentIterator(), this.getRuleManager().getMode(this.initialMode), null, null, xPathContextMajor);
            while (object2 != null) {
                object2 = object2.processLeavingTail(xPathContextMajor);
            }
        } else {
            object2 = this.initialTemplate;
            object = xPathContextMajor.newContext();
            ((XPathContextMajor)object).setOrigin(this);
            ((XPathContextMajor)object).openStackFrame(((Procedure)object2).getStackFrameMap());
            ((XPathContextMajor)object).setLocalParameters(new ParameterSet());
            ((XPathContextMajor)object).setTunnelParameters(new ParameterSet());
            TailCall tailCall = ((Template)object2).expand((XPathContext)object);
            while (tailCall != null) {
                tailCall = tailCall.processLeavingTail((XPathContext)object);
            }
        }
        if (this.traceListener != null) {
            this.traceListener.close();
        }
        xPathContextMajor.getReceiver().close();
        if (bl && result instanceof StreamResult && (object2 = ((StreamResult)result).getOutputStream()) != null) {
            try {
                ((OutputStream)object2).close();
            }
            catch (IOException iOException) {
                throw new DynamicError(iOException);
            }
        }
    }

    public void preEvaluateGlobals(XPathContext xPathContext) throws XPathException {
        HashMap hashMap = this.getExecutable().getGlobalVariableIndex();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            GlobalVariable globalVariable = (GlobalVariable)iterator.next();
            globalVariable.evaluateVariable(xPathContext);
        }
    }

    public Result prepareNextStylesheet(String string, String string2, Result result) throws TransformerException {
        Source source = this.getURIResolver().resolve(string, string2);
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        transformerFactoryImpl.setConfiguration(this.config);
        Templates templates = transformerFactoryImpl.newTemplates(source);
        TransformerReceiver transformerReceiver = new TransformerReceiver((Controller)templates.newTransformer());
        transformerReceiver.setSystemId(this.principalResultURI);
        transformerReceiver.setConfiguration(this.config);
        transformerReceiver.setResult(result);
        return transformerReceiver;
    }

    public void setParameter(String string, Object object) {
        Value value;
        if (this.parameters == null) {
            this.parameters = new ParameterSet();
        }
        try {
            value = Value.convertJavaObjectToXPath(object, this);
            if (value == null) {
                value = EmptySequence.getInstance();
            }
        }
        catch (XPathException xPathException) {
            value = new StringValue(object.toString());
        }
        int n = this.namePool.allocateClarkName(string);
        this.parameters.put(n, value);
    }

    public void clearParameters() {
        this.parameters = null;
    }

    public Object getParameter(String string) {
        if (this.parameters == null) {
            return null;
        }
        int n = this.namePool.allocateClarkName(string);
        return this.parameters.get(n);
    }

    public GregorianCalendar getCurrentDateTime() {
        if (this.currentDateTime == null) {
            this.currentDateTime = new GregorianCalendar();
        }
        return this.currentDateTime;
    }

    public XPathContextMajor newXPathContext() {
        return new XPathContextMajor(this);
    }

    public void setRememberedNumber(NodeInfo nodeInfo, int n) {
        this.lastRememberedNode = nodeInfo;
        this.lastRememberedNumber = n;
    }

    public int getRememberedNumber(NodeInfo nodeInfo) {
        if (this.lastRememberedNode == nodeInfo) {
            return this.lastRememberedNumber;
        }
        return -1;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(2000);
        return instructionDetails;
    }
}

