/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

abstract class BinaryExpression
extends ComputedExpression {
    protected Expression operand0;
    protected Expression operand1;
    protected int operator;

    public BinaryExpression(Expression expression, int n, Expression expression2) {
        this.operator = n;
        this.operand0 = expression;
        this.operand1 = expression2;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.operand0 = this.operand0.simplify(staticContext);
        this.operand1 = this.operand1.simplify(staticContext);
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.analyze(staticContext, itemType);
        this.operand1 = this.operand1.analyze(staticContext, itemType);
        try {
            if (this.operand0 instanceof Value && this.operand1 instanceof Value) {
                return ExpressionTool.eagerEvaluate(this, null);
            }
        }
        catch (DynamicError dynamicError) {}
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13) {
            this.operand0 = this.operand0.promote(promotionOffer);
            this.operand1 = this.operand1.promote(promotionOffer);
        }
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.operand0, this.operand1);
    }

    public int computeCardinality() {
        if (Cardinality.allowsZero(this.operand0.getCardinality()) && Cardinality.allowsZero(this.operand1.getCardinality())) {
            return 768;
        }
        return 512;
    }

    protected static boolean isCommutative(int n) {
        return n == 10 || n == 9 || n == 1 || n == 23 || n == 15 || n == 17 || n == 6 || n == 44 || n == 22 || n == 45;
    }

    public boolean equals(Object object) {
        if (object instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)object;
            if (this.operator == binaryExpression.operator) {
                if (this.operand0.equals(binaryExpression.operand0) && this.operand1.equals(binaryExpression.operand1)) {
                    return true;
                }
                if (BinaryExpression.isCommutative(this.operator) && this.operand0.equals(binaryExpression.operand1) && this.operand1.equals(binaryExpression.operand0)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return ("BinaryExpression " + this.operator).hashCode() ^ this.operand0.hashCode() ^ this.operand1.hashCode();
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "operator " + this.displayOperator());
        this.operand0.display(n + 1, namePool, printStream);
        this.operand1.display(n + 1, namePool, printStream);
    }

    protected String displayOperator() {
        return Token.tokens[this.operator];
    }
}

