/*
 * Decompiled with CFR 0.152.
 */
package com.isogen.indexhelper;

import com.isogen.i18nsupport.I18nService;
import com.isogen.i18nsupport.I18nUtil;
import com.isogen.i18nsupport.I18nUtilError;
import com.isogen.i18nsupport.MissingLocaleException;
import com.isogen.i18nsupport.compare.ComparatorFactory;
import com.isogen.indexhelper.IndexGroup;
import com.isogen.indexhelper.IndexHelper;
import com.isogen.indexhelper.IndexHelperException;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class IndexRuleSet {
    public static final int SORT_METHOD_BETWEEN_KEYS = 0;
    public static final int SORT_METHOD_BY_MEMBERS = 1;
    public static final int SORT_ENGLISH_BEFORE = 0;
    public static final int SORT_ENGLISH_AFTER = 1;
    public static final int SORT_ENGLISH_MIXED = 2;
    public static final int SORT_GROUPS_BY_KEYS = 0;
    public static final int SORT_GROUPS_BY_LABELS = 1;
    String langCode = null;
    Locale locale = null;
    String collationRuleSpec = null;
    TreeMap indexGroups;
    ArrayList threeCharMembers = new ArrayList();
    ArrayList twoCharMembers = new ArrayList();
    Hashtable members2keys = new Hashtable();
    Comparator comparator = null;
    Element configElem = null;
    public int sortStrategy = 1;
    public int sortEnglish = 0;
    public int sortGroups = 0;
    IndexHelper indexHelper = null;

    public IndexRuleSet(IndexHelper inIndexHelper, String inLangCode, Element indexConfigElement, File configFile) throws IndexHelperException {
        Element seElem;
        boolean use_java_collator = false;
        int replace_rules = 0;
        this.indexHelper = inIndexHelper;
        this.configElem = indexConfigElement;
        this.langCode = inLangCode;
        try {
            this.locale = I18nUtil.getLocaleFromLangCode(this.langCode);
        }
        catch (MissingLocaleException e) {
            String lang = "";
            String country = "";
            if (inLangCode.indexOf("-") > 0) {
                lang = inLangCode.substring(0, 2);
                country = inLangCode.substring(3);
            } else {
                lang = inLangCode;
            }
            this.locale = new Locale(lang, country);
        }
        Element colSpecElem = null;
        try {
            colSpecElem = I18nUtil.getElement(this.configElem, "collation_spec");
            if (I18nUtil.hasElementChildren(colSpecElem)) {
                NodeList nl;
                NodeList node_replace_rules;
                Element collatorSpecElem = I18nUtil.getElement(colSpecElem, "java_collation_spec");
                NodeList node_use_java_collator = colSpecElem.getElementsByTagName("use_java_collator");
                if (node_use_java_collator.getLength() != 0) {
                    use_java_collator = true;
                }
                if ((node_replace_rules = colSpecElem.getElementsByTagName("replace_rules")).getLength() != 0) {
                    replace_rules = 1;
                }
                if ((nl = colSpecElem.getElementsByTagName("include_collation_spec")).getLength() == 0) {
                    this.collationRuleSpec = I18nUtil.getElementContent(collatorSpecElem);
                } else {
                    Element ecsElem = (Element)nl.item(0);
                    String collationRuleFileName = I18nUtil.getElementContent(ecsElem);
                    File collationRuleFile = new File(configFile.getParentFile(), collationRuleFileName);
                    if (!collationRuleFile.exists()) {
                        System.err.println("*** Cannot find comparator rule spec file " + collationRuleFile.getAbsolutePath());
                    }
                    this.collationRuleSpec = I18nUtil.readUnicodeFile(collationRuleFile, "UTF8");
                }
            }
        }
        catch (Throwable e) {
            throw new IndexHelperException(e.getMessage());
        }
        try {
            if (use_java_collator) {
                if (this.collationRuleSpec != null) {
                    if (replace_rules == 0) {
                        String baseRules = ((RuleBasedCollator)Collator.getInstance(this.locale)).getRules();
                        String addRules = this.collationRuleSpec;
                        this.collationRuleSpec = String.valueOf(baseRules) + addRules;
                    }
                    this.comparator = new RuleBasedCollator(this.collationRuleSpec);
                } else {
                    this.comparator = Collator.getInstance(this.locale);
                }
            } else {
                ComparatorFactory compFact = I18nService.constructComparatorFactory();
                this.comparator = compFact.getComparatorForLocale(this.locale, this.collationRuleSpec, replace_rules);
            }
        }
        catch (Throwable e) {
            throw new IndexHelperException(e);
        }
        try {
            Element sbkElem = I18nUtil.getElement(this.configElem, "sort_between_keys");
            this.sortStrategy = 0;
        }
        catch (I18nUtilError sbkElem) {
            // empty catch block
        }
        try {
            Element sgbkElem = I18nUtil.getElement(this.configElem, "sort_by_members");
            this.sortGroups = 1;
        }
        catch (I18nUtilError sgbkElem) {
            // empty catch block
        }
        boolean getEnglishOption = false;
        try {
            seElem = I18nUtil.getElement(this.configElem, "sort_english_before");
            this.sortEnglish = 0;
            getEnglishOption = true;
        }
        catch (I18nUtilError nl) {
            // empty catch block
        }
        if (!getEnglishOption) {
            try {
                seElem = I18nUtil.getElement(this.configElem, "sort_english_after");
                this.sortEnglish = 1;
                getEnglishOption = true;
            }
            catch (I18nUtilError nl) {
                // empty catch block
            }
        }
        if (!getEnglishOption) {
            try {
                seElem = I18nUtil.getElement(this.configElem, "sort_english_mixed");
                this.sortEnglish = 2;
                getEnglishOption = true;
            }
            catch (I18nUtilError nl) {
                // empty catch block
            }
        }
        if (!getEnglishOption) {
            this.sortEnglish = this.langCode.compareToIgnoreCase("zh-cn") == 0 ? 2 : 0;
        }
        this.indexGroups = new TreeMap(this.comparator);
        Element igsElem = null;
        try {
            igsElem = I18nUtil.getElement(indexConfigElement, "group_definitions");
        }
        catch (I18nUtilError e) {
            throw new IndexHelperException(e.getMessage());
        }
        if (igsElem == null) {
            throw new IndexHelperException("No group_definitions element within index_config element");
        }
        NodeList nl = igsElem.getElementsByTagName("term_group");
        if (nl.getLength() == 0) {
            throw new IndexHelperException("No term_group elements within group_definitions element");
        }
        String lastKey = "\u0002";
        int i = 0;
        while (i < nl.getLength()) {
            Element igElem = (Element)nl.item(i);
            IndexGroup ig = new IndexGroup(this, igElem);
            lastKey = ig.key;
            this.indexGroups.put(ig.key, ig);
            int j = 0;
            while (j < ig.members.size()) {
                String mem = (String)ig.members.get(j);
                if (mem.length() == 3) {
                    this.threeCharMembers.add(mem);
                } else if (mem.length() == 2) {
                    this.twoCharMembers.add(mem);
                }
                this.members2keys.put(mem, ig.key);
                ++j;
            }
            ++i;
        }
    }

    public int getEnglishIndexPosition() {
        return this.sortEnglish;
    }

    public String getLanguage() {
        return this.langCode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Iterator getGroupKeysIterator() throws IndexHelperException {
        ArrayList al = new ArrayList(this.indexGroups.keySet());
        IndexRuleSet engConfig = this.indexHelper.getIndexRuleSet("en");
        if (this.sortEnglish == 1) {
            al.addAll(al.size(), engConfig.indexGroups.keySet());
        } else {
            al.addAll(0, engConfig.indexGroups.keySet());
        }
        return al.iterator();
    }

    public String getGroupKey(String indexEntry) throws IndexHelperException {
        if (indexEntry.equals("")) {
            return null;
        }
        if (this.sortStrategy == 0) {
            return this.getSortKeyByKeys(indexEntry);
        }
        if (this.sortStrategy == 1) {
            return this.getSortKeyByMembers(indexEntry);
        }
        throw new IndexHelperException("Unrecognized sort method value '" + String.valueOf(this.sortStrategy) + "'");
    }

    String getSortKeyByMembers(String indexEntry) {
        String candMember = null;
        if (indexEntry.length() > 2 && this.threeCharMembers.contains(indexEntry.substring(0, 3))) {
            candMember = indexEntry.substring(0, 3);
        }
        if (candMember == null & indexEntry.length() > 1 && this.twoCharMembers.contains(indexEntry.substring(0, 2))) {
            candMember = indexEntry.substring(0, 2);
        }
        if (candMember == null) {
            candMember = indexEntry.substring(0, 1);
        }
        if (this.members2keys.containsKey(candMember)) {
            return (String)this.members2keys.get(candMember);
        }
        return "#NUMERIC";
    }

    String getSortKeyByKeys(String indexEntry) throws IndexHelperException {
        Object[] keys = this.indexGroups.keySet().toArray();
        if (this.comparator.compare(indexEntry, (String)keys[0]) < 0) {
            IndexRuleSet engConfig = this.indexHelper.getIndexRuleSet("en");
            return engConfig.getGroupKey(indexEntry);
        }
        int i = 0;
        while (i < keys.length) {
            String secondKey = null;
            if (i == keys.length - 1) {
                secondKey = ((IndexGroup)this.indexGroups.get(this.indexGroups.lastKey())).lastMember;
                if (this.comparator.compare(indexEntry, (String)keys[i]) >= 0 && this.comparator.compare(indexEntry, secondKey) <= 0) {
                    return (String)keys[i];
                }
            } else {
                secondKey = (String)keys[i + 1];
                if (this.comparator.compare(indexEntry, (String)keys[i]) >= 0 && this.comparator.compare(indexEntry, secondKey) < 0) {
                    return (String)keys[i];
                }
            }
            ++i;
        }
        return "#NUMERIC";
    }

    public IndexGroup getIndexGroup(String groupKey) throws IndexHelperException {
        if (this.indexGroups.containsKey(groupKey)) {
            return (IndexGroup)this.indexGroups.get(groupKey);
        }
        if (!this.langCode.equals("en")) {
            IndexRuleSet engConfig = this.indexHelper.getIndexRuleSet("en");
            return engConfig.getIndexGroup(groupKey);
        }
        throw new IndexHelperException("IndexHelper.getIndexGroup(): No group with key '" + I18nUtil.escapeUnicodeString(groupKey) + "' for language '" + this.langCode + "'");
    }

    public String getGroupSortKey(String groupKey) throws IndexHelperException {
        if (this.indexGroups.containsKey(groupKey)) {
            return ((IndexGroup)this.indexGroups.get((Object)groupKey)).groupSortKey;
        }
        throw new IndexHelperException("IndexHelper.getGroupSortKey(): No group with key '" + I18nUtil.escapeUnicodeString(groupKey) + "' for language '" + this.langCode + "'");
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public String toString(boolean includeCollationRules) {
        String outStr = "\nIndex Configuration\n";
        outStr = String.valueOf(outStr) + "\n\tLanguage: " + this.langCode;
        outStr = includeCollationRules ? (this.collationRuleSpec != null ? String.valueOf(outStr) + "\n\tCollation spec: " + this.collationRuleSpec : String.valueOf(outStr) + "\n\tCollation spec: Use Java rules") : String.valueOf(outStr) + "\n\tCollation spec: {not shown}";
        outStr = String.valueOf(outStr) + "\n\tIndex Groups:";
        Iterator gi = this.indexGroups.values().iterator();
        while (gi.hasNext()) {
            outStr = String.valueOf(outStr) + ((IndexGroup)gi.next()).toString();
        }
        return String.valueOf(outStr) + "\n";
    }

    public String toString() {
        return this.toString(true);
    }

    void findAlphaStarts(Collator col) {
        String[] letters = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        try {
            String uhPY = I18nUtil.readUnicodeFile("mandarin.txt", "UTF8");
            StringReader sr = new StringReader(uhPY);
            LineNumberReader lnr = new LineNumberReader(sr);
            String inline = null;
            inline = "";
            int i = 0;
            String candChar = "\ufff0";
            String alphaCode = "";
            alphaCode = letters[0];
            while (inline != null) {
                try {
                    inline = lnr.readLine();
                }
                catch (IOException e) {
                    System.err.println(String.valueOf(alphaCode) + "=" + I18nUtil.escapeUnicodeString(candChar));
                    break;
                }
                if (inline == null) {
                    System.err.println(String.valueOf(alphaCode) + "=" + I18nUtil.escapeUnicodeString(candChar));
                    break;
                }
                int p = inline.indexOf("  ");
                if (p <= 0) continue;
                String charCode = inline.substring(0, p);
                String pinyin = inline.substring(p + 2);
                String firstChar = pinyin.substring(0, 1);
                if (firstChar.compareTo(alphaCode) > 0) {
                    System.err.println(String.valueOf(alphaCode) + "=" + I18nUtil.escapeUnicodeString(candChar));
                    alphaCode = letters[++i];
                    candChar = "\ufff0";
                }
                if (col.compare(candChar, charCode) <= 0) continue;
                candChar = charCode;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

