/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.XSLStringConstructor;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public final class XSLValueOf
extends XSLStringConstructor {
    private boolean disable = false;
    private Expression separator;

    protected ItemType getReturnedItemType() {
        return NodeKindTest.TEXT;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        String string2 = null;
        String string3 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string4 = this.getNamePool().getClarkName(n2);
            if (string4 == "disable-output-escaping") {
                string2 = attributeCollection.getValue(n).trim();
            } else if (string4 == "select") {
                string = attributeCollection.getValue(n);
            } else if (string4 == "separator") {
                string3 = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
        if (string3 != null) {
            this.separator = this.makeAttributeValueTemplate(string3);
        }
        if (string2 != null) {
            if (string2.equals("yes")) {
                this.disable = true;
            } else if (string2.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        super.validate();
        this.checkWithinTemplate();
        this.select = this.typeCheck("select", this.select);
        this.separator = this.typeCheck("separator", this.separator);
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        if (this.separator == null && this.select != null && this.backwardsCompatibleModeIsEnabled()) {
            if (!Type.isSubType(this.select.getItemType(), Type.ANY_ATOMIC_TYPE)) {
                this.select = new Atomizer(this.select);
            }
            if (Cardinality.allowsMany(this.select.getCardinality())) {
                this.select = new FirstItemExpression(this.select);
            }
            if (!Type.isSubType(this.select.getItemType(), Type.STRING_TYPE)) {
                this.select = new AtomicSequenceConverter(this.select, Type.STRING_TYPE);
            }
        } else if (this.separator == null) {
            this.separator = this.select == null ? StringValue.EMPTY_STRING : new StringValue(" ");
        }
        ValueOf valueOf = new ValueOf(this.select, this.disable);
        this.compileContent(executable, valueOf);
        valueOf.setSeparator(this.separator);
        ExpressionTool.makeParentReferences(valueOf);
        return valueOf;
    }
}

