package com.isogen.i18nsupport;

import java.util.Comparator;
import java.util.Iterator;

import com.isogen.indexhelper.IndexHelper;
import com.isogen.indexhelper.IndexHelperException;

import junit.framework.TestCase;

public class IndexConfigTest extends TestCase {

	IndexHelper indexHelper = null;
	
	public IndexConfigTest(String arg0) {
		super(arg0);
	}
	
	public void setUp() {
    	String fileNamePropName = "com.innodata.i18nsupport.indexConfigFilename";
    	String configFilename = System.getProperty(fileNamePropName);
    	if (configFilename == null) {
    		fail("System property '" + fileNamePropName + "' not set. " + 
    		     "Needs to be path to the index configuration document.");			
    	}
		indexHelper = new IndexHelper();
		try {
			indexHelper.loadIndexRuleSetDoc(configFilename);
			
		} catch (IndexHelperException e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
		
	}

	public void testGetGroupSortKey() {
		String langCode = "zh-TW"; // Traditional Chinese
		
		String groupKey1 = "\u4E00"; 
		String groupKey2 = "\u4E01";
		String groupKey20 = "\u56B7";
		
		try {
			String sortKey1 = indexHelper.getGroupSortKey(langCode, groupKey1);
			assertEquals(groupKey1, sortKey1);
			String sortKey2 = indexHelper.getGroupSortKey(langCode, groupKey2);
			assertEquals(groupKey2, sortKey2);
			String sortKey20 = indexHelper.getGroupSortKey(langCode, groupKey20);
			assertEquals(groupKey20, sortKey20);
			I18nService i18nService = new I18nService();
			Comparator col = i18nService.getComparatorForLanguageCode(langCode);
			assertEquals(-1, col.compare(sortKey2, sortKey20));
		} catch (Throwable e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
		
	}
	
	public void testThaiIndexConfig() {
		Iterator iter = null;
		try {
			iter = indexHelper.getIndexGroupKeysIterator("th");
		} catch (Throwable e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
		while (iter.hasNext()) {
			String groupKey = (String)(iter.next());
			System.err.println("key=" + I18nUtil.escapeUnicodeString(groupKey));
		}
	}
}
