/*
 * Decompiled with CFR 0.152.
 */
package com.isogen.i18nsupport;

import com.isogen.i18nsupport.I18nServiceError;
import com.isogen.i18nsupport.I18nUtil;
import com.isogen.i18nsupport.StaticTextDatabase;
import com.isogen.i18nsupport.compare.ComparatorFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class I18nService {
    StaticTextDatabase textDb = new StaticTextDatabase();
    public static final String COMPARATORFACTORYNAMESYSTEMPROPERTY = "com.isogen.i18nsupport.comparatorFactoryClass";
    private static final String DEFAULTCOMPARATORYFACTORYCLASSNAME = "com.isogen.i18nsupport.compare.IcuComparatorFactoryImpl";
    private ComparatorFactory comparatorFactory = I18nService.constructComparatorFactory();
    private static final String version = "1";
    private static final String release = "2";

    public static String getVersionAndRelease() {
        return "1.2";
    }

    public static ComparatorFactory constructComparatorFactory() throws Throwable {
        String comparatorFactoryClassName = DEFAULTCOMPARATORYFACTORYCLASSNAME;
        ComparatorFactory comparatorFactory = null;
        if (System.getProperty(COMPARATORFACTORYNAMESYSTEMPROPERTY) != null) {
            comparatorFactoryClassName = System.getProperty(COMPARATORFACTORYNAMESYSTEMPROPERTY);
        }
        comparatorFactory = (ComparatorFactory)Class.forName(comparatorFactoryClassName).newInstance();
        return comparatorFactory;
    }

    public boolean isTargetLanguage(Element elemNode, String targetLangCode) throws I18nServiceError {
        String langCode = "en";
        String langAttName = I18nUtil.getLangAttName();
        if (elemNode.hasAttribute(langAttName)) {
            langCode = elemNode.getAttribute(langAttName);
        } else if (elemNode.hasAttributeNS("xml", "lang")) {
            langCode = elemNode.getAttributeNS("xml", "lang");
        } else if (elemNode.hasAttribute("xml:lang")) {
            langCode = elemNode.getAttribute("xml:lang");
        }
        return langCode.equals(targetLangCode);
    }

    public String getParaGeneratedTextBefore(Element elemNode) throws I18nServiceError {
        Element parent = (Element)elemNode.getParentNode().getParentNode();
        String tagname = parent.getNodeName();
        String key = this.textDb.getDatabaseKey(tagname, elemNode);
        if (this.textDb.textBefore.containsKey(key)) {
            return (String)this.textDb.textBefore.get(key);
        }
        return "{No generated text before found for '" + tagname + "' element}";
    }

    public String getParaGeneratedTextAfter(Element elemNode) throws I18nServiceError {
        Element parent = (Element)elemNode.getParentNode().getParentNode();
        String tagname = parent.getNodeName();
        String key = this.textDb.getDatabaseKey(tagname, elemNode);
        if (this.textDb.textBefore.containsKey(key)) {
            return (String)this.textDb.textAfter.get(key);
        }
        return "{No generated text after found for '" + tagname + "' element}";
    }

    public String getParaGeneratedTextBeforeFirst(Element elemNode) throws I18nServiceError {
        Element parentElem = (Element)elemNode.getParentNode();
        if (this.isFirstChild(parentElem)) {
            return this.getParaGeneratedTextBefore(elemNode);
        }
        String firstChildTagname = parentElem.getParentNode().getFirstChild().getNodeName();
        throw new I18nServiceError("Element " + parentElem.getNodeName() + " was not first, " + firstChildTagname + " is first child of para's grandparent");
    }

    public String getGeneratedTextForKeyBefore(String inKey, Element elemNode) throws I18nServiceError {
        String key = this.textDb.getDatabaseKey(inKey, elemNode);
        if (this.textDb.textBefore.containsKey(key)) {
            return (String)this.textDb.textBefore.get(key);
        }
        key = String.valueOf(elemNode.getNodeName()) + "^#DEFAULT";
        if (this.textDb.textBefore.containsKey(key)) {
            return (String)this.textDb.textBefore.get(key);
        }
        return "{No generated text before found for '" + inKey + "'}";
    }

    public String getGeneratedTextForKeyBefore(String inKey, String langCode) throws I18nServiceError {
        String key = this.textDb.buildTranstableKey(inKey, langCode);
        if (this.textDb.textBefore.containsKey(key)) {
            return (String)this.textDb.textBefore.get(key);
        }
        key = String.valueOf(inKey) + "^#DEFAULT";
        if (this.textDb.textBefore.containsKey(key)) {
            return (String)this.textDb.textBefore.get(key);
        }
        return "{No generated text before found for '" + inKey + "'}";
    }

    public String getGeneratedTextForKeyAfter(String inKey, String langCode) throws I18nServiceError {
        String key = this.textDb.buildTranstableKey(inKey, langCode);
        if (this.textDb.textAfter.containsKey(key)) {
            return (String)this.textDb.textAfter.get(key);
        }
        key = String.valueOf(inKey) + "^#DEFAULT";
        if (this.textDb.textAfter.containsKey(key)) {
            return (String)this.textDb.textAfter.get(key);
        }
        return "{No generated text after found for '" + inKey + "'}";
    }

    public String getGeneratedTextForKeyAfter(String inKey, Element elemNode) throws I18nServiceError {
        String key = this.textDb.getDatabaseKey(inKey, elemNode);
        if (this.textDb.textAfter.containsKey(key)) {
            return (String)this.textDb.textAfter.get(key);
        }
        key = String.valueOf(elemNode.getNodeName()) + "^#DEFAULT";
        if (this.textDb.textAfter.containsKey(key)) {
            return (String)this.textDb.textAfter.get(key);
        }
        return "{No generated text before found for '" + inKey + "'}";
    }

    public String getGeneratedTextBefore(Element elemNode, String langCode) throws I18nServiceError {
        String tagname = elemNode.getNodeName();
        return this.getGeneratedTextForKeyBefore(tagname, langCode);
    }

    public boolean isFirstChild(Element elemNode) throws I18nServiceError {
        Node parentNode = elemNode.getParentNode();
        if (parentNode == null) {
            return true;
        }
        Node firstChild = parentNode.getFirstChild();
        if (elemNode.equals(firstChild)) {
            return true;
        }
        NodeList children = parentNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                return child.equals(elemNode);
            }
            ++i;
        }
        return false;
    }

    public boolean isFirstChildOfType(Element elemNode) throws I18nServiceError {
        return false;
    }

    public String getGeneratedTextBeforeFirst(Element elemNode, String langCode) throws I18nServiceError {
        if (this.isFirstChild(elemNode)) {
            return this.getGeneratedTextBefore(elemNode, langCode);
        }
        return "";
    }

    public String getGeneratedTextAfter(Element elemNode) throws I18nServiceError {
        String langCode = I18nUtil.getElementLanguage(elemNode, "en");
        String tagname = elemNode.getNodeName();
        String key = this.textDb.getDatabaseKey(tagname, elemNode);
        if (this.textDb.textAfter.containsKey(key)) {
            return (String)this.textDb.textAfter.get(key);
        }
        key = String.valueOf(elemNode.getNodeName()) + "^#DEFAULT";
        if (this.textDb.textAfter.containsKey(key)) {
            return (String)this.textDb.textAfter.get(key);
        }
        return "{No generated text after found for '" + tagname + "' element}";
    }

    String makeAttKeyPrefix(String tagname, String attName, String attval) throws I18nServiceError {
        return String.valueOf(tagname) + "@" + attName + "!" + attval;
    }

    String makeAttKey(Element elemNode, String tagname, String attName, String attval) throws I18nServiceError {
        String prefix = this.makeAttKeyPrefix(tagname, attName, attval);
        return this.textDb.getDatabaseKey(prefix, elemNode);
    }

    String makeAttKey(String tagname, String attName, String attval, String langCode) throws I18nServiceError {
        String prefix = this.makeAttKeyPrefix(tagname, attName, attval);
        return this.textDb.buildTranstableKey(prefix, langCode);
    }

    String makeAttKeyDefault(String tagname, String attName, String attval) throws I18nServiceError {
        String prefix = this.makeAttKeyPrefix(tagname, attName, attval);
        return this.textDb.getDefaultKey(prefix);
    }

    String lookupAttributeTranslation(Element attHolderNode, String attName) throws I18nServiceError {
        String tagname = attHolderNode.getNodeName();
        String attval = attHolderNode.getAttribute(attName);
        String key = this.makeAttKey(attHolderNode, tagname, attName, attval);
        String keyDefault = this.makeAttKeyDefault(tagname, attName, attval);
        if (this.textDb.attributeMap.containsKey(key)) {
            return (String)this.textDb.attributeMap.get(key);
        }
        key = this.makeAttKey(attHolderNode, "#COMMON", attName, attval);
        if (this.textDb.attributeMap.containsKey(key)) {
            return (String)this.textDb.attributeMap.get(key);
        }
        key = this.makeAttKeyDefault("#COMMON", attName, attval);
        if (this.textDb.attributeMap.containsKey(key)) {
            return (String)this.textDb.attributeMap.get(key);
        }
        return "{ERROR: no mapping for attribute " + attName + ", value '" + attval + "'}";
    }

    public String getTranslatedAttValueForKey(String tagname, String attName, String attval, String langCode) throws I18nServiceError {
        String key = this.makeAttKey(tagname, attName, attval, langCode);
        String keyDefault = this.makeAttKeyDefault(tagname, attName, attval);
        if (this.textDb.attributeMap.containsKey(key)) {
            return (String)this.textDb.attributeMap.get(key);
        }
        key = this.makeAttKey("#COMMON", attName, attval, langCode);
        if (this.textDb.attributeMap.containsKey(key)) {
            return (String)this.textDb.attributeMap.get(key);
        }
        key = this.makeAttKeyDefault("#COMMON", attName, attval);
        if (this.textDb.attributeMap.containsKey(key)) {
            return (String)this.textDb.attributeMap.get(key);
        }
        return "{ERROR: no mapping for attribute " + attName + ", value '" + attval + "'}";
    }

    public String getTranslatedAttValue(Element elemNode, String attName) throws I18nServiceError {
        Element attHolderNode = I18nUtil.getAttHolder(elemNode, attName);
        if (attHolderNode != null) {
            return this.lookupAttributeTranslation(attHolderNode, attName);
        }
        return "{FOSI code error: no ancestor of " + elemNode.getNodeName() + " takes '" + attName + "' attribute}";
    }

    public void loadStaticTextDatabase(String dbDocPath) throws I18nServiceError {
        URL dbDocUrl = null;
        try {
            dbDocUrl = new File(dbDocPath).toURL();
        }
        catch (MalformedURLException e) {
            throw new I18nServiceError(e);
        }
        this.textDb.loadStaticTextDatabase(dbDocUrl);
    }

    public void loadStaticTextDatabase(URL dbDocUrl) throws I18nServiceError {
        this.textDb.loadStaticTextDatabase(dbDocUrl);
    }

    public String printStaticTextDatabase() throws I18nServiceError {
        return this.textDb.printStaticTextDatabase();
    }

    public boolean hasKey(String key, String langCode) throws I18nServiceError {
        return this.textDb.hasKey(key, langCode);
    }

    public ComparatorFactory getComparatorFactory() throws I18nServiceError {
        return this.comparatorFactory;
    }

    public Comparator getComparatorForLanguageCode(String langCode) throws Exception {
        Locale locale = I18nUtil.getLocaleFromLangCode(langCode);
        return this.comparatorFactory.getComparatorForLocale(locale, null, 0);
    }
}

