/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class ComplexContentOutputter
extends SequenceReceiver {
    private Configuration config;
    private NamePool namePool;
    private Receiver receiver;
    private int pendingStartTag = -1;
    private boolean topLevel = true;
    private boolean elementIsInNullNamespace = false;
    private int[] pendingAttCode = new int[20];
    private int[] pendingAttType = new int[20];
    private CharSequence[] pendingAttValue = new String[20];
    private int[] pendingAttLocation = new int[20];
    private int[] pendingAttProp = new int[20];
    private int pendingAttListSize = 0;
    private int[] pendingNSList = new int[20];
    private int pendingNSListSize = 0;
    private int currentSimpleType = -1;
    private boolean suppressAttributes = false;
    private int startElementProperties;
    private int startElementLocationId;

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.namePool = configuration.getNamePool();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setSystemId(String string) {
    }

    public String getSystemId() {
        return null;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void open() throws XPathException {
        this.receiver.open();
        this.previousAtomic = false;
    }

    public void startDocument(int n) throws XPathException {
    }

    public void endDocument() throws XPathException {
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        this.previousAtomic = false;
        if (charSequence == null) {
            return;
        }
        int n3 = charSequence.length();
        if (n3 == 0) {
            return;
        }
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.receiver.characters(charSequence, n, n2);
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        this.topLevel = false;
        if (n == -1) {
            this.suppressAttributes = true;
            return;
        }
        this.suppressAttributes = false;
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.startElementProperties = n4;
        this.startElementLocationId = n3;
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = n;
        this.elementIsInNullNamespace = (this.namePool.allocateNamespaceCode(this.pendingStartTag) & 0xFFFF) == 0;
        this.currentSimpleType = n2;
        this.previousAtomic = false;
    }

    public void namespace(int n, int n2) throws XPathException {
        if (this.suppressAttributes) {
            return;
        }
        if (this.pendingStartTag == -1) {
            throw new NoOpenStartTagException(13, this.topLevel);
        }
        boolean bl = (n2 & 0x20) != 0;
        int n3 = 0;
        while (n3 < this.pendingNSListSize) {
            if (n == this.pendingNSList[n3]) {
                return;
            }
            if (n >> 16 == this.pendingNSList[n3] >> 16) {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("Cannot create two namespace nodes with the same name");
                    dynamicError.setErrorCode("XT0430");
                    throw dynamicError;
                }
                return;
            }
            ++n3;
        }
        if (this.elementIsInNullNamespace && n >> 16 == 0 && (n & 0xFFFF) != 0) {
            DynamicError dynamicError = new DynamicError("Cannot output a namespace node for the default namespace when the element is in no namespace");
            dynamicError.setErrorCode("XT0440");
            throw dynamicError;
        }
        if (this.pendingNSListSize + 1 > this.pendingNSList.length) {
            int[] nArray = new int[this.pendingNSListSize * 2];
            System.arraycopy(this.pendingNSList, 0, nArray, 0, this.pendingNSListSize);
            this.pendingNSList = nArray;
        }
        this.pendingNSList[this.pendingNSListSize++] = n;
        this.previousAtomic = false;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (this.suppressAttributes) {
            return;
        }
        if (this.pendingStartTag == -1) {
            throw new NoOpenStartTagException(2, this.topLevel);
        }
        int n5 = 0;
        while (n5 < this.pendingAttListSize) {
            if (this.pendingAttCode[n5] == n) {
                if ((n4 & 0x20) == 0) {
                    this.pendingAttType[n5] = n2;
                    this.pendingAttValue[n5] = charSequence;
                    this.pendingAttLocation[n5] = n3;
                    this.pendingAttProp[n5] = n4;
                    return;
                }
                DynamicError dynamicError = new DynamicError("Duplicate attribute: " + this.namePool.getDisplayName(n));
                dynamicError.setErrorCode("XQ0025");
                throw dynamicError;
            }
            ++n5;
        }
        if (this.pendingAttListSize >= this.pendingAttCode.length) {
            int[] nArray = new int[this.pendingAttListSize * 2];
            int[] nArray2 = new int[this.pendingAttListSize * 2];
            String[] stringArray = new String[this.pendingAttListSize * 2];
            int[] nArray3 = new int[this.pendingAttListSize * 2];
            int[] nArray4 = new int[this.pendingAttListSize * 2];
            System.arraycopy(this.pendingAttCode, 0, nArray, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttType, 0, nArray2, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttValue, 0, stringArray, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttLocation, 0, nArray3, 0, this.pendingAttListSize);
            System.arraycopy(this.pendingAttProp, 0, nArray4, 0, this.pendingAttListSize);
            this.pendingAttCode = nArray;
            this.pendingAttType = nArray2;
            this.pendingAttValue = stringArray;
            this.pendingAttLocation = nArray3;
            this.pendingAttProp = nArray4;
        }
        this.pendingAttCode[this.pendingAttListSize] = n;
        this.pendingAttType[this.pendingAttListSize] = n2;
        this.pendingAttValue[this.pendingAttListSize] = charSequence;
        this.pendingAttLocation[this.pendingAttListSize] = n3;
        this.pendingAttProp[this.pendingAttListSize] = n4;
        ++this.pendingAttListSize;
        this.previousAtomic = false;
    }

    private int checkProposedPrefix(int n, int n2) throws XPathException {
        int n3 = this.namePool.allocateNamespaceCode(n);
        int n4 = n3 >> 16;
        int n5 = 0;
        while (n5 < this.pendingNSListSize) {
            if (n4 == this.pendingNSList[n5] >> 16) {
                if ((n3 & 0xFFFF) == (this.pendingNSList[n5] & 0xFFFF)) {
                    return n;
                }
                String string = this.getSubstitutePrefix(n3, n2);
                int n6 = this.namePool.allocate(string, this.namePool.getURI(n), this.namePool.getLocalName(n));
                this.namespace(this.namePool.allocateNamespaceCode(n6), 0);
                return n6;
            }
            ++n5;
        }
        this.namespace(n3, 0);
        return n;
    }

    private String getSubstitutePrefix(int n, int n2) {
        String string = this.namePool.getPrefixFromNamespaceCode(n);
        return string + '_' + n2;
    }

    public void endElement() throws XPathException {
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.receiver.endElement();
        this.previousAtomic = false;
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.receiver.comment(charSequence, n, n2);
        this.previousAtomic = false;
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.pendingStartTag != -1) {
            this.startContent();
        }
        this.receiver.processingInstruction(string, charSequence, n, n2);
        this.previousAtomic = false;
    }

    public void append(Item item, int n) throws XPathException {
        if (item == null) {
            return;
        }
        if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.characters(" ", n, 0);
            }
            if (item instanceof QNameValue) {
                DynamicError dynamicError = new DynamicError("Cannot add a QName value to the content of an element");
                dynamicError.setErrorCode("XT0380");
                throw dynamicError;
            }
            this.characters(item.getStringValue(), n, 0);
            this.previousAtomic = true;
        } else if (item instanceof DocumentInfo) {
            Item item2;
            AxisIterator axisIterator = ((DocumentInfo)item).iterateAxis((byte)3);
            while ((item2 = axisIterator.next()) != null) {
                this.append(item2, n);
            }
        } else {
            ((NodeInfo)item).copy(this, 2, true, n);
            this.previousAtomic = false;
        }
    }

    public void close() throws XPathException {
        this.receiver.close();
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        int n;
        if (this.pendingStartTag == -1) {
            return;
        }
        int n2 = this.checkProposedPrefix(this.pendingStartTag, 0);
        this.receiver.startElement(n2, this.currentSimpleType, this.startElementLocationId, this.startElementProperties | 0x40);
        int n3 = 0;
        while (n3 < this.pendingAttListSize) {
            n = this.pendingAttCode[n3];
            if ((n >> 20 & 0xFF) != 0) {
                this.pendingAttCode[n3] = this.checkProposedPrefix(n, n3 + 1);
            }
            ++n3;
        }
        n = 0;
        while (n < this.pendingNSListSize) {
            this.receiver.namespace(this.pendingNSList[n], 0);
            ++n;
        }
        int n4 = 0;
        while (n4 < this.pendingAttListSize) {
            this.receiver.attribute(this.pendingAttCode[n4], this.pendingAttType[n4], this.pendingAttValue[n4], this.pendingAttLocation[n4], this.pendingAttProp[n4]);
            ++n4;
        }
        this.receiver.startContent();
        this.pendingAttListSize = 0;
        this.pendingNSListSize = 0;
        this.pendingStartTag = -1;
        this.previousAtomic = false;
    }
}

