/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.xpath.XPathException;

public final class XMLIndenter
extends ProxyReceiver {
    private int level = 0;
    private int indentSpaces = 3;
    private String indentChars = "                                                          ";
    private boolean sameline = false;
    private boolean afterTag = true;
    private boolean allWhite = true;
    private int line = 0;
    private int column = 0;
    private int suppressedAtLevel = -1;
    private int xmlspace;

    public void setOutputProperties(Properties properties) {
        String string = properties.getProperty("{http://saxon.sf.net/}indent-spaces");
        if (string == null) {
            this.indentSpaces = 3;
        } else {
            try {
                this.indentSpaces = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.indentSpaces = 3;
            }
        }
        String string2 = properties.getProperty("omit-xml-declaration");
        this.afterTag = string2 == null || !string2.trim().equals("yes") || properties.getProperty("doctype-system") != null;
    }

    public void open() throws XPathException {
        super.open();
        this.xmlspace = this.getNamePool().allocate("xml", "http://www.w3.org/XML/1998/namespace", "space") & 0xFFFFF;
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        if (this.afterTag) {
            this.indent();
        }
        super.startElement(n, n2, n3, n4);
        ++this.level;
        this.sameline = true;
        this.afterTag = true;
        this.allWhite = true;
        this.line = 0;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if ((n & 0xFFFFF) == this.xmlspace && charSequence.equals("preserve") && this.suppressedAtLevel < 0) {
            this.suppressedAtLevel = this.level;
        }
        super.attribute(n, n2, charSequence, n3, n4);
    }

    public void endElement() throws XPathException {
        --this.level;
        if (this.afterTag && !this.sameline) {
            this.indent();
        }
        super.endElement();
        this.sameline = false;
        this.afterTag = true;
        this.allWhite = true;
        this.line = 0;
        if (this.level == this.suppressedAtLevel - 1) {
            this.suppressedAtLevel = -1;
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        super.processingInstruction(string, charSequence, n, n2);
        this.afterTag = true;
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        int n3 = 0;
        while (n3 < charSequence.length()) {
            char c = charSequence.charAt(n3);
            if (c == '\n') {
                this.sameline = false;
                ++this.line;
                this.column = 0;
            }
            if (!Character.isWhitespace(c)) {
                this.allWhite = false;
            }
            ++this.column;
            ++n3;
        }
        super.characters(charSequence, n, n2);
        if (!this.allWhite) {
            this.afterTag = false;
        }
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        super.comment(charSequence, n, n2);
        this.afterTag = true;
    }

    /*
     * Unable to fully structure code
     */
    private void indent() throws XPathException {
        if (this.suppressedAtLevel >= 0) {
            return;
        }
        var1_1 = this.level * this.indentSpaces;
        if (this.line <= 0 || this.column <= var1_1) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            this.indentChars = this.indentChars + this.indentChars;
lbl7:
            // 2 sources

            ** while (var1_1 > this.indentChars.length())
        }
lbl8:
        // 1 sources

        if (this.line == 0) {
            super.characters("\n", 0, 0);
        }
        super.characters(this.indentChars.subSequence(0, var1_1), 0, 0);
        this.sameline = false;
    }
}

