/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.value.DerivedAtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class AtomicComparer
implements Comparator,
Serializable {
    private Comparator collator;

    public AtomicComparer(Comparator comparator) {
        this.collator = comparator;
        if (comparator == null) {
            this.collator = CodepointCollator.getInstance();
        }
    }

    public int compare(Object object, Object object2) {
        if (object instanceof DerivedAtomicValue) {
            object = ((DerivedAtomicValue)object).getPrimitiveValue();
        }
        if (object2 instanceof DerivedAtomicValue) {
            object2 = ((DerivedAtomicValue)object2).getPrimitiveValue();
        }
        if (object instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)object).compareTo(object2, this.collator);
        }
        if (object2 instanceof UntypedAtomicValue) {
            return -((UntypedAtomicValue)object2).compareTo(object, this.collator);
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        if (object instanceof StringValue) {
            return this.collator.compare(((StringValue)object).getStringValue(), ((StringValue)object2).getStringValue());
        }
        throw new ClassCastException("Objects are not comparable (" + object.getClass() + ", " + object2.getClass() + ')');
    }

    public boolean comparesEqual(Object object, Object object2) {
        if (object instanceof DerivedAtomicValue) {
            object = ((DerivedAtomicValue)object).getPrimitiveValue();
        }
        if (object2 instanceof DerivedAtomicValue) {
            object2 = ((DerivedAtomicValue)object2).getPrimitiveValue();
        }
        if (object instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)object).compareTo(object2, this.collator) == 0;
        }
        if (object2 instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)object2).compareTo(object, this.collator) == 0;
        }
        if (object instanceof StringValue) {
            return this.collator.compare(((StringValue)object).getStringValue(), ((StringValue)object2).getStringValue()) == 0;
        }
        if (object instanceof String) {
            return this.collator.compare(object, object2) == 0;
        }
        return object.equals(object2);
    }

    public Object getComparisonKey(Object object) {
        if (object instanceof DerivedAtomicValue) {
            object = ((DerivedAtomicValue)object).getPrimitiveValue();
        }
        if (object instanceof StringValue) {
            if (this.collator instanceof Collator) {
                return ((Collator)this.collator).getCollationKey(((StringValue)object).getStringValue());
            }
            return ((StringValue)object).getStringValue();
        }
        return object;
    }
}

