/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.RestrictedStringValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class AnyURIValue
extends AtomicValue {
    private String value;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$StringValue;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;

    public AnyURIValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : Value.trimWhitespace(charSequence).toString();
    }

    public String getStringValue() {
        return this.value;
    }

    public AtomicValue convert(int n, XPathContext xPathContext) throws XPathException {
        switch (n) {
            case 88: 
            case 529: 
            case 643: {
                return this;
            }
            case 642: {
                return new UntypedAtomicValue(this.value);
            }
            case 513: {
                return new StringValue(this.value);
            }
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 563: {
                return new RestrictedStringValue(this.value, n);
            }
        }
        DynamicError dynamicError = new DynamicError("Cannot convert anyURI to " + StandardNames.getDisplayName(n));
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode("FORG0001");
        throw dynamicError;
    }

    public ItemType getItemType() {
        return Type.ANY_URI_TYPE;
    }

    public boolean equals(Object object) {
        return this.value.equals(((AnyURIValue)object).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object convertToJava(Class clazz, Configuration configuration, XPathContext xPathContext) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = AnyURIValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.value;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$StringValue == null ? (class$net$sf$saxon$value$StringValue = AnyURIValue.class$("net.sf.saxon.value.StringValue")) : class$net$sf$saxon$value$StringValue)) {
            return this;
        }
        if (clazz == (class$java$net$URI == null ? (class$java$net$URI = AnyURIValue.class$("java.net.URI")) : class$java$net$URI)) {
            try {
                return new URI(this.value);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new DynamicError("The anyURI value '" + this.value + "' is not an acceptable Java URI");
            }
        }
        if (clazz == (class$java$net$URL == null ? (class$java$net$URL = AnyURIValue.class$("java.net.URL")) : class$java$net$URL)) {
            try {
                return new URL(this.value);
            }
            catch (MalformedURLException malformedURLException) {
                throw new DynamicError("The anyURI value '" + this.value + "' is not an acceptable Java URL");
            }
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = AnyURIValue.class$("java.lang.String")) : class$java$lang$String)) {
            return this.value;
        }
        if (clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = AnyURIValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.value;
        }
        Object object = super.convertToJava(clazz, configuration, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of anyURI to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

