/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.xpath.XPathException;

public abstract class ProxyReceiver
implements Receiver {
    protected Receiver baseReceiver;
    protected Configuration config;
    protected String systemId;
    protected LocationProvider locationProvider;

    public void setSystemId(String string) {
        if (string != this.systemId) {
            this.systemId = string;
            if (this.baseReceiver != null) {
                this.baseReceiver.setSystemId(string);
            }
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setUnderlyingReceiver(Receiver receiver) {
        if (receiver != this.baseReceiver) {
            this.baseReceiver = receiver;
            if (this.config != null) {
                this.baseReceiver.setConfiguration(this.config);
            }
        }
    }

    public Receiver getUnderlyingReceiver() {
        return this.baseReceiver;
    }

    public void setConfiguration(Configuration configuration) {
        if (this.config != configuration) {
            this.config = configuration;
            if (this.baseReceiver != null) {
                this.baseReceiver.setConfiguration(configuration);
            }
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public void open() throws XPathException {
        if (this.baseReceiver == null) {
            throw new IllegalStateException("ProxyReceiver.startDocument(): no underlying emitter provided");
        }
        this.baseReceiver.open();
    }

    public void close() throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.close();
        }
    }

    public void startDocument(int n) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.startDocument(n);
        }
    }

    public void endDocument() throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.endDocument();
        }
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.startElement(n, n2, n3, n4);
        }
    }

    public void namespace(int n, int n2) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.namespace(n, n2);
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.attribute(n, n2, charSequence, n3, n4);
        }
    }

    public void startContent() throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.startContent();
        }
    }

    public void endElement() throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.endElement();
        }
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.characters(charSequence, n, n2);
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.processingInstruction(string, charSequence, n, n2);
        }
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.comment(charSequence, n, n2);
        }
    }

    public void setUnparsedEntity(String string, String string2, String string3) throws XPathException {
        if (this.baseReceiver != null) {
            this.baseReceiver.setUnparsedEntity(string, string2, string3);
        }
    }

    public void setDocumentLocator(LocationProvider locationProvider) {
        this.locationProvider = locationProvider;
        if (this.baseReceiver != null) {
            this.baseReceiver.setDocumentLocator(locationProvider);
        }
    }

    public LocationProvider getDocumentLocator() {
        return this.locationProvider;
    }
}

