/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.XPathException;

public class SequenceChecker
extends ProxyReceiver
implements SequenceReceiver {
    private ItemType itemType;
    private int cardinality;
    private int count = 0;
    private int level = 0;
    private boolean atomize;
    private boolean allowAnyNode;
    private StringBuffer buffer = null;

    public void setRequiredType(SequenceType type) {
        this.itemType = type.getPrimaryType();
        this.cardinality = type.getCardinality();
        this.atomize = this.itemType instanceof AtomicType;
        this.allowAnyNode = this.itemType instanceof AnyItemType || this.itemType instanceof AnyNodeTest;
    }

    public void startElement(int nameCode, int typeCode, int properties) throws XPathException {
        if (this.level++ == 0) {
            if (this.atomize) {
                this.buffer = new StringBuffer();
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new XPathException.Dynamic("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.allowAnyNode && !((NodeTest)this.itemType).matches(1, typeCode & 0xFFFFF, typeCode)) {
                throw new XPathException.Dynamic("This element node does not conform to the required type");
            }
        }
        super.startElement(nameCode, typeCode, properties);
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        if (this.level == 0) {
            if (this.atomize) {
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new XPathException.Dynamic("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.allowAnyNode && !((NodeTest)this.itemType).matches(13, -1, -1)) {
                throw new XPathException.Dynamic("The output sequence is not allowed to contain namespace nodes");
            }
        } else if (this.buffer != null) {
            return;
        }
        super.namespace(namespaceCode, properties);
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int properties) throws XPathException {
        if (this.level == 0) {
            if (this.atomize) {
                this.append(new StringValue(value).convert((AtomicType)this.itemType));
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new XPathException.Dynamic("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.allowAnyNode && !((NodeTest)this.itemType).matches(2, nameCode & 0xFFFFF, typeCode)) {
                throw new XPathException.Dynamic("This attribute node does not conform to the required type");
            }
        } else if (this.buffer != null) {
            return;
        }
        super.attribute(nameCode, typeCode, value, properties);
    }

    public void endElement() throws XPathException {
        --this.level;
        if (this.buffer != null) {
            if (this.level == 0) {
                this.append(new UntypedAtomicValue(this.buffer));
                this.buffer = null;
                return;
            }
            return;
        }
        super.endElement();
    }

    public void characters(CharSequence chars, int properties) throws XPathException {
        if (this.level == 0) {
            if (this.atomize) {
                this.append(new UntypedAtomicValue(chars));
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new XPathException.Dynamic("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.allowAnyNode && !((NodeTest)this.itemType).allowsTextNodes()) {
                throw new XPathException.Dynamic("The output sequence is not allowed to contain text nodes");
            }
        } else if (this.buffer != null) {
            this.buffer.append((Object)chars);
            return;
        }
        super.characters(chars, properties);
    }

    public void processingInstruction(String target, CharSequence data, int properties) throws XPathException {
        if (this.level == 0) {
            if (this.atomize) {
                this.append(new UntypedAtomicValue(data));
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new XPathException.Dynamic("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.allowAnyNode && !((NodeTest)this.itemType).matches(7, -1, -1)) {
                throw new XPathException.Dynamic("The result sequence does not allow processing instructions");
            }
        } else if (this.buffer != null) {
            return;
        }
        super.processingInstruction(target, data, properties);
    }

    public void comment(CharSequence chars, int properties) throws XPathException {
        if (this.level == 0) {
            if (this.atomize) {
                this.append(new UntypedAtomicValue(chars));
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new XPathException.Dynamic("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.allowAnyNode && !((NodeTest)this.itemType).matches(8, -1, -1)) {
                throw new XPathException.Dynamic("The result sequence does not allow comment nodes");
            }
        } else if (this.buffer != null) {
            return;
        }
        super.comment(chars, properties);
    }

    public void append(Item item) throws XPathException {
        if (this.level == 0) {
            if (this.atomize && item instanceof NodeInfo) {
                Item it;
                SequenceIterator iter = item.getTypedValue(this.config);
                while ((it = iter.next()) != null) {
                    this.append(it);
                }
                return;
            }
            if (this.count == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new XPathException.Dynamic("The output sequence contains more than one item, only one is allowed");
            }
            if (!this.itemType.matchesItem(item)) {
                if (item instanceof UntypedAtomicValue) {
                    item = ((UntypedAtomicValue)item).convert((AtomicType)this.itemType);
                } else {
                    throw new XPathException.Dynamic("The output sequence is not allowed to contain items of type " + Type.displayTypeName(item));
                }
            }
        }
        ((SequenceReceiver)this.baseReceiver).append(item);
        ++this.count;
    }

    public void finalCheck() throws XPathException {
        if (this.count == 0 && (this.cardinality & 0x100) == 0) {
            throw new XPathException.Dynamic("The output sequence is not allowed to be empty");
        }
    }
}

