@ECHO OFF
REM Sample script to run sample XSLT transform to demonstrate use
REM of Innodata Isogen Saxon I18N Support extensions.
REM 
REM Copyright (c) 2004 Innodata Isogen
REM
REM NOTE: Requires that the java.exe command be in your PATH

REM use the %~dp0 value to get the grandparent directory of current script (that is, the 
REM directory that contains the entire I18N Support distribution.


set I18N_HOME=%~dp0..\..

GOTO check_args

:usage

ECHO.
ECHO do_xsl {input_xml_document}
ECHO.

GOTO done:

:check_args

IF "" == "%1" goto usage

SET DOC_BASE_PATH=%~dp1
SET OUTPUT_PATH=%DOC_BASE_PATH%
SET OUTFILE=%OUTPUT_PATH%%~n1.html
SET STYLESHEET=%I18N_HOME%\samples\xslts\generate_html_saxon6.xsl

GOTO clean

:clean

IF NOT EXIST %OUTFILE% GOTO do_xsl

ERASE /Q %OUTFILE%

:do_xsl

@ECHO.
@ECHO Applying style sheet %STYLESHEET% to generate output file %OUTFILE% ... 
@ECHO.

java -Dcom.innodata.i18n.home=%I18N_HOME% -cp %I18N_HOME%\i18n_support.jar com.icl.saxon.StyleSheet -o %OUTFILE% %1 %STYLESHEET%

@ECHO.
@ECHO Done.

@ECHO.
@ECHO Launching result file...
@ECHO.

%OUTFILE%

GOTO done

:done

REM End of script