/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DerivedAtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public abstract class ComputedExpression
implements Serializable,
Expression,
InstructionInfoProvider,
Container {
    protected int staticProperties = -1;
    protected int locationId = -1;
    private Container parentExpression;

    public Container getParentExpression() {
        return this.parentExpression;
    }

    public void setParentExpression(Container container) {
        if (this == container) {
            throw new AssertionError((Object)"Incestuous relationship!");
        }
        this.parentExpression = container;
    }

    protected void adoptChildExpression(Expression expression) {
        if (this == expression) {
            throw new AssertionError((Object)"Incestuous relationship!");
        }
        if (expression instanceof ComputedExpression) {
            if (this.parentExpression == null && expression.getParentExpression() != this) {
                this.parentExpression = expression.getParentExpression();
            }
            ((ComputedExpression)expression).setParentExpression(this);
            if (this.locationId == -1) {
                ExpressionTool.copyLocationInfo(expression, this);
            } else if (((ComputedExpression)expression).locationId == -1) {
                ExpressionTool.copyLocationInfo(this, expression);
            }
        }
    }

    public int getImplementationMethod() {
        if (Cardinality.allowsMany(this.getCardinality())) {
            return 1;
        }
        return 0;
    }

    public void setLocationId(int n) {
        this.locationId = n;
    }

    public final int getLocationId() {
        return this.locationId;
    }

    public int getLineNumber() {
        return this.locationId & 0xFFFFF;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getSystemId() {
        Executable executable = this.getExecutable();
        if (executable == null) {
            return null;
        }
        return executable.getLocationMap().getSystemId(this.locationId);
    }

    public final String getPublicId() {
        return null;
    }

    public Executable getExecutable() {
        Container container = this.getParentExpression();
        if (container == null) {
            return null;
        }
        if (container == this) {
            throw new IllegalStateException("Expression cannot contain itself");
        }
        return container.getExecutable();
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        return this;
    }

    public final int getSpecialProperties() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x7F0000;
    }

    public final void computeStaticProperties() {
        this.staticProperties = this.computeDependencies() | this.computeCardinality() | this.computeSpecialProperties();
    }

    public final void resetStaticProperties() {
        this.staticProperties = -1;
    }

    protected abstract int computeCardinality();

    protected int computeSpecialProperties() {
        return 0;
    }

    public int getCardinality() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x700;
    }

    public int getDependencies() {
        if (this.staticProperties == -1) {
            this.computeStaticProperties();
        }
        return this.staticProperties & 0x3F;
    }

    public int computeDependencies() {
        int n = this.getIntrinsicDependencies();
        Iterator iterator = this.iterateSubExpressions();
        while (iterator.hasNext()) {
            n |= (short)((Expression)iterator.next()).getDependencies();
        }
        return n;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Iterator iterateSubExpressions() {
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean markTailFunctionCalls() {
        return false;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.iterate(xPathContext).next();
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        StringValue stringValue;
        Item item = this.evaluateItem(xPathContext);
        if (item instanceof DerivedAtomicValue) {
            item = ((DerivedAtomicValue)item).getPrimitiveValue();
        }
        if ((stringValue = (StringValue)item) == null) {
            return "";
        }
        return stringValue.getStringValue();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (!Cardinality.allowsMany(this.getCardinality())) {
            Item item = this.evaluateItem(xPathContext);
            return SingletonIterator.makeIterator(item);
        }
        throw new UnsupportedOperationException("Non-singleton expression " + this.getClass() + " must supply iterate() method");
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate(xPathContext));
    }

    public void process(XPathContext xPathContext) throws XPathException {
        int n = this.getImplementationMethod();
        switch (n) {
            case 0: {
                Item item = this.evaluateItem(xPathContext);
                Instruction.appendItem(item, xPathContext.getReceiver(), this.locationId);
                break;
            }
            case 1: {
                Item item;
                SequenceIterator sequenceIterator = this.iterate(xPathContext);
                while ((item = sequenceIterator.next()) != null) {
                    Instruction.appendItem(item, xPathContext.getReceiver(), this.locationId);
                }
                break;
            }
            case 2: {
                this.dynamicError("process() is not implemented in the subclass " + this.getClass(), xPathContext);
            }
        }
    }

    protected void dynamicError(String string, XPathContext xPathContext) throws DynamicError {
        DynamicError dynamicError = new DynamicError(string, this.getSourceLocator());
        dynamicError.setXPathContext(xPathContext);
        throw dynamicError;
    }

    protected void dynamicError(String string, String string2, XPathContext xPathContext) throws DynamicError {
        DynamicError dynamicError = new DynamicError(string, this.getSourceLocator());
        dynamicError.setXPathContext(xPathContext);
        dynamicError.setErrorCode(string2);
        throw dynamicError;
    }

    protected void typeError(String string, XPathContext xPathContext) throws DynamicError {
        DynamicError dynamicError = new DynamicError(string, this.getSourceLocator());
        dynamicError.setIsTypeError(true);
        dynamicError.setXPathContext(xPathContext);
        throw dynamicError;
    }

    private SourceLocator getSourceLocator() {
        return ExpressionTool.getLocator(this);
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(this.getConstructType());
        instructionDetails.setProperty("expression", this);
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setColumnNumber(this.getColumnNumber());
        if (this instanceof Assignation) {
            instructionDetails.setObjectNameCode(((Assignation)this).getVariableNameCode());
        }
        return instructionDetails;
    }

    protected int getConstructType() {
        return 2098;
    }
}

