/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.LocaleUtility;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleWrapper
extends UResourceBundle {
    ResourceBundle bundle = null;

    public ResourceBundleWrapper(String baseName, String localeID, ClassLoader loader) {
        if (baseName.indexOf(46) > -1) {
            this.bundle = ResourceBundle.getBundle(baseName, LocaleUtility.getLocaleFromName(localeID), loader);
        } else {
            this.bundle = ICULocaleData.getResourceBundle(baseName, LocaleUtility.getLocaleFromName(localeID));
            if (this.bundle == null) {
                throw new MissingResourceException("Can't find the bundle " + baseName + ", locale " + localeID, this.getClass().getName(), localeID);
            }
        }
    }

    protected Object handleGetObject(String key) {
        return this.bundle.getObject(key);
    }

    public Enumeration getKeys() {
        return this.bundle.getKeys();
    }

    protected String getLocaleID() {
        return this.bundle.getLocale().toString();
    }

    protected String getBaseName() {
        return this.bundle.getClass().getName().replace('.', '/');
    }

    public ULocale getULocale() {
        return new ULocale(this.bundle.getLocale());
    }

    public UResourceBundle getParent() {
        return (UResourceBundle)this.parent;
    }
}

