/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.xpath.XPathException;

public class ResolveQName
extends SystemFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo;
        String[] stringArray;
        NamePool namePool = xPathContext.getController().getNamePool();
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        String string = atomicValue.getStringValue();
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            this.dynamicError(qNameException.getMessage(), "FOCA0002", xPathContext);
            return null;
        }
        if (stringArray[0].equals("")) {
            return new QNameValue("", null, stringArray[1]);
        }
        NodeInfo nodeInfo2 = (NodeInfo)this.argument[1].evaluateItem(xPathContext);
        AxisIterator axisIterator = nodeInfo2.iterateAxis((byte)8);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            String string2 = nodeInfo.getLocalPart();
            if (!string2.equals(stringArray[0])) continue;
            return new QNameValue(string2, nodeInfo.getStringValue(), stringArray[1]);
        }
        this.dynamicError("Namespace prefix '" + stringArray[0] + "' is not in scope for the selected element", "FONS0004", xPathContext);
        return null;
    }
}

