/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.Serializable;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Loader;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.Version;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.functions.ExtensionFunctionFactory;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.instruct.Debugger;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaMarker;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.xpath.XPathException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Configuration
implements Serializable {
    private transient URIResolver resolver;
    protected transient ErrorListener listener;
    private int treeModel = 1;
    private boolean lineNumbering = false;
    private TraceListener traceListener = null;
    private FunctionLibrary extensionBinder;
    protected VendorFunctionLibrary vendorFunctionLibrary;
    private int recoveryPolicy = 1;
    private String messageEmitterClass = "net.sf.saxon.event.MessageEmitter";
    private String sourceParserClass;
    private String styleParserClass;
    private transient OutputURIResolver outputURIResolver;
    private boolean timing = false;
    private boolean allowExternalFunctions = true;
    private boolean traceExternalFunctions = false;
    private boolean validation = false;
    private NamePool targetNamePool = null;
    private boolean stripsAllWhiteSpace = false;
    private int hostLanguage = 10;
    private boolean schemaValidation = false;
    private boolean validationWarnings = false;
    private boolean retainDTDattributeTypes = false;
    private Debugger debugger = null;
    protected Optimizer optimizer = null;
    private ExtensionFunctionFactory extensionFunctionFactory = new ExtensionFunctionFactory();
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    public static final int XSLT = 10;
    public static final int XQUERY = 11;
    public static final int XML_SCHEMA = 12;

    public Configuration() {
        this.targetNamePool = NamePool.getDefaultNamePool();
        this.extensionBinder = new JavaExtensionLibrary(this);
    }

    public String getProductTitle() {
        return "Saxon " + Version.getProductVersion() + " from Saxonica";
    }

    public boolean isSchemaAware(int n) {
        return false;
    }

    public void displayLicenseMessage() {
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int n) {
        this.hostLanguage = n;
    }

    public URIResolver getURIResolver() {
        if (this.resolver == null) {
            this.resolver = new StandardURIResolver(this);
        }
        return this.resolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.resolver = uRIResolver;
    }

    public ErrorListener getErrorListener() {
        if (this.listener == null) {
            this.listener = new StandardErrorListener();
        }
        return this.listener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.listener = errorListener;
    }

    public int getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(int n) {
        this.treeModel = n;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering;
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
    }

    public void setExtensionBinder(FunctionLibrary functionLibrary) {
        this.extensionBinder = functionLibrary;
    }

    public FunctionLibrary getExtensionBinder() {
        return this.extensionBinder;
    }

    public VendorFunctionLibrary getVendorFunctionLibrary() {
        if (this.vendorFunctionLibrary == null) {
            this.vendorFunctionLibrary = new VendorFunctionLibrary();
        }
        return this.vendorFunctionLibrary;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setRecoveryPolicy(int n) {
        this.recoveryPolicy = n;
    }

    public String getMessageEmitterClass() {
        return this.messageEmitterClass;
    }

    public void setMessageEmitterClass(String string) {
        this.messageEmitterClass = string;
    }

    public String getSourceParserClass() {
        return this.sourceParserClass;
    }

    public void setSourceParserClass(String string) {
        this.sourceParserClass = string;
    }

    public String getStyleParserClass() {
        return this.styleParserClass;
    }

    public void setStyleParserClass(String string) {
        this.styleParserClass = string;
    }

    public OutputURIResolver getOutputURIResolver() {
        if (this.outputURIResolver == null) {
            this.outputURIResolver = StandardOutputResolver.getInstance();
        }
        return this.outputURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void setTiming(boolean bl) {
        this.timing = bl;
    }

    public boolean isAllowExternalFunctions() {
        return this.allowExternalFunctions;
    }

    public void setAllowExternalFunctions(boolean bl) {
        this.allowExternalFunctions = bl;
    }

    public boolean isTraceExternalFunctions() {
        return this.traceExternalFunctions;
    }

    public void setRetainDTDAttributeTypes(boolean bl) throws TransformerFactoryConfigurationError {
        if (bl && !this.isSchemaAware(12)) {
            throw new TransformerFactoryConfigurationError("Retaining DTD attribute types requires the schema-aware product");
        }
        this.retainDTDattributeTypes = bl;
    }

    public boolean isRetainDTDAttributeTypes() {
        return this.retainDTDattributeTypes;
    }

    public void setTraceExternalFunctions(boolean bl) {
        this.traceExternalFunctions = bl;
    }

    public ExtensionFunctionFactory getExtensionFunctionFactory() {
        return this.extensionFunctionFactory;
    }

    public void setExtensionFunctionFactory(ExtensionFunctionFactory extensionFunctionFactory) {
        this.extensionFunctionFactory = extensionFunctionFactory;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean bl) {
        this.validation = bl;
    }

    public boolean isSchemaValidation() {
        return this.schemaValidation;
    }

    public void setSchemaValidation(boolean bl) {
        if (bl && !this.isSchemaAware(12)) {
            this.needSchemaAwareVersion();
        }
        this.schemaValidation = bl;
    }

    public void setValidationWarnings(boolean bl) {
        this.validationWarnings = bl;
    }

    public boolean isValidationWarnings() {
        return this.validationWarnings;
    }

    public void reportValidationError(ValidationException validationException, boolean bl) throws ValidationException {
        if (this.validationWarnings && bl) {
            try {
                this.getErrorListener().warning(validationException);
            }
            catch (TransformerException transformerException) {
                if (transformerException instanceof ValidationException) {
                    throw (ValidationException)transformerException;
                }
                if (transformerException.getException() instanceof ValidationException) {
                    throw (ValidationException)transformerException.getException();
                }
                throw new ValidationException(transformerException);
            }
        } else {
            throw validationException;
        }
    }

    public NamePool getNamePool() {
        return this.targetNamePool;
    }

    public void setNamePool(NamePool namePool) {
        this.targetNamePool = namePool;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.stripsAllWhiteSpace;
    }

    public void setStripsAllWhiteSpace(boolean bl) {
        this.stripsAllWhiteSpace = bl;
    }

    public XMLReader getSourceParser() throws TransformerFactoryConfigurationError {
        XMLReader xMLReader;
        if (this.getSourceParserClass() != null) {
            xMLReader = Configuration.makeParser(this.getSourceParserClass());
        } else {
            try {
                xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new TransformerFactoryConfigurationError(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new TransformerFactoryConfigurationError(sAXException);
            }
        }
        if (this.isValidation()) {
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXException sAXException) {
                throw new TransformerFactoryConfigurationError("The XML parser does not support validation");
            }
        }
        return xMLReader;
    }

    public XMLReader getStyleParser() throws TransformerFactoryConfigurationError {
        XMLReader xMLReader;
        if (this.getStyleParserClass() != null) {
            xMLReader = Configuration.makeParser(this.getStyleParserClass());
        } else {
            try {
                xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new TransformerFactoryConfigurationError(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new TransformerFactoryConfigurationError(sAXException);
            }
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new TransformerFactoryConfigurationError(sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new TransformerFactoryConfigurationError(sAXNotSupportedException);
        }
        return xMLReader;
    }

    public String readSchema(String string, String string2, String string3) throws TransformerConfigurationException {
        this.needSchemaAwareVersion();
        return null;
    }

    private void needSchemaAwareVersion() {
        throw new UnsupportedOperationException("You need the schema-aware version of Saxon for this operation");
    }

    public void addSchema(Source source) throws SchemaException {
        this.needSchemaAwareVersion();
    }

    public void addSchema(SchemaMarker schemaMarker) throws TransformerConfigurationException {
        this.needSchemaAwareVersion();
    }

    public SchemaMarker getSchema(String string) {
        return null;
    }

    public SchemaDeclaration getElementDeclaration(int n) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(int n) {
        return null;
    }

    public SchemaType getSchemaType(int n) {
        if (n < 1023) {
            return BuiltInSchemaFactory.getSchemaType(n);
        }
        return null;
    }

    public Receiver getDocumentValidator(Receiver receiver, String string, NamePool namePool, int n) {
        return receiver;
    }

    public Receiver getElementValidator(Receiver receiver, int n, int n2, SchemaType schemaType, int n3, NamePool namePool) throws XPathException {
        return receiver;
    }

    public long validateAttribute(int n, CharSequence charSequence, int n2) throws ValidationException {
        return -1L;
    }

    public SchemaType getAttributeType(SchemaDeclaration schemaDeclaration) {
        this.needSchemaAwareVersion();
        return null;
    }

    public SchemaType getElementType(SchemaDeclaration schemaDeclaration) {
        this.needSchemaAwareVersion();
        return null;
    }

    public NodeTest makeSubstitutionGroupTest(SchemaDeclaration schemaDeclaration) {
        this.needSchemaAwareVersion();
        return null;
    }

    public static XMLReader makeParser(String string) throws TransformerFactoryConfigurationError {
        Object object;
        try {
            object = Loader.getInstance(string);
        }
        catch (XPathException xPathException) {
            throw new TransformerFactoryConfigurationError(xPathException);
        }
        if (object instanceof XMLReader) {
            return (XMLReader)object;
        }
        throw new TransformerFactoryConfigurationError("Class " + string + " is not a SAX2 XMLReader");
    }

    public static Locale getLocale(String string) {
        String string2;
        String string3;
        int n = string.indexOf("-");
        if (n < 1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(1, n);
            string2 = string.substring(n + 1);
        }
        return new Locale(string3, string2);
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public SlotManager makeSlotManager() {
        if (this.debugger == null) {
            return new SlotManager();
        }
        return this.debugger.makeSlotManager();
    }

    public Optimizer getOptimizer() {
        if (this.optimizer == null) {
            this.optimizer = new Optimizer();
        }
        return this.optimizer;
    }
}

