/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.xpath.XPathException;

public class CurrentGroup
extends SystemFunction
implements XSLTFunction {
    public static final int CURRENT_GROUP = 0;
    public static final int CURRENT_GROUPING_KEY = 1;

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        if (this.operation == 1) {
            GroupIterator groupIterator = xPathContext.getCurrentGroupIterator();
            if (groupIterator == null) {
                return null;
            }
            return groupIterator.getCurrentGroupingKey();
        }
        return super.evaluateItem(xPathContext);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        if (this.operation == 0) {
            GroupIterator groupIterator = xPathContext.getCurrentGroupIterator();
            if (groupIterator == null) {
                return EmptyIterator.getInstance();
            }
            return groupIterator.iterateCurrentGroup();
        }
        return super.iterate(xPathContext);
    }

    public int getIntrinsicDependencies() {
        return 32;
    }
}

